class ConsultingHorizontalTabs extends elementorModules.frontend.handlers.Base {
    onInit() {
        let $ = jQuery;
        let tabs = $('.consulting-horizontal-tabs-container');
        $.each(tabs, function(tab) {
            let id = $(this).data('id');
            let active_tab = $(this).data('active-tab');

            $( ".consulting-horizontal-tabs-container[data-id=" + id + "]" ).tabs({
                collapsible: true,
                active: active_tab - 1
            });
        });
    }
}

jQuery(window).on('elementor/frontend/init', () => {
    const addHandler = ($element) => {
        elementorFrontend.elementsHandler.addHandler(ConsultingHorizontalTabs, {
            $element,
        });
    };
    elementorFrontend.hooks.addAction('frontend/element_ready/stm_horizontal_tabs.default', addHandler);
});