<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;

class Elementor_STM_Horizontal_Tabs extends \Elementor\Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );
		wp_register_style( 'consulting-horizontal-tabs', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/horizontal-tabs/horizontal-tabs.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_script( 'consulting-horizontal-tabs', CONSULTING_ELEMENTOR_URL . 'assets/js/widgets/horizontal-tabs.js', array( 'elementor-frontend', 'jquery' ), CONSULTING_ELEMENTOR_VERSION, true );
	}

	public function get_name() {
		return 'stm_horizontal_tabs';
	}

	public function get_title() {
		return esc_html__( 'Horizontal Tabs', 'consulting-elementor-widgets' );
	}

	public function get_icon() {
		return 'consulting-eicon-horizontal-tabs';
	}

	public function get_categories() {
		return array( 'consulting-widgets' );
	}

	public function get_script_depends() {
		return array( 'jquery-ui-tabs', 'jquery-effects-core', 'consulting-horizontal-tabs' );
	}

	public function get_style_depends() {
		return array( 'consulting-horizontal-tabs' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => __( 'General', 'consulting-elementor-widgets' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'tab_title',
			array(
				'label'       => __( 'Tab Title', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'show_icon',
			array(
				'label'        => __( 'Use Icon', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'consulting-elementor-widgets' ),
				'label_off'    => __( 'No', 'consulting-elementor-widgets' ),
				'default'      => 'no',
				'return_value' => 'yes',
			)
		);

		$repeater->add_control(
			'tab_icon',
			array(
				'label'       => esc_html__( 'Icon', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'default'     => array(
					'value'   => 'fas fa-briefcase',
					'library' => 'fa-solid',
				),
				'label_block' => false,
				'condition'   => array(
					'show_icon' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'tab_icon_position',
			array(
				'label'     => esc_html__( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'before',
				'options'   => array(
					'before' => __( 'Before', 'consulting-elementor-widgets' ),
					'after'  => __( 'After', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'show_icon' => 'yes',
				),
				'separator' => 'after',
			)
		);

		$repeater->add_control(
			'content_type',
			array(
				'label'   => __( 'Content Type', 'consulting-elementor-widgets' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => array(
					'default'  => __( 'Default (Text Editor)', 'consulting-elementor-widgets' ),
					'template' => __( 'Elementor Template', 'consulting-elementor-widgets' ),
				),
			)
		);

		$results[] = esc_html__( 'Choose Template', 'consulting-elementor-widgets' );

		$templates = get_posts(
			array(
				'posts_per_page' => - 1,
				'post_type'      => 'elementor_library',
			)
		);

		foreach ( $templates as $template ) {
			$document = \Elementor\plugin::instance()->documents->get( $template->ID );
			if ( $document ) {
				$text                     = esc_html( $template->post_title ) . ' (' . $document->get_post_type_title() . ')';
				$results[ $template->ID ] = $text;
			}
		}

		$repeater->add_control(
			'tab_template',
			array(
				'label'     => esc_html__( 'Choose Template', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '',
				'options'   => $results,
				'condition' => array(
					'content_type' => 'template',
				),
				'separator' => 'after',
			)
		);

		$repeater->add_control(
			'default_content',
			array(
				'label'     => __( 'Content', 'consulting-elementor-widgets' ),
				'type'      => Controls_Manager::WYSIWYG,
				'condition' => array(
					'content_type' => 'default',
				),
			)
		);

		$this->add_control(
			'tabs_items',
			array(
				'label'       => __( 'Items', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array(
						'tab_title' => __( 'Tab #1', 'consulting-elementor-widgets' ),
					),
				),
				'title_field' => '{{{ tab_title }}}',
			)
		);

		$this->add_control(
			'navigation_alignment',
			array(
				'label'   => __( 'Tabs Alignment', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => array(
					'left'   => array(
						'title' => __( 'Left', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => __( 'Right', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default' => 'left',
				'toggle'  => false,
			)
		);

		$this->add_control(
			'navigation_background_transparent',
			array(
				'label'        => __( 'Tabs Background Transparent', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'consulting-elementor-widgets' ),
				'label_off'    => __( 'No', 'consulting-elementor-widgets' ),
				'default'      => 'no',
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'active_tab',
			array(
				'label'   => __( 'Active Tab', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 1,
				'step'    => 1,
				'default' => 1,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'tabs_section',
			array(
				'label' => __( 'Tabs Container', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'navigation_background_color',
			array(
				'label'     => __( 'Tabs Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-container .consulting-horizontal-tabs-navigation ul' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'navigation_background_transparent!' => 'yes',
				),
			)
		);

		$this->add_control(
			'tab_titles_spacing',
			array(
				'label'      => __( 'Space Between Tabs', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-container .consulting-horizontal-tabs-navigation ul' => 'gap: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'navigation_bottom_spacing',
			array(
				'label'      => __( 'Tabs Margin', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-container .consulting-horizontal-tabs-navigation ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'active_section',
			array(
				'label' => __( 'Active Tab', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'active_tab_title_typography',
				'label'    => __( 'Title Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-active a',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'active_tab_title_color',
			array(
				'label'     => __( 'Title Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-active a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'active_tab_bg_color',
			array(
				'label'     => __( 'Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-active a' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'active_tab_icon_color',
			array(
				'label'     => __( 'Icon Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-active a .tab-item-icon' => 'color: {{VALUE}}; fill: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'active_tab_padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-active a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'active_tab_border_radius',
			array(
				'label'      => __( 'Border Radius', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-active a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'inactive_section',
			array(
				'label' => __( 'Inactive Tab', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'inactive_tab_title_typography',
				'label'    => __( 'Title Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li:not(.ui-tabs-active) a',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'inactive_tab_title_color',
			array(
				'label'     => __( 'Title Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li:not(.ui-tabs-active) a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'inactive_tab_icon_color',
			array(
				'label'     => __( 'Icon Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li:not(.ui-tabs-active) a .tab-item-icon' => 'color: {{VALUE}}; fill: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'inactive_tab_padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li:not(.ui-tabs-active) a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'inactive_tab_border_radius',
			array(
				'label'      => __( 'Border Radius', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li:not(.ui-tabs-active) a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'hover_section',
			array(
				'label' => __( 'Hover Tab', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'active_tab_title_hover_color',
			array(
				'label'     => __( 'Title Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-tab.ui-state-hover a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'active_tab_bg_hover_color',
			array(
				'label'     => __( 'Background Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-tab.ui-state-hover a' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'active_tab_icon_hover_color',
			array(
				'label'     => __( 'Icon Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-horizontal-tabs-navigation ul li.ui-tabs-tab.ui-state-hover a .tab-item-icon' => 'color: {{VALUE}}; fill: {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings        = $this->get_settings_for_display();
		$unique_id       = uniqid( 'consulting-horizontal-tabs' );
		$tabs_items      = $settings['tabs_items'];
		$navigation_css  = isset( $settings['navigation_alignment'] ) ? 'navigation-alignment-' . $settings['navigation_alignment'] : 'navigation-alignment-center';
		$navigation_css .= isset( $settings['navigation_background_transparent'] ) && 'yes' === $settings['navigation_background_transparent'] ? ' navigation-background-transparent' : '';

		?>
		<div data-id="<?php echo esc_attr( $unique_id ); ?>" class="consulting-horizontal-tabs-container" data-active-tab="<?php echo isset( $settings['active_tab'] ) ? esc_attr( $settings['active_tab'] ) : '1'; ?>">
			<div class="consulting-horizontal-tabs-navigation">
				<ul class="<?php echo esc_attr( $navigation_css ); ?>">
					<?php
					foreach ( $tabs_items as $tabs_item ) {
						$tab_id = 'consulting-tab-' . $tabs_item['_id'];
						?>
						<li class="<?php echo isset( $tabs_item['tab_icon_position'] ) ? 'tab-icon-position-' . esc_attr( $tabs_item['tab_icon_position'] ) : 'tab-icon-position-before'; ?>">
							<a href="#<?php echo esc_attr( $tab_id ); ?>">
								<?php
								if ( ! empty( $tabs_item['tab_icon'] ) ) {
									echo '<span class="tab-item-icon">';
									\Elementor\Icons_Manager::render_icon(
										$tabs_item['tab_icon'],
										array(
											'aria-hidden' => 'true',
											'class'       => 'tab_icon',
										)
									);
									echo '</span>';
								}
								echo '<span class="tab-item-title">' . esc_html( $tabs_item['tab_title'] ) . '</span>';
								?>
							</a>
						</li>
						<?php
					}
					?>
				</ul>
			</div>
			<div class="consulting-horizontal-tabs-wrapper">
				<?php
				foreach ( $tabs_items as $tabs_item ) {
					$tab_id = 'consulting-tab-' . $tabs_item['_id'];
					?>
					<div class="consulting-tab-item-wrapper" id="<?php echo esc_attr( $tab_id ); ?>">
						<?php
						if ( 'template' === $tabs_item['content_type'] ) {
							echo Elementor\plugin::instance()->frontend->get_builder_content_for_display( $tabs_item['tab_template'] ); //phpcs:ignore
						} else {
							echo do_shortcode( $tabs_item['default_content'] );
						}
						?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
}
