<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;

class Elementor_STM_Icon_Box extends \Elementor\Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );
		wp_register_style( 'consulting-icon-box-standard', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/icon-box/standard.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-icon-box-boxed-top-icon', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/icon-box/boxed-top-icon.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-icon-box-boxed-side-icon', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/icon-box/boxed-side-icon.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-icon-box-boxed-double-icon', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/icon-box/boxed-double-icon.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-icon-box-with-tabs', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/icon-box/with-tabs.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_script( 'consulting-icon-box', CONSULTING_ELEMENTOR_URL . 'assets/js/widgets/icon-box.js', array( 'elementor-frontend', 'jquery' ), CONSULTING_ELEMENTOR_VERSION, true );
	}

	public function get_style_depends() {
		return array(
			'consulting-icon-box-standard',
			'consulting-icon-box-boxed-top-icon',
			'consulting-icon-box-boxed-side-icon',
			'consulting-icon-box-boxed-double-icon',
			'consulting-icon-box-with-tabs',
		);
	}

	public function get_script_depends() {
		return array( 'consulting-icon-box' );
	}

	public function get_name() {
		return 'stm_icon_box';
	}

	public function get_title() {
		return esc_html__( 'Icon Box', 'consulting-elementor-widgets' );
	}

	public function get_icon() {
		return 'consulting-eicon-iconbox';
	}

	public function get_categories() {
		return array( 'consulting-widgets' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'General', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'box_style',
			array(
				'label'     => __( 'Style', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'style_1',
				'options'   => array(
					'standard'          => esc_html__( 'Standard', 'consulting-elementor-widgets' ),
					'boxed_top_icon'    => esc_html__( 'Boxed Top Icon', 'consulting-elementor-widgets' ),
					'boxed_side_icon'   => esc_html__( 'Boxed Side Icon', 'consulting-elementor-widgets' ),
					'boxed_double_icon' => esc_html__( 'Boxed Double Icon', 'consulting-elementor-widgets' ),
					'with_tabs'         => esc_html__( 'With Tabs', 'consulting-elementor-widgets' ),
					'style_1'           => esc_html__( 'Style 1', 'consulting-elementor-widgets' ),
					'style_2'           => esc_html__( 'Style 2', 'consulting-elementor-widgets' ),
					'style_3'           => esc_html__( 'Style 3', 'consulting-elementor-widgets' ),
					'style_4'           => esc_html__( 'Style 4', 'consulting-elementor-widgets' ),
					'style_5'           => esc_html__( 'Style 5', 'consulting-elementor-widgets' ),
					'style_6'           => esc_html__( 'Style 6', 'consulting-elementor-widgets' ),
					'style_7'           => esc_html__( 'Style 7', 'consulting-elementor-widgets' ),
					'style_8'           => esc_html__( 'Style 8', 'consulting-elementor-widgets' ),
					'style_9'           => esc_html__( 'Style 9', 'consulting-elementor-widgets' ),
					'style_10'          => esc_html__( 'Style 10', 'consulting-elementor-widgets' ),
				),
				'separator' => 'after',
			)
		);

		$this->add_control(
			'with_tabs_style',
			array(
				'label'     => __( 'Appearance', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'left',
				'options'   => array(
					'left'  => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'top'   => esc_html__( 'Top', 'consulting-elementor-widgets' ),
					'right' => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'     => __( 'Title', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA,
				'default'   => esc_html__( 'Integrity Properties', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style' => array(
						'style_1',
						'style_2',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
					),
				),
			)
		);

		$this->add_control(
			'title_font_size',
			array(
				'label'     => __( 'Title Font Size', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => array(
					'box_style' => array( 'style_1', 'style_2', 'style_5', 'style_6', 'style_10' ),
				),
			)
		);

		$this->add_control(
			'title_line_height',
			array(
				'label'     => __( 'Title line-height', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => array(
					'box_style' => array( 'style_1', 'style_2', 'style_5', 'style_6', 'style_10' ),
				),
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'Title color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'base',
				'options'   => array_flip(
					array(
						esc_html__( 'Base', 'consulting-elementor-widgets' )      => 'base',
						esc_html__( 'Secondary', 'consulting-elementor-widgets' ) => 'secondary',
						esc_html__( 'Third', 'consulting-elementor-widgets' )     => 'third',
						esc_html__( 'Custom', 'consulting-elementor-widgets' )    => 'custom',
					)
				),
				'condition' => array(
					'box_style!' => array(
						'standard',
						'boxed_top_icon',
						'boxed_side_icon',
						'boxed_double_icon',
						'with_tabs',
					),
				),
			)
		);

		$this->add_control(
			'title_color_custom',
			array(
				'label'     => __( 'Title Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => array(
					'title_color' => array( 'custom' ),
				),
			)
		);

		$this->add_control(
			'hide_title_line',
			array(
				'label'        => __( 'Hide Title Line', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'hide_title_line',
				'condition'    => array(
					'box_style' => array( 'style_1', 'style_2' ),
				),
			)
		);

		$this->add_control(
			'enable_hexagon',
			array(
				'label'        => __( 'Enable hexagon', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'enable',
				'condition'    => array(
					'box_style' => array( 'style_1' ),
				),
			)
		);

		$this->add_control(
			'enable_hexagon_animation',
			array(
				'label'        => __( 'Enable Hexagon Hover Animation', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'enable',
				'condition'    => array(
					'box_style' => array( 'style_1' ),
				),
			)
		);

		$this->add_control(
			'v_align_middle',
			array(
				'label'        => __( 'Vertical Middle Align', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'enable',
				'condition'    => array(
					'box_style' => array( 'style_1' ),
				),
			)
		);

		$this->add_control(
			'add_link',
			array(
				'label'        => __( 'Add Box link', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'enable',
				'separator'    => 'before',
				'condition'    => array(
					'box_style!' => array(
						'with_tabs',
						'standard',
						'boxed_top_icon',
						'boxed_side_icon',
						'boxed_double_icon',
					),
				),
			)
		);

		$this->add_control(
			'link',
			array(
				'label'         => __( 'Link', 'consulting-elementor-widgets' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'show_external' => true,
				'condition'     => array(
					'add_link'   => 'enable',
					'box_style!' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'icon',
			array(
				'label'                  => __( 'Icon', 'consulting-elementor-widgets' ),
				'type'                   => \Elementor\Controls_Manager::ICONS,
				'default'                => array(
					'value'   => 'fas fa-star',
					'library' => 'solid',
				),
				'skin'                   => 'inline',
				'exclude_inline_options' => array( 'svg' ),
				'condition'              => array(
					'box_style!' => array(
						'standard',
						'boxed_top_icon',
						'boxed_side_icon',
						'boxed_double_icon',
						'with_tabs',
					),
				),
			)
		);

		$this->add_control(
			'style',
			array(
				'label'     => __( 'Icon - Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'base',
				'options'   => array_flip(
					array(
						esc_html__( 'Icon Top', 'consulting-elementor-widgets' )              => 'icon_top',
						esc_html__( 'Icon Top Transparent', 'consulting-elementor-widgets' )  => 'icon_top_transparent',
						esc_html__( 'Icon Left', 'consulting-elementor-widgets' )             => 'icon_left',
						esc_html__( 'Icon Left Transparent', 'consulting-elementor-widgets' ) => 'icon_left_transparent',
					)
				),
				'condition' => array(
					'box_style' => array( 'style_1' ),
				),
			)
		);

		$this->add_control(
			'icon_size',
			array(
				'label'     => __( 'Icon Size', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 25,
				'condition' => array(
					'box_style!' => array(
						'standard',
						'boxed_top_icon',
						'boxed_side_icon',
						'boxed_double_icon',
						'with_tabs',
					),
				),
			)
		);

		$this->add_control(
			'icon_line_height',
			array(
				'label'     => __( 'Icon Line height', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 65,
				'condition' => array(
					'box_style' => array( 'style_3', 'style_4' ),
				),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon - Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'default',
				'options'   => array_flip(
					array(
						esc_html__( 'Default', 'consulting-elementor-widgets' )   => 'default',
						esc_html__( 'Base', 'consulting-elementor-widgets' )      => 'base',
						esc_html__( 'Secondary', 'consulting-elementor-widgets' ) => 'secondary',
						esc_html__( 'Third', 'consulting-elementor-widgets' )     => 'third',
						esc_html__( 'Custom', 'consulting-elementor-widgets' )    => 'custom',
					)
				),
				'condition' => array(
					'box_style!' => array(
						'standard',
						'boxed_top_icon',
						'boxed_side_icon',
						'boxed_double_icon',
						'with_tabs',
					),
				),
			)
		);

		$this->add_control(
			'icon_color_custom',
			array(
				'label'     => __( 'Icon - Color Custom', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => array(
					'icon_color' => array( 'custom' ),
				),
			)
		);

		$this->add_control(
			'icon_bg_color',
			array(
				'label'     => __( 'Icon - Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'base_bg',
				'options'   => array_flip(
					array(
						esc_html__( 'Base', 'consulting-elementor-widgets' )      => 'base_bg',
						esc_html__( 'Secondary', 'consulting-elementor-widgets' ) => 'secondary_bg',
						esc_html__( 'Third', 'consulting-elementor-widgets' )     => 'third_bg',
						esc_html__( 'Custom', 'consulting-elementor-widgets' )    => 'custom',
					)
				),
				'condition' => array(
					'box_style' => array( 'style_1' ),
				),
			)
		);

		$this->add_control(
			'icon_bg_color_custom',
			array(
				'label'     => __( 'Icon - Background Color Custom', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => array(
					'icon_bg_color' => array( 'custom' ),
				),
			)
		);

		$this->add_control(
			'icon_border_color',
			array(
				'label'     => __( 'Icon - Border Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'base_bg',
				'options'   => array_flip(
					array(
						esc_html__( 'Base', 'consulting-elementor-widgets' )      => 'base_bg',
						esc_html__( 'Secondary', 'consulting-elementor-widgets' ) => 'secondary_bg',
						esc_html__( 'Third', 'consulting-elementor-widgets' )     => 'third_bg',
						esc_html__( 'Custom', 'consulting-elementor-widgets' )    => 'custom',
					)
				),
				'condition' => array(
					'box_style' => array( 'style_3' ),
				),
			)
		);

		$this->add_control(
			'icon_border_color_custom',
			array(
				'label'     => __( 'Icon - Border Custom', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => array(
					'title_color' => array( 'custom' ),
				),
			)
		);

		$this->add_control(
			'icon_height',
			array(
				'label'     => __( 'Icon height', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 65,
				'condition' => array(
					'style' => array( 'icon_top', 'icon_top_transparent' ),
				),
			)
		);

		$this->add_control(
			'icon_width',
			array(
				'label'     => __( 'Icon width', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 50,
				'condition' => array(
					'style' => array( 'icon_left', 'icon_left_transparent' ),
				),
			)
		);

		$this->add_control(
			'icon_width_wr',
			array(
				'label'     => __( 'Icon Wrapper Width', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 65,
				'condition' => array(
					'box_style' => array( 'style_2' ),
				),
			)
		);

		$this->add_control(
			'icon_2',
			array(
				'label'                  => __( 'Icon', 'consulting-elementor-widgets' ),
				'type'                   => \Elementor\Controls_Manager::ICONS,
				'default'                => array(
					'value'   => 'fas fa-star',
					'library' => 'solid',
				),
				'skin'                   => 'inline',
				'exclude_inline_options' => array( 'svg' ),
				'condition'              => array(
					'box_style'  => array( 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon' ),
					'box_style!' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'icon_shape_1',
			array(
				'label'     => __( 'Icon Shape', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'default',
				'options'   => array(
					'default'       => esc_html__( 'Default', 'consulting-elementor-widgets' ),
					'circle_1'      => esc_html__( 'Circle', 'consulting-elementor-widgets' ),
					'hexagon'       => esc_html__( 'Hexagon', 'consulting-elementor-widgets' ),
					'linear_circle' => esc_html__( 'Linear Circle', 'consulting-elementor-widgets' ),
					'strips'        => esc_html__( 'Strips', 'consulting-elementor-widgets' ),
					'points'        => esc_html__( 'Points', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => 'standard',
				),
			)
		);

		$this->add_control(
			'icon_shape_2',
			array(
				'label'     => __( 'Icon Shape', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'circle_2',
				'options'   => array(
					'circle_2' => esc_html__( 'Circle', 'consulting-elementor-widgets' ),
					'square'   => esc_html__( 'Square', 'consulting-elementor-widgets' ),
					'diamond'  => esc_html__( 'Diamond', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => 'boxed_top_icon',
				),
			)
		);

		$this->add_control(
			'icon_position_1',
			array(
				'label'     => __( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'top',
				'options'   => array(
					'left'  => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'top'   => esc_html__( 'Top', 'consulting-elementor-widgets' ),
					'right' => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => 'standard',
				),
				'separator' => 'after',
			)
		);

		$this->add_control(
			'icon_position_3',
			array(
				'label'     => __( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'left',
				'options'   => array(
					'left'  => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'right' => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => 'boxed_side_icon',
				),
				'separator' => 'after',
			)
		);

		$this->add_control(
			'icon_position_2',
			array(
				'label'     => __( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => 'boxed_top_icon',
				),
				'separator' => 'after',
			)
		);

		$this->add_control(
			'title_2',
			array(
				'label'     => __( 'Title', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA,
				'default'   => esc_html__( 'Integrity Properties', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style' => array(
						'standard',
						'boxed_top_icon',
						'boxed_side_icon',
						'boxed_double_icon',
					),
				),
			)
		);

		$this->add_control(
			'content_2',
			array(
				'label'     => __( 'Description', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG,
				'default'   => esc_html__( 'We are a company that offers design and build services for you from initial sketches to the final construction.', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style' => array(
						'standard',
						'boxed_top_icon',
						'boxed_double_icon',
					),
				),
			)
		);

		$this->add_control(
			'alignment',
			array(
				'label'     => __( 'Alignment', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'left',
				'options'   => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => array( 'style_2', 'style_4', 'style_5', 'style_6', 'style_10' ),
				),
			)
		);

		$this->add_control(
			'content',
			array(
				'label'     => __( 'Description', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG,
				'default'   => esc_html__( 'We are a company that offers design and build services for you from initial sketches to the final construction.', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style' => array(
						'style_1',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
					),
				),
			)
		);

		$this->add_control(
			'button_text',
			array(
				'label'     => __( 'Button Text', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => __( 'Read More', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style' => array(
						'style_5',
					),
				),
			)
		);

		$this->add_control(
			'add_link_2',
			array(
				'label'        => __( 'Add Box link', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'enable',
				'separator'    => 'before',
				'condition'    => array(
					'box_style'  => array( 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon' ),
					'box_style!' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'link_2',
			array(
				'label'         => __( 'Link', 'consulting-elementor-widgets' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'show_external' => true,
				'condition'     => array(
					'add_link_2' => 'enable',
					'box_style!' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'content_alignment',
			array(
				'label'     => __( 'Content Alignment', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => array( 'standard', 'boxed_top_icon' ),
				),
			)
		);

		$this->add_control(
			'content_alignment_double_icon',
			array(
				'label'     => __( 'Content Alignment', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'left',
				'options'   => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'box_style' => array( 'boxed_double_icon' ),
				),
			)
		);

		$this->add_control(
			'show_title_line',
			array(
				'label'        => esc_html__( 'Show Title Line', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'box_style' => array( 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon' ),
				),
			)
		);

		$this->add_control(
			'show_read_more_button',
			array(
				'label'        => esc_html__( 'Show Read More Button', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'box_style' => array( 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon' ),
				),
			)
		);

		$this->add_control(
			'button_text_2',
			array(
				'label'     => __( 'Button Text', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => __( 'Read More', 'consulting-elementor-widgets' ),
				'condition' => array(
					'show_read_more_button' => 'yes',
					'box_style'             => array(
						'standard',
						'boxed_top_icon',
						'boxed_side_icon',
						'boxed_double_icon',
					),
				),
			)
		);

		$this->add_control(
			'button_link',
			array(
				'label'         => __( 'Button Link', 'consulting-elementor-widgets' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'show_external' => true,
				'condition'     => array(
					'show_read_more_button' => 'yes',
					'box_style!'            => 'with_tabs',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_1',
			array(
				'label'     => __( 'Tab 1', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'tab_id',
			array(
				'label'       => __( 'Unique ID', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'tab_1',
				'label_block' => true,
			)
		);

		$this->add_control(
			'tab_name',
			array(
				'label'       => __( 'Tab name', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'Tab 1', 'consulting-elementor-widgets' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'content_title',
			array(
				'label'     => __( 'Tab Content', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG,
				'default'   => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
				'separator' => 'after',
			)
		);

		$this->add_control(
			'tab_content_alignment_1',
			array(
				'label'   => __( 'Content Alignment', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'tab_icon_position_1',
			array(
				'label'   => __( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'       => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'top_left'   => esc_html__( 'Top Left', 'consulting-elementor-widgets' ),
					'top_center' => esc_html__( 'Top Center', 'consulting-elementor-widgets' ),
					'top_right'  => esc_html__( 'Top Right', 'consulting-elementor-widgets' ),
					'right'      => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'tab_icon_content_alignment_1',
			array(
				'label'   => __( 'Icon Content Alignment', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'icons',
			array(
				'label'   => __( 'Icon', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::ICONS,
				'default' => array(
					'value'   => 'fas fa-star',
					'library' => 'solid',
				),
			)
		);

		$repeater->add_control(
			'title',
			array(
				'label' => __( 'Title', 'consulting-elementor-widgets' ),
				'type'  => Controls_Manager::TEXT,
			)
		);

		$repeater->add_control(
			'icon_info',
			array(
				'label'   => __( 'Description', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::TEXTAREA,
				'rows'    => 4,
				'default' => 'We are a company that offers design and build services for you from initial sketches to the final construction.',
			)
		);

		$this->add_control(
			'icon_sections',
			array(
				'label'       => __( 'Tab Items', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::REPEATER,
				'default'     => array(
					array(
						'title' => __( 'Integrity Properties', 'consulting-elementor-widgets' ),
					),
				),
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_2',
			array(
				'label'     => __( 'Tab 2', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'tab_id_2',
			array(
				'label'       => __( 'Unique ID', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'tab_2',
				'label_block' => true,
			)
		);

		$this->add_control(
			'tab_name_2',
			array(
				'label'       => __( 'Tab name', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'Tab 2', 'consulting-elementor-widgets' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'content_title_2',
			array(
				'label'     => __( 'Tab Content', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG,
				'default'   => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
				'separator' => 'after',
			)
		);

		$this->add_control(
			'tab_content_alignment_2',
			array(
				'label'   => __( 'Content Alignment', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'tab_icon_position_2',
			array(
				'label'   => __( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'       => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'top_left'   => esc_html__( 'Top Left', 'consulting-elementor-widgets' ),
					'top_center' => esc_html__( 'Top Center', 'consulting-elementor-widgets' ),
					'top_right'  => esc_html__( 'Top Right', 'consulting-elementor-widgets' ),
					'right'      => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'tab_icon_content_alignment_2',
			array(
				'label'   => __( 'Icon Content Alignment', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'icons',
			array(
				'label'   => __( 'Icon', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::ICONS,
				'default' => array(
					'value'   => 'fas fa-star',
					'library' => 'solid',
				),
			)
		);

		$repeater->add_control(
			'title',
			array(
				'label'       => __( 'Title', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'icon_info',
			array(
				'label'   => __( 'Description', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::TEXTAREA,
				'rows'    => 4,
				'default' => 'We are a company that offers design and build services for you from initial sketches to the final construction.',
			)
		);

		$this->add_control(
			'icon_sections_2',
			array(
				'label'       => __( 'Tab Items', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::REPEATER,
				'default'     => array(
					array(
						'title' => __( 'Integrity Properties', 'consulting-elementor-widgets' ),
					),
				),
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_3',
			array(
				'label'     => __( 'Tab 3', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'tab_id_3',
			array(
				'label'       => __( 'Unique ID', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'tab_3',
				'label_block' => true,
			)
		);

		$this->add_control(
			'tab_name_3',
			array(
				'label'       => __( 'Tab name', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'Tab 3', 'consulting-elementor-widgets' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'content_title_3',
			array(
				'label'     => __( 'Tab Content', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG,
				'default'   => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
				'separator' => 'after',
			)
		);

		$this->add_control(
			'tab_content_alignment_3',
			array(
				'label'   => __( 'Content Alignment', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'tab_icon_position_3',
			array(
				'label'   => __( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'       => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'top_left'   => esc_html__( 'Top Left', 'consulting-elementor-widgets' ),
					'top_center' => esc_html__( 'Top Center', 'consulting-elementor-widgets' ),
					'top_right'  => esc_html__( 'Top Right', 'consulting-elementor-widgets' ),
					'right'      => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'tab_icon_content_alignment_3',
			array(
				'label'   => __( 'Icon Content Alignment', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
				),
			)
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'icons',
			array(
				'label'   => __( 'Icon', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::ICONS,
				'default' => array(
					'value'   => 'fas fa-star',
					'library' => 'solid',
				),
			)
		);

		$repeater->add_control(
			'title',
			array(
				'label' => __( 'Title', 'consulting-elementor-widgets' ),
				'type'  => Controls_Manager::TEXT,
			)
		);

		$repeater->add_control(
			'icon_info',
			array(
				'label'   => __( 'Description', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::TEXTAREA,
				'rows'    => 4,
				'default' => 'We are a company that offers design and build services for you from initial sketches to the final construction.',
			)
		);

		$this->add_control(
			'icon_sections_3',
			array(
				'label'       => __( 'Tab Items', 'consulting-elementor-widgets' ),
				'type'        => Controls_Manager::REPEATER,
				'default'     => array(
					array(
						'title' => __( 'Integrity Properties', 'consulting-elementor-widgets' ),
					),
				),
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'old_styles_typography',
			array(
				'label'     => esc_html__( 'Text', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'box_style!' => array( 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon', 'with_tabs' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'old_style_title_typography',
				'label'     => esc_html__( 'Title Typography', 'consulting-elementor-widgets' ),
				'selector'  => '{{WRAPPER}} .icon_box.style_1 .icon_text h5, {{WRAPPER}} .icon_box.style_1 .icon_text h4, {{WRAPPER}} .icon_box.style_2 .icon_box_inner h5, {{WRAPPER}} .icon_box.style_4 .icon_box_inner h4, {{WRAPPER}} .icon_box.style_5 .icon_box_inner h4, {{WRAPPER}} .icon_box.style_6 .icon_box_inner h4, {{WRAPPER}} .icon_box.style_7 .icon_box_inner h6, {{WRAPPER}} .icon_box.style_8 .icon_box_content h4, {{WRAPPER}} .icon_box.style_9 .icon_box_inner h6, {{WRAPPER}} .icon_box.style_10 .icon_box_inner h4',
				'global'    => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
				'condition' => array(
					'box_style!' => array( 'style_3', 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon', 'with_tabs' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'old_style_description_typography',
				'label'     => esc_html__( 'Description Typography', 'consulting-elementor-widgets' ),
				'selector'  => '{{WRAPPER}} .icon_box.style_1 .icon_text p, {{WRAPPER}} .icon_box.style_3 .icon_text p, {{WRAPPER}} .icon_box.style_4 .icon_text p, {{WRAPPER}} .icon_box.style_5 .icon_text p, {{WRAPPER}} .icon_box.style_6 .icon_text p, {{WRAPPER}} .icon_box.style_7 .icon_text p, {{WRAPPER}} .icon_box.style_8 .icon_box_content p, {{WRAPPER}} .icon_box.style_9 .icon_text p, {{WRAPPER}} .icon_box.style_10 .icon_text p',
				'global'    => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
				'condition' => array(
					'box_style!' => array( 'style_2', 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon', 'with_tabs' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'tabs_text_style',
			array(
				'label'     => esc_html__( 'Text', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'box_style' => 'with_tabs',
				),
			)
		);

		$this->add_control(
			'tabs_title_color',
			array(
				'label'     => esc_html__( 'Tab Link Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-links .icon-box-tab-link' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'tabs_title_active_color',
			array(
				'label'     => esc_html__( 'Tab Link Active Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-links .icon-box-tab-link.active' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'tabs_title_bg_color',
			array(
				'label'     => esc_html__( 'Tab Link Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-links .icon-box-tab-link' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'tabs_title_bg_hover_color',
			array(
				'label'     => esc_html__( 'Tab Link Background Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-links .icon-box-tab-link.active, {{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-links .icon-box-tab-link:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'tabs_link_border_radius',
			array(
				'label'     => esc_html__( 'Tab Link Border Radius', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-links .icon-box-tab-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'tabs_title_hover_color',
			array(
				'label'     => esc_html__( 'Tab Link Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-links .icon-box-tab-link:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'tab_link_typography',
				'label'    => esc_html__( 'Tab Link Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-links .icon-box-tab-link',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'tabs_content_color',
			array(
				'label'     => esc_html__( 'Tab Content Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-content .icon-box-content-info' => 'color: {{VALUE}};',
				),
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'tab_content_typography',
				'label'    => esc_html__( 'Tab Content Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-content .icon-box-content-info',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'tabs_items_title_color',
			array(
				'label'     => esc_html__( 'Items Title Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-content .icon-box-icons-wrapper .icon-box-info .icon-box-title' => 'color: {{VALUE}};',
				),
				'separator' => 'before',
			)
		);

		$this->add_control(
			'tabs_items_title_hover_color',
			array(
				'label'     => esc_html__( 'Items Title Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-content .icon-box-icons-wrapper li:hover .icon-box-info .icon-box-title' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'tab_items_title_typography',
				'label'    => esc_html__( 'Item Title Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-content .icon-box-icons-wrapper .icon-box-info .icon-box-title',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'tab_items_title_margin_bottom',
			array(
				'label'      => __( 'Item Title Margin Bottom', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-content .icon-box-icons-wrapper .icon-box-info .icon-box-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
				'separator'  => 'after',
			)
		);

		$this->add_control(
			'tabs_items_description_color',
			array(
				'label'     => esc_html__( 'Items Description Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-content .icon-box-icons-wrapper .icon-box-info .icon-box-description' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'tab_items_description_typography',
				'label'    => esc_html__( 'Items Description Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-tab-content .icon-box-icons-wrapper .icon-box-info .icon-box-description',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text_style',
			array(
				'label'     => esc_html__( 'Text', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'box_style' => array( 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon' ),
				),
			)
		);

		$this->add_control(
			'title_color_picker',
			array(
				'label'     => esc_html__( 'Title Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-title-wrapper .icon-box-title' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'title_hover_color_picker',
			array(
				'label'     => esc_html__( 'Title Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper:hover .icon-box-content .icon-box-title-wrapper .icon-box-title' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Title Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-title-wrapper .icon-box-title',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'title_margin_bottom',
			array(
				'label'      => __( 'Title Margin Bottom', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-title-wrapper .icon-box-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
				'separator'  => 'after',
			)
		);

		$this->add_control(
			'description_color',
			array(
				'label'     => esc_html__( 'Description Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-description-wrapper .icon-box-description' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'box_style!' => 'boxed_side_icon',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'description_typography',
				'label'     => esc_html__( 'Description Typography', 'consulting-elementor-widgets' ),
				'selector'  => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-description-wrapper .icon-box-description',
				'global'    => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
				'condition' => array(
					'box_style!' => 'boxed_side_icon',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'icon_style',
			array(
				'label'     => esc_html__( 'Icon', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'box_style' => array( 'standard', 'boxed_side_icon', 'boxed_top_icon', 'with_tabs' ),
				),
			)
		);

		$this->add_responsive_control(
			'icon_size_2',
			array(
				'label'     => esc_html__( 'Icon Size', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper .icon-box-icon i'                                           => 'font-size: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.standard.icon_shape_points .consulting-icon-box-wrapper .icon-box-icon'                           => 'width: calc({{VALUE}}px * 2);height: calc({{VALUE}}px * 2)',
					'{{WRAPPER}} .consulting-icon-box.standard.icon_shape_points .consulting-icon-box-wrapper .icon-box-icon:before'                    => 'font-size: calc({{VALUE}}px * 2);',
					'{{WRAPPER}} .consulting-icon-box.standard.icon_shape_points .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render'     => 'width: calc({{VALUE}}px * 2);height: calc({{VALUE}}px * 2)',
					'{{WRAPPER}} .consulting-icon-box.standard.icon_shape_points .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render i'   => 'width: calc({{VALUE}}px * 2);',
					'{{WRAPPER}} .consulting-icon-box.standard.icon_shape_points .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render svg' => 'width: {{VALUE}}px; height: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render i'               => 'font-size: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render svg'             => 'width: {{VALUE}};height: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render'                => 'height: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render i'              => 'font-size: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render svg'            => 'width: {{VALUE}}px; height: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.with-tabs .consulting-icon-box-wrapper .icon-box-icons-wrapper .icon-box-icon i'                  => 'font-size: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.with-tabs .consulting-icon-box-wrapper .icon-box-icons-wrapper .icon-box-icon svg'                => 'width: {{VALUE}}px; height: {{VALUE}}px;',
				),
			)
		);

		$this->add_control(
			'icon_color_2',
			array(
				'label'     => esc_html__( 'Icon Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-icon i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-icon svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'icon_hover_color',
			array(
				'label'     => esc_html__( 'Icon Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box:not(.with-tabs) .consulting-icon-box-wrapper:hover .icon-box-icon i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box:not(.with-tabs) .consulting-icon-box-wrapper:hover .icon-box-icon svg' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.with-tabs .consulting-icon-box-wrapper li:hover .icon-box-icon i'      => 'color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.with-tabs .consulting-icon-box-wrapper li:hover .icon-box-icon svg'    => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'icon_bg_color_circle',
			array(
				'label'     => esc_html__( 'Icon Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper .icon-box-icon i' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'icon_shape_1' => 'circle_1',
				),
			)
		);

		$this->add_control(
			'icon_bg_hover_color',
			array(
				'label'     => esc_html__( 'Icon Background Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper .icon-box-icon i' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'icon_shape_1' => 'circle_1',
				),
			)
		);

		$this->add_control(
			'icon_spacing',
			array(
				'label'      => __( 'Icon Spacing', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box.standard.icon_position_top .consulting-icon-box-wrapper .icon-box-icon'          => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.standard.icon_position_left .consulting-icon-box-wrapper .icon-box-icon'         => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.standard.icon_position_right .consulting-icon-box-wrapper .icon-box-icon'        => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper .icon-box-icon'                      => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon.icon_position_left .consulting-icon-box-wrapper .icon-box-icon'  => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon.icon_position_right .consulting-icon-box-wrapper .icon-box-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.with-tabs .consulting-icon-box-wrapper .icon-box-icons-wrapper li'               => 'gap: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 20,
				),
				'separator'  => 'after',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'icon_style_double_icon',
			array(
				'label'     => esc_html__( 'Icon', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'box_style' => 'boxed_double_icon',
				),
			)
		);

		$this->add_responsive_control(
			'main_icon_size',
			array(
				'label'     => esc_html__( 'Main Icon Size', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render i'   => 'font-size: {{VALUE}}px;',
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render svg' => 'width: {{VALUE}}px;height: {{VALUE}}px;',
				),
			)
		);

		$this->add_control(
			'main_icon_color',
			array(
				'label'     => esc_html__( 'Main Icon Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'main_icon_spacing',
			array(
				'label'      => __( 'Main Icon Spacing', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper .icon-box-icon .icon-box-icon-render i' => 'padding-right: {{SIZE}}{{UNIT}};',
				),
				'separator'  => 'after',
			)
		);

		$this->add_control(
			'additional_icon_color',
			array(
				'label'     => esc_html__( 'Additional Icon Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper .icon-box-double-icon i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper .icon-box-double-icon svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_line',
			array(
				'label'     => esc_html__( 'Title Line', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_title_line' => 'yes',
				),
			)
		);

		$this->add_control(
			'title_line_color',
			array(
				'label'     => esc_html__( 'Title Line Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.show_title_line .consulting-icon-box-wrapper .icon-box-title-wrapper .icon-box-title:after' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'title_line_width',
			array(
				'label'     => esc_html__( 'Title Line Width', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.show_title_line .consulting-icon-box-wrapper .icon-box-title-wrapper .icon-box-title:after' => 'width: {{VALUE}}px;',
				),
			)
		);

		$this->add_responsive_control(
			'title_line_height_2',
			array(
				'label'     => esc_html__( 'Title Line Height', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.show_title_line .consulting-icon-box-wrapper .icon-box-title-wrapper .icon-box-title:after' => 'height: {{VALUE}}px;',
				),
			)
		);

		$this->add_control(
			'title_line_margin_top',
			array(
				'label'      => __( 'Title Line Margin Top', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box.show_title_line .consulting-icon-box-wrapper .icon-box-title-wrapper .icon-box-title:after' => 'margin-top: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 15,
				),
			)
		);

		$this->add_control(
			'title_line_margin_bottom',
			array(
				'label'      => __( 'Title Line Margin Bottom', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box.show_title_line .consulting-icon-box-wrapper .icon-box-title-wrapper .icon-box-title:after' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 10,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'top_line',
			array(
				'label'     => esc_html__( 'Top Line', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'box_style' => 'boxed_double_icon',
				),
			)
		);

		$this->add_control(
			'line_color',
			array(
				'label'     => esc_html__( 'Line Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper' => 'border-top-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'line_hover_color',
			array(
				'label'     => esc_html__( 'Line Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper:hover' => 'border-top-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'box_settings',
			array(
				'label'     => esc_html__( 'Box', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'box_style' => array( 'standard', 'boxed_top_icon', 'boxed_side_icon', 'boxed_double_icon' ),
				),
			)
		);

		$this->add_control(
			'box_bg_color',
			array(
				'label'     => esc_html__( 'Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper'          => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper'    => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper'   => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'box_bg_hover_color',
			array(
				'label'     => esc_html__( 'Background Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper:hover'                => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper:hover'    => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper:hover'   => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'     => 'box_border_settings',
				'selector' => '{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper, {{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper, {{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper, {{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper',
				'exclude'  => array( 'color' ),
			)
		);

		$this->add_control(
			'box_border_color',
			array(
				'label'     => esc_html__( 'Border Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper'          => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper'    => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper'   => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'box_border_hover_color',
			array(
				'label'     => esc_html__( 'Border Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper:hover'          => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper:hover'    => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper:hover'   => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper:hover' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'box_border_radius',
			array(
				'label'     => esc_html__( 'Border Radius', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper'          => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'box_background_shadow',
				'selector' => '{{WRAPPER}} .consulting-icon-box.standard .consulting-icon-box-wrapper, {{WRAPPER}} .consulting-icon-box.boxed-top-icon .consulting-icon-box-wrapper, {{WRAPPER}} .consulting-icon-box.boxed-side-icon .consulting-icon-box-wrapper, {{WRAPPER}} .consulting-icon-box.boxed-double-icon .consulting-icon-box-wrapper',
			)
		);

		$this->add_control(
			'box_padding',
			array(
				'label'     => esc_html__( 'Box Padding', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition' => array(
					'box_style' => array( 'boxed_side_icon', 'standard' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'read_more_button',
			array(
				'label'     => esc_html__( 'Read More Button', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_read_more_button' => 'yes',
				),
			)
		);

		$this->add_control(
			'read_more_text_color',
			array(
				'label'     => esc_html__( 'Text Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'read_more_text_hover_color',
			array(
				'label'     => esc_html__( 'Text Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper:hover .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'read_more_text_typography',
				'label'    => esc_html__( 'Text Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'read_more_icon',
			array(
				'label'                  => __( 'Icon', 'consulting-elementor-widgets' ),
				'type'                   => \Elementor\Controls_Manager::ICONS,
				'default'                => array(
					'value'   => 'fas fa-chevron-right',
					'library' => 'solid',
				),
				'skin'                   => 'inline',
				'exclude_inline_options' => array( 'svg' ),
			)
		);

		$this->add_control(
			'read_more_icon_color',
			array(
				'label'     => esc_html__( 'Icon Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'read_more_icon_hover_color',
			array(
				'label'     => esc_html__( 'Icon Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper:hover .icon-box-content .icon-box-read-more-button-wrapper i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper:hover .icon-box-content .icon-box-read-more-button-wrapper svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'read_more_icon_size',
			array(
				'label'      => __( 'Icon Size', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 12,
				),
			)
		);

		$this->add_control(
			'read_more_icon_spacing',
			array(
				'label'      => __( 'Icon Spacing', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button svg' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button i'   => 'margin-left: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 12,
				),
				'separator'  => 'after',
			)
		);

		$this->add_responsive_control(
			'read_more_button_padding',
			array(
				'label'      => esc_html__( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'     => 'read_more_button_border',
				'selector' => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button',
				'exclude'  => array( 'color' ),
			)
		);

		$this->add_control(
			'read_more_border_radius',
			array(
				'label'     => esc_html__( 'Border Radius', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'read_more_border_color',
			array(
				'label'     => esc_html__( 'Border Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'read_more_border_hover_color',
			array(
				'label'     => esc_html__( 'Border Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper:hover .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'read_more_bg_color',
			array(
				'label'     => esc_html__( 'Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'read_more_bg_hover_color',
			array(
				'label'     => esc_html__( 'Background Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper:hover .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'read_more_box_shadow',
				'selector' => '{{WRAPPER}} .consulting-icon-box .consulting-icon-box-wrapper .icon-box-content .icon-box-read-more-button-wrapper .icon-box-read-more-button',
			)
		);

		$this->end_controls_section();

		$this->add_dimensions( '.event-members-box-table' );

	}

	public function add_dimensions( $selector = '' ) {
		$this->start_controls_section(
			'section_dimensions',
			array(
				'label'     => __( 'Dimensions', 'consulting-elementor-widgets' ),
				'condition' => array(
					'box_style!' => array(
						'standard',
						'boxed_top_icon',
						'boxed_side_icon',
						'boxed_double_icon',
						'with_tabs',
					),
				),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'margin',
			array(
				'label'      => __( 'Margin', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( false !== strpos( $settings['box_style'], 'style' ) ) {
			if ( function_exists( 'consulting_show_template' ) ) {

				$settings['css_class'] = ' elementor-consulting-icon-box';
				$settings['icon']      = $settings['icon']['value'];

				if ( isset( $settings['link']['target'] ) ) {
					$settings['link']['target'] = 'on' === $settings['link']['is_external'] ? '_blank' : '_self';
				}

				if ( ! empty( $settings['content'] ) ) {
					$settings['content'] = wpautop( $settings['content'] );
				}
				if ( ! empty( $settings['title'] ) ) {
					$settings['title'] = wpautop( $settings['title'] );
				}

				consulting_load_vc_element( 'icon_box', $settings, sanitize_file_name( $settings['box_style'] ) );

			}
		} else {
			stm_load_variations_template( $settings, '/icon-box/styles/' . sanitize_file_name( $settings['box_style'] ) );
		}

	}
}
