<?php
$class  = '';
$class .= isset( $settings['icon_shape_1'] ) ? 'icon_shape_' . $settings['icon_shape_1'] : '';
$class .= isset( $settings['icon_position_1'] ) ? ' icon_position_' . $settings['icon_position_1'] : '';
$class .= isset( $settings['content_alignment'] ) ? ' content_alignment_' . $settings['content_alignment'] : '';
$class .= ! empty( $settings['show_title_line'] ) ? ' show_title_line' : '';

?>
	<div class="consulting-icon-box standard <?php echo esc_attr( $class ); ?>">
		<div class="consulting-icon-box-wrapper">
			<?php
			if ( 'enable' === $settings['add_link_2'] ) {
				?>
				<a href="<?php echo esc_url( $settings['link_2']['url'] ); ?>" <?php echo 'on' === $settings['link_2']['is_external'] ? 'target=_blank' : 'target="_self"'; ?> <?php echo 'on' === $settings['link_2']['nofollow'] ? 'rel=nofollow' : ''; ?> class="icon-box-link"></a>
				<?php
			}
			?>
			<div class="icon-box-icon">
				<div class="icon-box-icon-render">
					<?php
					if ( isset( $settings['icon_2'] ) && ! empty( $settings['icon_2'] ) ) {
						\Elementor\Icons_Manager::render_icon( $settings['icon_2'], array( 'aria-hidden' => 'true' ) );
					}
					?>
				</div>
			</div>
			<div class="icon-box-content">
				<div class="icon-box-title-wrapper">
					<?php
					if ( isset( $settings['title_2'] ) && ! empty( $settings['title_2'] ) ) {
						?>
						<h2 class="icon-box-title">
							<?php echo esc_html( $settings['title_2'] ); ?>
						</h2>
						<?php
					}
					?>
				</div>
				<div class="icon-box-description-wrapper">
					<?php
					if ( isset( $settings['content_2'] ) && ! empty( $settings['content_2'] ) ) {
						?>
						<p class="icon-box-description">
							<?php echo esc_html( $settings['content_2'] ); ?>
						</p>
						<?php
					}
					?>
				</div>
				<div class="icon-box-read-more-button-wrapper">
					<?php
					if ( 'yes' === $settings['show_read_more_button'] ) {
						?>
						<a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" <?php echo 'on' === $settings['button_link']['is_external'] ? 'target=_blank' : 'target="_self"'; ?> <?php echo 'on' === $settings['button_link']['nofollow'] ? 'rel=nofollow' : ''; ?> class="icon-box-read-more-button"><?php echo esc_html( $settings['button_text_2'] ); ?>
							<?php
							if ( isset( $settings['read_more_icon'] ) && ! empty( $settings['read_more_icon'] ) ) {
								\Elementor\Icons_Manager::render_icon( $settings['read_more_icon'], array( 'aria-hidden' => 'true' ) );
							}
							?>
						</a>
						<?php
					}
					?>
				</div>
			</div>
		</div>
	</div>
<?php
