<?php

$tabs_count         = 3;
$icons_tabs         = array();
$icons_tabs_content = array();

for ( $i = 1; $i <= $tabs_count; $i ++ ) {
	$postfix                          = ( 1 === $i ) ? '' : '_' . $i;
	$icons_tabs[ 'tab' . $i ]         = array(
		'id'    => $settings[ 'tab_id' . $postfix ],
		'name'  => $settings[ 'tab_name' . $postfix ],
		'class' => ( 1 === $i ) ? 'active' : '',
	);
	$icons_tabs_content[ 'tab' . $i ] = array(
		'id'                     => $settings[ 'tab_id' . $postfix ],
		'content_title'          => $settings[ 'content_title' . $postfix ],
		'icons'                  => $settings[ 'icon_sections' . $postfix ],
		'alignment'              => $settings [ 'tab_content_alignment_' . $i ],
		'icon_position'          => $settings [ 'tab_icon_position_' . $i ],
		'icon_content_alignment' => $settings [ 'tab_icon_content_alignment_' . $i ],
		'class'                  => ( 1 === $i ) ? 'active' : '',
	);
}

?>

<div class="consulting-icon-box with-tabs">
	<div class="consulting-icon-box-wrapper <?php echo 'appearance_' . esc_attr( $settings['with_tabs_style'] ); ?>">
		<div class="icon-box-tab-links">
			<?php foreach ( $icons_tabs as $tab ) { ?>
				<a href="javascript:void(0);" class="icon-box-tab-link <?php echo esc_attr( $tab['class'] ); ?>" tabid="<?php echo esc_attr( $tab['id'] ); ?>"><?php echo esc_attr( $tab['name'] ); ?></a>
			<?php } ?>
		</div>
		<?php foreach ( $icons_tabs_content as $content ) { ?>
			<div id="<?php echo esc_attr( $content['id'] ); ?>" class="icon-box-tab-content <?php echo esc_attr( $content['class'] ); ?>">
				<div class="icon-box-content-info <?php echo 'content_alignment_' . esc_attr( $content['alignment'] ); ?>">
					<?php echo wp_kses_post( $content['content_title'] ); ?>
				</div>
				<?php if ( isset( $content['icons'] ) ) { ?>
					<div class="icon-box-icons-wrapper <?php echo 'icon_position_' . esc_attr( $content['icon_position'] ); ?>">
						<ul class="<?php echo 'icon_content_alignment_' . esc_attr( $content['icon_content_alignment'] ); ?>">
							<?php foreach ( $content['icons'] as $icon ) { ?>
								<li>
									<div class="icon-box-icon">
										<?php
										if ( isset( $icon['icons'] ) && ! empty( $icon['icons'] ) ) {
											\Elementor\Icons_Manager::render_icon( $icon['icons'], array( 'aria-hidden' => 'true' ) );
										}
										?>
									</div>
									<div class="icon-box-info">
										<div class="icon-box-title"><?php echo esc_attr( $icon['title'] ); ?></div>
										<div class="icon-box-description"><?php echo esc_attr( $icon['icon_info'] ); ?></div>
									</div>
								</li>
							<?php } ?>
						</ul>
					</div>
				<?php } ?>

			</div>
		<?php } ?>
	</div>
</div>
