<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;

class Elementor_STM_Services extends \Elementor\Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );
		wp_register_style( 'consulting-services-general', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/general.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-standard', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/standard.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-title-boxed', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/title_boxed.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-overlay', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/overlay.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-info-above', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/info_above.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-full-image', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/full_image.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-image-and-icon', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/image_and_icon.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-list', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/list.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-with-icons', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/with_icons.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-services-with-icons-2', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/services/with_icons_2.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_script( 'consulting-services', CONSULTING_ELEMENTOR_URL . 'assets/js/widgets/services.js', array( 'elementor-frontend', 'jquery' ), CONSULTING_ELEMENTOR_VERSION, true );
	}

	public function get_name() {
		return 'stm_services';
	}

	public function get_title() {
		return esc_html__( 'Services', 'consulting-elementor-widgets' );
	}

	public function get_icon() {
		return 'consulting-eicon-star';
	}

	public function get_categories() {
		return array( 'consulting-widgets' );
	}

	public function get_script_depends() {
		return array( 'owl.carousel', 'consulting-services' );
	}

	public function get_style_depends() {
		return array(
			'owl.carousel',
			'consulting-services-general',
			'consulting-services-standard',
			'consulting-services-title-boxed',
			'consulting-services-overlay',
			'consulting-services-info-above',
			'consulting-services-full-image',
			'consulting-services-image-and-icon',
			'consulting-services-list',
			'consulting-services-with-icons',
			'consulting-services-with-icons-2',
		);
	}

	protected function register_controls() {
		$service_category_array = get_terms( 'stm_service_category' );
		$service_category       = array(
			esc_html__( 'All', 'consulting-elementor-widgets' ) => 'all',
		);
		if ( $service_category_array && ! is_wp_error( $service_category_array ) ) {
			foreach ( $service_category_array as $cat ) {
				$service_category[ $cat->name ] = $cat->slug;
			}
		}

		$this->start_controls_section(
			'content_section',
			array(
				'label' => __( 'Content', 'plugin-name' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'style',
			array(
				'label'   => __( 'Style', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'style_1',
				'options' => array(
					'standard'       => esc_html__( 'Standard', 'consulting-elementor-widgets' ),
					'title_boxed'    => esc_html__( 'Title Boxed', 'consulting-elementor-widgets' ),
					'overlay'        => esc_html__( 'Overlay', 'consulting-elementor-widgets' ),
					'info_above'     => esc_html__( 'Info Above', 'consulting-elementor-widgets' ),
					'full_image'     => esc_html__( 'Full Image', 'consulting-elementor-widgets' ),
					'image_and_icon' => esc_html__( 'Image and Icon', 'consulting-elementor-widgets' ),
					'list'           => esc_html__( 'List', 'consulting-elementor-widgets' ),
					'with_icons'     => esc_html__( 'With Icons', 'consulting-elementor-widgets' ),
					'with_icons_2'   => esc_html__( 'With Icons 2', 'consulting-elementor-widgets' ),
					'style_1'        => esc_html__( 'Style 1', 'consulting-elementor-widgets' ),
					'style_2'        => esc_html__( 'Style 2', 'consulting-elementor-widgets' ),
					'style_3'        => esc_html__( 'Style 3', 'consulting-elementor-widgets' ),
					'style_4'        => esc_html__( 'Style 4', 'consulting-elementor-widgets' ),
					'style_5'        => esc_html__( 'Style 5', 'consulting-elementor-widgets' ),
					'style_6'        => esc_html__( 'Style 6', 'consulting-elementor-widgets' ),
					'style_7'        => esc_html__( 'Style 7', 'consulting-elementor-widgets' ),
					'style_8'        => esc_html__( 'Style 8', 'consulting-elementor-widgets' ),
					'style_9'        => esc_html__( 'Style 9', 'consulting-elementor-widgets' ),
					'style_10'       => esc_html__( 'Style 10', 'consulting-elementor-widgets' ),
					'style_11'       => esc_html__( 'Style 11', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'posts_per_page',
			array(
				'label'     => __( 'Number Posts', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 12,
				'condition' => array(
					'style!' => array(
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'posts_per_page_new',
			array(
				'label'     => __( 'Number Posts', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 4,
				'condition' => array(
					'style' => array(
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'posts_per_row',
			array(
				'label'     => __( 'Columns Count', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 4,
				'options'   => array(
					4 => 4,
					3 => 3,
					2 => 2,
					1 => 1,
				),
				'condition' => array(
					'style' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_6',
						'style_9',
						'style_10',
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'with_icons',
					),
				),
			)
		);

		$this->add_control(
			'icon_shape',
			array(
				'label'     => __( 'Icon Shape', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'circle',
				'options'   => array(
					'default' => esc_html__( 'Default', 'consulting-elementor-widgets' ),
					'circle'  => esc_html__( 'Circle', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'style' => array( 'with_icons', 'with_icons_2' ),
				),
			)
		);

		$this->add_control(
			'icon_position',
			array(
				'label'     => __( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'Left', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => __( 'Right', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'center',
				'toggle'    => false,
				'condition' => array(
					'style' => array( 'with_icons', 'with_icons_2' ),
				),
			)
		);

		$this->add_control(
			'content_alignment',
			array(
				'label'     => __( 'Content Alignment', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'Left', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => __( 'Right', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'left',
				'toggle'    => false,
				'condition' => array(
					'style' => array( 'standard', 'overlay', 'info_above' ),
				),
			)
		);

		$this->add_control(
			'category',
			array(
				'label'   => __( 'Category', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'all',
				'options' => array_flip( $service_category ),
			)
		);

		$this->add_control(
			'img_size',
			array(
				'label'       => __( 'Image size', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use default size.', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style!' => array(
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'service_image',
			array(
				'label'        => __( 'Hide image', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_6',
					),
				),
			)
		);

		$this->add_control(
			'service_cat',
			array(
				'label'        => __( 'Hide category', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'style' => array(
						'style_1',
						'style_2',
						'style_6',
					),
				),
			)
		);

		$this->add_control(
			'service_title',
			array(
				'label'        => __( 'Hide Title', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style!' => array(
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'service_excerpt',
			array(
				'label'        => __( 'Hide Excerpt', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style' => array(
						'style_1',
						'style_6',
						'style_8',
					),
				),
			)
		);

		$this->add_control(
			'show_category',
			array(
				'label'        => __( 'Show Category', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'style' => array(
						'info_above',
						'image_and_icon',
					),
				),
				'separator'    => 'before',
			)
		);

		$this->add_control(
			'show_description',
			array(
				'label'        => __( 'Show Description', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'style' => array(
						'standard',
						'title_boxed',
						'overlay',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
				'separator'    => 'before',
			)
		);

		$this->add_control(
			'title_line_above',
			array(
				'label'     => __( 'Title Line', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'above_title',
				'options'   => array(
					'none'        => __( 'No', 'consulting-elementor-widgets' ),
					'above_title' => __( 'Above Title', 'consulting-elementor-widgets' ),
					'under_title' => __( 'Under Title', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'style' => array( 'standard', 'info_above' ),
				),
			)
		);

		$this->add_control(
			'title_line_under',
			array(
				'label'     => __( 'Title Line', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'under_title',
				'options'   => array(
					'none'        => __( 'No', 'consulting-elementor-widgets' ),
					'above_title' => __( 'Above Title', 'consulting-elementor-widgets' ),
					'under_title' => __( 'Under Title', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'style' => array( 'overlay', 'list' ),
				),
			)
		);

		$this->add_control(
			'add_box_style',
			array(
				'label'        => __( 'Add Box Style', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style' => array(
						'standard',
						'info_above',
						'list',
					),
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'      => 'item_box_shadow',
				'selector'  => '{{WRAPPER}} .consulting-services .service-item .service-item-wrapper',
				'label'     => __( 'Box Shadow', 'consulting-elementor-widgets' ),
				'condition' => array(
					'add_box_style' => 'yes',
				),
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'      => 'item_box_shadow_new',
				'selector'  => '{{WRAPPER}} .consulting-services:not(.with_icons_2) .service-item .service-item-wrapper, {{WRAPPER}} .consulting-services.with_icons_2:after',
				'label'     => __( 'Box Shadow', 'consulting-elementor-widgets' ),
				'condition' => array(
					'style' => array( 'overlay', 'image_and_icon', 'with_icons_2' ),
				),
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'      => 'item_box_shadow_hover',
				'selector'  => '{{WRAPPER}} .consulting-services .service-item:hover .service-item-wrapper',
				'label'     => __( 'Box Shadow Hover', 'consulting-elementor-widgets' ),
				'condition' => array(
					'add_box_style' => 'yes',
				),
				'separator' => 'after',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'      => 'item_box_shadow_hover_new',
				'selector'  => '{{WRAPPER}} .consulting-services:not(.with_icons_2) .service-item:hover .service-item-wrapper, {{WRAPPER}} .consulting-services.with_icons_2:hover:after',
				'label'     => __( 'Box Shadow Hover', 'consulting-elementor-widgets' ),
				'condition' => array(
					'style' => array( 'overlay', 'image_and_icon', 'with_icons_2' ),
				),
				'separator' => 'after',
			)
		);

		$this->add_control(
			'show_divider',
			array(
				'label'        => __( 'Show Divider', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'style' => array(
						'with_icons',
					),
				),
			)
		);

		$this->add_control(
			'Divider_color',
			array(
				'label'     => __( 'Divider Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item' => 'border-color: {{VALUE}} !important',
				),
				'condition' => array(
					'style'        => array(
						'with_icons',
					),
					'show_divider' => 'yes',
				),
			)
		);

		$this->add_control(
			'show_read_more',
			array(
				'label'        => __( 'Show Read More Button', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'style' => array(
						'standard',
						'title_boxed',
						'overlay',
						'full_image',
						'list',
						'with_icons',
					),
				),
			)
		);

		$this->add_control(
			'button_text',
			array(
				'label'     => __( 'Read More Text', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 'Read More',
				'condition' => array(
					'show_read_more' => 'yes',
					'style!'         => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'info_above',
						'image_and_icon',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'enable_carousel',
			array(
				'label'        => __( 'Enable Carousel', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style' => array(
						'info_above',
						'full_image',
					),
				),
			)
		);

		$this->add_control(
			'carousel_dots_alignment',
			array(
				'label'     => __( 'Dots Alignment', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'Left', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => __( 'Right', 'consulting-elementor-widgets' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'center',
				'toggle'    => false,
				'condition' => array(
					'enable_carousel' => 'yes',
					'style!'          => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'image_and_icon',
						'list',
					),
				),
			)
		);

		$this->add_control(
			'dots_spacing',
			array(
				'label'      => __( 'Dots Spacing', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'condition'  => array(
					'enable_carousel' => 'yes',
					'style!'          => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'image_and_icon',
						'list',
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots' => 'gap: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'service_more',
			array(
				'label'        => __( 'Hide More Button', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style' => array(
						'style_1',
						'style_6',
						'style_8',
					),
				),
			)
		);

		$this->add_control(
			'service_pagination',
			array(
				'label'        => __( 'Hide Pagination', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'style' => array(
						'style_8',
					),
				),
			)
		);

		/*Colors*/
		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'Title Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => array(
					'style!' => array(
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'excerpt_color',
			array(
				'label'     => __( 'Excerpt Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => array(
					'style!' => array(
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'link_color',
			array(
				'label'     => __( 'More button Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => array(
					'style!' => array(
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'category_color',
			array(
				'label'     => __( 'Category Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => array(
					'style!' => array(
						'standard',
						'title_boxed',
						'overlay',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text_section',
			array(
				'label' => __( 'Text', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'title_color_new',
			array(
				'label'     => __( 'Title Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .stm_services .item .content h5 a, {{WRAPPER}} .stm_services .item .item_info h5, {{WRAPPER}} .stm_services .stm_service .stm_service__title a, {{WRAPPER}} .stm_services .item .service-content .service-title' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
					),
				),
			)
		);

		$this->add_control(
			'title_hover_color_new',
			array(
				'label'     => __( 'Title Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-title a' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
					),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'Title Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-services .service-item .service-item-title a, {{WRAPPER}} .stm_services .item .content h5 a, {{WRAPPER}} .stm_services .item .item_info h5, {{WRAPPER}} .stm_services .stm_service .stm_service__title a, {{WRAPPER}} .stm_services .item .service-content .service-title',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'title_box_color',
			array(
				'label'     => __( 'Title Box Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.title_boxed .service-item .service-item-title' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'title_boxed' ),
				),
			)
		);

		$this->add_control(
			'title_box_hover_color',
			array(
				'label'     => __( 'Title Box Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.title_boxed .service-item:hover .service-item-title' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'title_boxed' ),
				),
			)
		);

		$this->add_control(
			'title_margin_bottom',
			array(
				'label'     => __( 'Title Margin Bottom (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-title' => 'margin-bottom: {{SIZE}}px',
				),
				'separator' => 'after',
				'condition' => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
					),
				),
			)
		);

		$this->add_control(
			'category_color_new',
			array(
				'label'     => __( 'Category Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-category' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'standard',
						'title_boxed',
						'overlay',
						'full_image',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'category_typography',
				'label'     => __( 'Category Typography', 'consulting-elementor-widgets' ),
				'selector'  => '{{WRAPPER}} .consulting-services .service-item .service-item-category',
				'global'    => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
				'condition' => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'standard',
						'title_boxed',
						'overlay',
						'full_image',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'category_margin_bottom',
			array(
				'label'     => __( 'Category Margin Bottom (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-category' => 'margin-bottom: {{SIZE}}px',
				),
				'separator' => 'after',
				'condition' => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'standard',
						'title_boxed',
						'overlay',
						'full_image',
						'list',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'description_color_new',
			array(
				'label'     => __( 'Description Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-description' => 'color: {{VALUE}}',
					'{{WRAPPER}} .stm_services .item .content p, {{WRAPPER}} .stm_services .item .item_info .item_description, {{WRAPPER}} .stm_services .stm_service .stm_service__excerpt p, {{WRAPPER}} .stm_services .stm_service .stm_service__excerpt, {{WRAPPER}} .stm_services .item .service-content .service-description p, {{WRAPPER}} .stm_services .item .service-content .service-description' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style!' => array( 'style_1', 'style_2', 'style_3', 'style_4', 'style_5', 'style_6', 'style_7', 'style_8', 'style_9', 'style_10', 'style_11', 'info_above', 'full_image', 'image_and_icon' ),
				),
			)
		);

		$this->add_control(
			'description_hover_color_new',
			array(
				'label'     => __( 'Description Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-description' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'info_above',
						'full_image',
						'image_and_icon',
					),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'description_typography',
				'label'     => __( 'Description Typography', 'consulting-elementor-widgets' ),
				'selector'  => '{{WRAPPER}} .consulting-services .service-item .service-item-description, {{WRAPPER}} .stm_services .item .content p, {{WRAPPER}} .stm_services .item .item_info .item_description, {{WRAPPER}} .stm_services .stm_service .stm_service__excerpt, {{WRAPPER}} .stm_services .item .service-content .service-description p, {{WRAPPER}} .stm_services .item .service-content .service-description',
				'global'    => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
				'condition' => array(
					'style!' => array( 'style_2', 'style_3', 'style_4', 'info_above', 'full_image', 'image_and_icon' ),
				),
			)
		);

		$this->add_control(
			'description_margin_bottom',
			array(
				'label'     => __( 'Description Margin Bottom (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-description' => 'margin-bottom: {{SIZE}}px',
				),
				'separator' => 'after',
				'condition' => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'info_above',
						'full_image',
						'image_and_icon',
					),
				),
			)
		);

		$this->add_responsive_control(
			'content_padding',
			array(
				'label'      => __( 'Content Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services:not(.overlay) .service-item .service-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-services.overlay .service-item .service-item-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'separator'  => 'before',
				'condition'  => array(
					'style!' => array(
						'style_1',
						'style_2',
						'style_3',
						'style_4',
						'style_5',
						'style_6',
						'style_7',
						'style_8',
						'style_9',
						'style_10',
						'style_11',
						'with_icons_2',
					),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'image_section',
			array(
				'label'     => __( 'Image', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'style' => array(
						'standard',
						'title_boxed',
						'info_above',
						'full_image',
						'image_and_icon',
						'list',
					),
				),
			)
		);

		$this->add_control(
			'image_size',
			array(
				'label'       => __( 'Image size', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use default size.', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'image_overlay_color',
			array(
				'label'     => __( 'Image Overlay Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-image:before' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style'  => array( 'full_image' ),
					'style!' => array( 'image_and_icon', 'list', 'title_boxed', 'info_above' ),
				),
			)
		);

		$this->add_control(
			'image_hover_color',
			array(
				'label'     => __( 'Image Overlay Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-image a:before' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style!' => array( 'title_boxed', 'full_image', 'image_and_icon', 'list' ),
				),
			)
		);

		$this->add_control(
			'image_border_radius',
			array(
				'label'      => __( 'Image Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'icon_section',
			array(
				'label'     => __( 'Icon', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'style' => array(
						'image_and_icon',
						'with_icons',
						'with_icons_2',
						'info_above',
					),
				),
			)
		);

		$this->add_control(
			'icon_size',
			array(
				'label'      => __( 'Icon Size', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-wrapper .service-item-icon .service-item-icon-wrapper i' => 'font-size: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .consulting-services.image_and_icon .service-item .service-item-wrapper .service-item-icon i' => 'font-size: {{SIZE}}{{UNIT}}',
				),
				'condition'  => array(
					'style!' => array(
						'info_above',
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 28,
				),
			)
		);

		$this->add_control(
			'icon_size_info_above',
			array(
				'label'      => __( 'Icon Size', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services.info_above .service-item .service-item-wrapper .service-item-icon i' => 'font-size: {{SIZE}}{{UNIT}}',
				),
				'condition'  => array(
					'style!' => array(
						'image_and_icon',
						'with_icons',
						'with_icons_2',
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 20,
				),
			)
		);

		$this->add_control(
			'icon_color_new',
			array(
				'label'     => __( 'Icon Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-wrapper .service-item-icon .service-item-icon-wrapper i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.image_and_icon .service-item .service-item-wrapper .service-item-icon i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.info_above .service-item .service-item-wrapper .service-item-icon i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'icon_color_hover_new',
			array(
				'label'     => __( 'Icon Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-wrapper .service-item-icon .service-item-icon-wrapper i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.image_and_icon .service-item:hover .service-item-wrapper .service-item-icon i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.info_above .service-item .service-item-wrapper .service-item-icon:hover i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'icon_color_background',
			array(
				'label'      => __( 'Icon Background Color', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::COLOR,
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-wrapper .service-item-icon .service-item-icon-wrapper:before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.image_and_icon .service-item .service-item-wrapper .service-item-icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.info_above .service-item .service-item-wrapper .service-item-icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.with_icons .service-item .service-item-wrapper .service-item-icon .service-item-icon-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.with_icons_2 .service-item .service-item-icon .service-item-icon-wrapper:before' => 'background-color: {{VALUE}}',
				),
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'icon_shape',
							'operator' => '===',
							'value'    => 'circle',
						),
						array(
							'name'     => 'style',
							'operator' => '===',
							'value'    => 'image_and_icon',
						),
						array(
							'name'     => 'style',
							'operator' => '===',
							'value'    => 'info_above',
						),
					),
				),
			)
		);

		$this->add_control(
			'icon_color_background_hover',
			array(
				'label'      => __( 'Icon Hover Background Color', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::COLOR,
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-wrapper .service-item-icon .service-item-icon-wrapper:before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.image_and_icon .service-item:hover .service-item-wrapper .service-item-icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.info_above .service-item .service-item-wrapper .service-item-icon:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.with_icons .service-item:hover .service-item-wrapper .service-item-icon .service-item-icon-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.with_icons_2 .service-item:hover .service-item-icon .service-item-icon-wrapper:before' => 'background-color: {{VALUE}}',
				),
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'icon_shape',
							'operator' => '===',
							'value'    => 'circle',
						),
						array(
							'name'     => 'style',
							'operator' => '===',
							'value'    => 'image_and_icon',
						),
						array(
							'name'     => 'style',
							'operator' => '===',
							'value'    => 'info_above',
						),
					),
				),
			)
		);

		$this->add_control(
			'icon_vertical_position',
			array(
				'label'     => __( 'Icon Vertical Position (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					),
				),
				'condition' => array(
					'style!' => array(
						'info_above',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-wrapper .service-item-icon' => 'top: {{SIZE}}px',
				),
			)
		);

		$this->add_control(
			'icon_vertical_position_info_above',
			array(
				'label'     => __( 'Icon Vertical Position (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					),
				),
				'condition' => array(
					'style!' => array(
						'image_and_icon',
						'with_icons',
						'with_icons_2',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.info_above .service-item .service-item-wrapper .service-item-icon' => 'margin-top: {{SIZE}}px',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_line_section',
			array(
				'label'     => __( 'Title Line', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'style' => array(
						'standard',
						'overlay',
						'info_above',
						'list',
					),
				),
			)
		);

		$this->add_control(
			'title_line_color',
			array(
				'label'     => __( 'Title Line Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:after' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'title_line_hover_color',
			array(
				'label'     => __( 'Title Line Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-title:before' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'title_line_width',
			array(
				'label'     => __( 'Width (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'min'       => 0,
				'max'       => 100,
				'step'      => 1,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:before' => 'width: {{VALUE}}px',
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:after'  => 'width: {{VALUE}}px',
				),
			)
		);

		$this->add_control(
			'title_line_margin_top',
			array(
				'label'     => __( 'Margin Top (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:before' => 'margin-top: {{SIZE}}px',
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:after'  => 'margin-top: {{SIZE}}px',
				),
			)
		);

		$this->add_control(
			'title_line_margin_bottom',
			array(
				'label'     => __( 'Line Margin Bottom (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:before' => 'margin-bottom: {{SIZE}}px',
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:after'  => 'margin-bottom: {{SIZE}}px',
				),
			)
		);

		$this->add_control(
			'title_line_border_radius',
			array(
				'label'      => __( 'Title Line Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-services .service-item .service-item-title:after'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'box_section',
			array(
				'label'     => __( 'Box', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'add_box_style' => 'yes',
					'style'         => array(
						'standard',
						'info_above',
						'list',
					),
				),
			)
		);

		$this->add_control(
			'box_bg_color',
			array(
				'label'     => __( 'Box Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-wrapper' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'     => 'box_border',
				'selector' => '{{WRAPPER}} .consulting-services .service-item .service-item-wrapper',
			)
		);

		$this->add_control(
			'box_border_radius',
			array(
				'label'      => __( 'Box Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'box_section_2',
			array(
				'label'     => __( 'Box', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'style' => array(
						'overlay',
						'image_and_icon',
						'with_icons',
						'with_icons_2',
					),
				),
			)
		);

		$this->add_control(
			'box_bg_color_2',
			array(
				'label'     => __( 'Box Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.with_icons_2:after' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.image_and_icon .service-item .service-item-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.overlay .service-item .service-item-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.with_icons .service-item' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'box_bg_hover_color_2',
			array(
				'label'     => __( 'Box Background Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.with_icons_2:hover:after'                                 => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.image_and_icon .service-item:hover .service-item-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.overlay .service-item:hover .service-item-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.with_icons .service-item:hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'additional_box_bg_color',
			array(
				'label'     => __( 'Additional Box Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.with_icons_2:before' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style'  => array( 'with_icons_2' ),
					'style!' => array( 'with_icons' ),
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'      => 'box_border_2',
				'selector'  => '{{WRAPPER}} .consulting-services.with_icons_2:after, {{WRAPPER}} .consulting-services.image_and_icon .service-item .service-item-wrapper, {{WRAPPER}} .consulting-services.overlay .service-item .service-item-wrapper',
				'condition' => array(
					'style!' => 'with_icons',
				),
			)
		);

		$this->add_control(
			'box_border_radius_2',
			array(
				'label'      => __( 'Box Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services.with_icons_2:after, {{WRAPPER}} .consulting-services.with_icons_2'                                 => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-services.image_and_icon .service-item .service-item-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-services.overlay .service-item .service-item-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'style!' => 'with_icons',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'read_more_section',
			array(
				'label'     => __( 'Read More Button', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_read_more' => 'yes',
					'style'          => array(
						'standard',
						'title_boxed',
						'overlay',
						'full_image',
						'list',
						'with_icons',
					),
				),
			)
		);

		$this->add_control(
			'read_more_background_color',
			array(
				'label'     => __( 'Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'read_more_hover_background_color',
			array(
				'label'     => __( 'Background Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-content .service-item-read-more' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'read_more_padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'      => 'read_more_box_shadow',
				'selector'  => '{{WRAPPER}} .consulting-services .service-item .service-item-read-more',
				'label'     => __( 'Box Shadow', 'consulting-elementor-widgets' ),
				'separator' => 'before',
			)
		);

		$this->add_control(
			'read_more_color',
			array(
				'label'     => __( 'Text Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'read_more_hover_color',
			array(
				'label'     => __( 'Text Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-content .service-item-read-more' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'read_more_typography',
				'label'    => __( 'Text Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_control(
			'read_more_icon',
			array(
				'label'       => esc_html__( 'Icon', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'default'     => array(
					'value'   => 'fas fa-arrow-right',
					'library' => 'fa-solid',
				),
				'label_block' => false,
				'separator'   => 'before',
			)
		);

		$this->add_control(
			'read_more_icon_color',
			array(
				'label'     => __( 'Icon Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more svg' => 'fill: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'read_more_hover_icon_color',
			array(
				'label'     => __( 'Icon Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-content .service-item-read-more .read_more_icon_wrapper i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-content .service-item-read-more .read_more_icon_wrapper svg' => 'fill: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'read_more_icon_bg_color',
			array(
				'label'     => __( 'Icon Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more .read_more_icon_wrapper' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'read_more_icon_hover_bg_color',
			array(
				'label'     => __( 'Icon Hover Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-content .service-item-read-more .read_more_icon_wrapper' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'read_more_icon_size',
			array(
				'label'      => __( 'Icon Size', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more .read_more_icon_wrapper i' => 'font-size: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more .read_more_icon_wrapper svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}}',
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 20,
				),
			)
		);

		$this->add_control(
			'read_more_icon_position',
			array(
				'label'   => __( 'Icon Position', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'before' => __( 'Before', 'consulting-elementor-widgets' ),
					'after'  => __( 'After', 'consulting-elementor-widgets' ),
				),
				'default' => 'after',
			)
		);

		$this->add_control(
			'read_more_icon_spacing',
			array(
				'label'      => __( 'Icon Spacing', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more .read_more_icon_wrapper.before_icon' => 'margin-right: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more .read_more_icon_wrapper.after_icon'  => 'margin-left: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_control(
			'read_more_icon_padding',
			array(
				'label'      => __( 'Icon Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more .read_more_icon_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'read_more_icon_radius',
			array(
				'label'      => __( 'Icon Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more .read_more_icon_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'separator'  => 'after',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'     => 'read_more_border',
				'selector' => '{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more',
				'exclude'  => array( 'color' ),
			)
		);

		$this->add_control(
			'read_more_border_radius',
			array(
				'label'      => __( 'Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'read_more_border_color',
			array(
				'label'     => __( 'Border Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item .service-item-content .service-item-read-more' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'read_more_border_hover_color',
			array(
				'label'     => __( 'Border Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services .service-item:hover .service-item-content .service-item-read-more' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'dots_section',
			array(
				'label'      => __( 'Carousel Dots', 'consulting-elementor-widgets' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'conditions' => array(
					'relation' => 'and',
					'terms'    => array(
						array(
							'name'     => 'style',
							'operator' => '!==',
							'value'    => array( 'style_1', 'style_2', 'style_3', 'style_4', 'style_5', 'style_6', 'style_7', 'style_8', 'style_9', 'style_10', 'style_11', 'list' ),
						),
						array(
							'relation' => 'or',
							'terms'    => array(
								array(
									'name'     => 'enable_carousel',
									'operator' => '===',
									'value'    => 'yes',
								),
								array(
									'name'     => 'style',
									'operator' => '===',
									'value'    => 'with_icons_2',
								),
							),
						),

					),
				),
			)
		);

		$this->add_control(
			'dots_width',
			array(
				'label'     => __( 'Dots Width (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'min'       => 0,
				'max'       => 100,
				'step'      => 1,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot span' => 'width: {{VALUE}}px;',
				),
			)
		);

		$this->add_control(
			'dots_active_width',
			array(
				'label'     => __( 'Dots Width Active (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'min'       => 0,
				'max'       => 100,
				'step'      => 1,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot.active span' => 'width: {{VALUE}}px;',
				),
			)
		);

		$this->add_control(
			'dots_height',
			array(
				'label'     => __( 'Dots Height (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'min'       => 0,
				'max'       => 100,
				'step'      => 1,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot span' => 'height: {{VALUE}}px;',
				),
			)
		);

		$this->add_control(
			'dots_active_height',
			array(
				'label'     => __( 'Dots Height Active (px)', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'min'       => 0,
				'max'       => 100,
				'step'      => 1,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot.active span' => 'height: {{VALUE}}px;',
				),
			)
		);

		$this->add_control(
			'dots_border_radius',
			array(
				'label'      => __( 'Dots Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'separator'  => 'after',
			)
		);

		$this->add_control(
			'dots_border_radius_active',
			array(
				'label'      => __( 'Dots Active Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot.active span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'separator'  => 'after',
			)
		);

		$this->add_control(
			'dots_color',
			array(
				'label'     => __( 'Dots Default Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot span' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'dots_active_color',
			array(
				'label'     => __( 'Dots Active Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot.active span' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-services.owl-carousel .owl-controls .owl-dots .owl-dot:hover span'  => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$i        = 0;

		if ( false !== strpos( $settings['style'], 'style' ) ) {
			if ( function_exists( 'consulting_show_template' ) ) {

				$settings['css_class'] = ' consulting_elementor_services';

				consulting_load_vc_element( 'services', $settings, $settings['style'] );

			}
		} else {
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
			$args  = array(
				'post_type'      => 'stm_service',
				'posts_per_page' => $settings['posts_per_page_new'],
				'paged'          => $paged,
			);

			if ( 'all' !== $settings['category'] ) {
				$args['stm_service_category'] = $settings['category'];
			}

			$services = new WP_Query( $args );

			$css_class  = $settings['style'];
			$css_class .= ! empty( $settings['posts_per_row'] ) ? ' posts_per_row_' . $settings['posts_per_row'] : ' posts_per_row_3';
			$css_class .= ! empty( $settings['content_alignment'] ) ? ' content_alignment_' . $settings['content_alignment'] : ' content_alignment_left';
			$css_class .= ! empty( $settings['add_box_style'] ) ? ' box_style_' . $settings['add_box_style'] : ' box_style_no';
			$css_class .= ! empty( $settings['carousel_dots_alignment'] ) ? ' dots_alignment_' . $settings['carousel_dots_alignment'] : ' dots_alignment_center';
			$css_class .= 'with_icons' === $settings['style'] && 'yes' === $settings['show_divider'] ? ' show_divider_' . $settings['show_divider'] : '';

			if ( $services->have_posts() ) {
				?>
				<div data-carousel="<?php echo esc_attr( $settings['enable_carousel'] ); ?>" class="consulting-services consulting-elementor-services <?php echo esc_attr( $css_class ); ?>" data-per-row="<?php echo esc_attr( $settings['posts_per_row'] ); ?>">
					<?php
					while ( $services->have_posts() ) {
						set_query_var( 'i', $i );
						$settings['count'] = $i;
						$services->the_post();
						stm_load_variations_template( $settings, '/services/styles/' . $settings['style'] );
						$i ++;
					}
					wp_reset_postdata();
					?>
				</div>
				<?php
			}
		}
	}
}
