<?php
/**
 * @var $settings
 */

$image_size = empty( $settings['image_size'] ) ? 'consulting-image-540x320-croped' : $settings['image_size'];

$term_list = wp_get_post_terms( get_the_ID(), 'stm_service_category' ); ?>

<div class="service-item">
	<div class="service-item-wrapper">
		<?php if ( ! $settings['service_image'] && has_post_thumbnail() ) { ?>
			<div class="service-item-image">
				<a href="<?php the_permalink(); ?>">
					<?php echo wp_kses_post( consulting_get_image( get_post_thumbnail_id(), $image_size ) ); ?>
					<span class="service-item-icon">
						<i class="<?php echo esc_attr( get_post_meta( get_the_ID(), 'service_icon', true ) ); ?>"></i>
					</span>
				</a>
			</div>
		<?php } ?>
		<div class="service-item-content">
			<?php
			if ( 'yes' === $settings['show_category'] && $term_list ) {
				?>
				<div class="service-item-category">
					<?php echo esc_html( $term_list[0]->name ); ?>
				</div>
				<?php
			}
			if ( ! $settings['service_title'] ) {
				?>
				<h5 class="service-item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
				<?php
			}
			?>
		</div>
	</div>
</div>
