<?php
/**
 * @var $settings
 */
?>

<div class="service-item">
	<div class="service-item-wrapper">
		<div class="service-item-content">
			<?php if ( ! $settings['service_title'] ) { ?>
				<h5 class="service-item-title <?php echo isset( $settings['title_line_under'] ) ? 'title_line_' . esc_attr( $settings['title_line_under'] ) : ''; ?>"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
				<?php
			}
			if ( 'yes' === $settings['show_description'] ) {
				?>
				<div class="service-item-description">
					<?php
					the_excerpt();
					?>
				</div>
				<?php
			}
			if ( 'yes' === $settings['show_read_more'] ) {
				?>
				<a class="service-item-read-more" href="<?php the_permalink(); ?>">
					<?php
					if ( 'before' === $settings['read_more_icon_position'] ) {
						echo '<span class="read_more_icon_wrapper before_icon">';
						\Elementor\Icons_Manager::render_icon(
							$settings['read_more_icon'],
							array(
								'aria-hidden' => 'true',
								'class'       => 'read_more_icon',
							)
						);
						echo '</span>';
					}
					echo '<span>' . esc_html( $settings['button_text'] ) . '</span>';
					if ( 'after' === $settings['read_more_icon_position'] ) {
						echo '<span class="read_more_icon_wrapper after_icon">';
						\Elementor\Icons_Manager::render_icon(
							$settings['read_more_icon'],
							array(
								'aria-hidden' => 'true',
								'class'       => 'read_more_icon',
							)
						);
						echo '</span>';
					}
					?>
				</a>
			<?php } ?>
		</div>
	</div>
</div>
