<?php
/**
 * @var $settings
 */

$image_size = empty( $settings['image_size'] ) ? 'consulting-image-540x320-croped' : $settings['image_size'];

?>

<div class="service-item">
	<div class="service-item-wrapper">
		<?php if ( ! $settings['service_image'] && has_post_thumbnail() ) { ?>
			<div class="service-item-image">
				<a href="<?php the_permalink(); ?>">
					<?php echo wp_kses_post( consulting_get_image( get_post_thumbnail_id(), $image_size ) ); ?>
				</a>
				<h5 class="service-item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
			</div>
		<?php } ?>
		<div class="service-item-content">
			<?php
			if ( 'yes' === $settings['show_description'] ) {
				?>
				<div class="service-item-description">
					<?php
					the_excerpt();
					?>
				</div>
				<?php
			}
			if ( 'yes' === $settings['show_read_more'] ) {
				?>
				<a class="service-item-read-more" href="<?php the_permalink(); ?>">
					<?php
					if ( 'before' === $settings['read_more_icon_position'] ) {
						echo '<span class="read_more_icon_wrapper before_icon">';
						\Elementor\Icons_Manager::render_icon(
							$settings['read_more_icon'],
							array(
								'aria-hidden' => 'true',
								'class'       => 'read_more_icon',
							)
						);
						echo '</span>';
					}
					echo '<span>' . esc_html( $settings['button_text'] ) . '</span>';
					if ( 'after' === $settings['read_more_icon_position'] ) {
						echo '<span class="read_more_icon_wrapper after_icon">';
						\Elementor\Icons_Manager::render_icon(
							$settings['read_more_icon'],
							array(
								'aria-hidden' => 'true',
								'class'       => 'read_more_icon',
							)
						);
						echo '</span>';
					}
					?>
				</a>
			<?php } ?>
		</div>
	</div>
</div>
