<?php
/**
 * @var $settings
 */
?>

<div class="service-item">
	<div class="service-item-wrapper">
		<div class="service-item-content">
			<div class="service-item-icon <?php echo 'icon_shape_' . esc_attr( $settings['icon_shape'] ); ?> <?php echo 'icon_position_' . esc_attr( $settings['icon_position'] ); ?>">
				<div class="service-item-icon-wrapper">
					<i class="<?php echo esc_attr( get_post_meta( get_the_ID(), 'service_icon', true ) ); ?>"></i>
				</div>
			</div>
			<?php if ( ! $settings['service_title'] ) { ?>
				<h5 class="service-item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
				<?php
			}
			if ( 'yes' === $settings['show_description'] ) {
				?>
				<div class="service-item-description">
					<?php
					the_excerpt();
					?>
				</div>
				<?php
			}
			if ( 'yes' === $settings['show_read_more'] ) {
				?>
				<a class="service-item-read-more" href="<?php the_permalink(); ?>">
					<?php
					if ( 'before' === $settings['read_more_icon_position'] ) {
						echo '<span class="read_more_icon_wrapper before_icon">';
						\Elementor\Icons_Manager::render_icon(
							$settings['read_more_icon'],
							array(
								'aria-hidden' => 'true',
								'class'       => 'read_more_icon',
							)
						);
						echo '</span>';
					}
					echo '<span>' . esc_html( $settings['button_text'] ) . '</span>';
					if ( 'after' === $settings['read_more_icon_position'] ) {
						echo '<span class="read_more_icon_wrapper after_icon">';
						\Elementor\Icons_Manager::render_icon(
							$settings['read_more_icon'],
							array(
								'aria-hidden' => 'true',
								'class'       => 'read_more_icon',
							)
						);
						echo '</span>';
					}
					?>
				</a>
			<?php } ?>
		</div>
	</div>
</div>
