<?php
/**
 * @var $settings
 */

wp_enqueue_style( 'owl.carousel' );
wp_enqueue_script( 'owl.carousel' );
?>
<div class="service-item">
	<div class="service-item-wrapper">
		<div class="service-item-icon <?php echo 'icon_shape_' . esc_attr( $settings['icon_shape'] ); ?> <?php echo 'icon_position_' . esc_attr( $settings['icon_position'] ); ?>">
			<div class="service-item-icon-wrapper">
				<i class="stm-icon <?php echo esc_attr( get_post_meta( get_the_ID(), 'service_icon', true ) ); ?>"></i>
			</div>
		</div>
		<div class="service-item-content">
			<?php if ( ! $settings['service_title'] ) { ?>
				<h5 class="service-item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
				<?php
			}
			if ( 'yes' === $settings['show_description'] ) {
				?>
				<div class="service-item-description">
					<?php
					the_excerpt();
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
