<?php

use Elementor\Controls_Manager;

class Elementor_STM_Services_Tabs extends \Elementor\Widget_Base {

	public function get_name() {
		return 'stm_services_tabs';
	}

	public function get_title() {
		return esc_html__( 'Services Tabs', 'consulting-elementor-widgets' );
	}

	public function get_icon() {
		return 'consulting-eicon-star';
	}

	public function get_categories() {
		return array( 'consulting-widgets' );
	}

	public function get_script_depends() {
		return array( 'jquery-effects-core', 'jquery-ui-tabs' );
	}

	public function add_dimensions( $selector = '' ) {
		$this->start_controls_section(
			'section_dimensions',
			array(
				'label' => __( 'Dimensions', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_responsive_control(
			'margin',
			array(
				'label'      => __( 'Margin', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			array(
				'label' => __( 'Content', 'plugin-name' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'style',
			array(
				'label'   => __( 'Style', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'style_1',
				'options' => array(
					'style_1' => __( 'Style 1', 'consulting-elementor-widgets' ),
					'style_2' => __( 'Style 2', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'items_count',
			array(
				'label'       => __( 'Items Count', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'style' => 'style_1',
				),
				'description' => __( 'The number of items you want to see on the screen.', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'items_count_2',
			array(
				'label'       => __( 'Items Count', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'3' => __( '3 Items', 'consulting-elementor-widgets' ),
					'4' => __( '4 Items', 'consulting-elementor-widgets' ),
				),
				'default'     => '4',
				'condition'   => array(
					'style' => 'style_2',
				),
				'description' => __( 'The number of items you want to see on the screen.', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'el_class',
			array(
				'label'       => __( 'Extra class name', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'consulting-elementor-widgets' ),
			)
		);

		$this->end_controls_section();

		$this->add_dimensions( '.consulting_elementor_services_tabs' );
	}

	protected function render() {
		if ( function_exists( 'consulting_show_template' ) ) {

			$settings = $this->get_settings_for_display();

			$settings['css_class'] = ' consulting_elementor_services_tabs';

			consulting_load_vc_element( 'services_tabs', $settings, $settings['style'] );

		}
	}
}
