<?php

/**
 * @var $settings
 * @var $css_class
 * @var $count
 * @var $category
 * @var $disable_carousel
 * @var $disable_image
 * @var $style
 * @var $show_quote
 * @var $navigation_type
 * @var $autoplay_carousel
 * @var $autoplay_time
 * @var $box_position
 * @var $excerpt_length
 */

extract( $settings );

if ( ! empty( $style ) ) {
	$css_class .= ' ' . esc_attr( $style );
}

if ( ! empty( $show_quote ) ) {
	$css_class .= ' show-quote';
}

if ( ! empty( $box_position ) ) {
	$css_class .= ' box-position-' . $box_position;
}

if ( empty( $navigation_type ) ) {
	$navigation_type = 'arrows';
}
$css_class .= ' nav-type-' . $navigation_type;


$autoplay_carousel_js = ( 'yes' === $autoplay_carousel ) ? 'true' : 'false';
$autoplay_time        = ( 'yes' === $autoplay_carousel ) ? $autoplay_time : 5000;

$count = ( $count > 0 ) ? $count : 999;

$args = array(
	'post_type'      => 'stm_testimonials',
	'posts_per_page' => $count,
);

if ( 'all' !== $category ) {
	$args['stm_testimonials_category'] = $category;
}

if ( $disable_carousel ) {
	$css_class .= ' disable_carousel';
}

if ( empty( $thumb_size ) ) {
	$thumb_size = 'full';
}

$excerpt_length = ( ! empty( $excerpt_length ) ) ? intval( $excerpt_length ) : 0;

$testimonials = new WP_Query( $args );
$id           = uniqid( 'testimonial_carousel_' );

$amount_dots = min( $testimonials->found_posts, $count );

$carousel_attr = '';
if ( ! $disable_carousel ) {
	$carousel_attr .= ' data-autoplay="' . $autoplay_carousel_js . '"';
	$carousel_attr .= ' data-time="' . $autoplay_time . '"';
	$carousel_attr .= ' data-navtype="' . $navigation_type . '"';
}

if ( $testimonials->have_posts() ) : ?>
	<div class="<?php echo esc_attr( $css_class ); ?>" id="<?php echo esc_attr( $id ); ?>" <?php echo wp_kses_post( $carousel_attr ); ?>>
		<?php
		$p_i = 1;
		while ( $testimonials->have_posts() ) :
			$testimonials->the_post();

			$author_photo = consulting_get_image( get_post_thumbnail_id(), $thumb_size );

			$image_url = '';
			if ( ! $disable_image && has_post_thumbnail() ) {
				$featured_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if ( ! empty( $featured_image[0] ) ) {
					$image_url = $featured_image[0];
				}
			}
			?>

			<div class="consulting-testimonial">
				<div class="consulting-testimonial-inner" style="background-image: url(<?php echo esc_attr( $image_url ); ?>);">
					<div class="consulting-testimonial__container">
						<div class="consulting-testimonial__info">
							<?php if ( ! empty( $show_quote ) && ( empty( $navigation_type ) || 'arrows' === $navigation_type ) ) : ?>
								<i class="fas fa-quote-left testimonial-quote"></i>
							<?php endif; ?>
							<div class="consulting-testimonial__excerpt">
								<?php echo wp_kses_post( get_consulting_excerpt( get_the_excerpt(), $excerpt_length ) ); ?>
							</div>
							<?php if ( ! empty( $show_quote ) && 'bullets' === $navigation_type ) : ?>
								<i class="stm-quote2 testimonial-quote-bullet"></i>
							<?php endif; ?>
							<div class="consulting-testimonial__bottom">
								<div class="consulting-testimonial__author">
									<h6 class="consulting-testimonial__heading">
										<?php
										if ( $link['url'] ) {
											echo '<a href="' . esc_url( $link['url'] ) . '">';
											the_title();
											echo '</a>';
										} else {
											the_title();
										}
										?>
									</h6>
									<div class="consulting-testimonial__position">
										<?php
										$position = get_post_meta( get_the_ID(), 'testimonial_position', true );
										if ( ! empty( $position ) ) {
											echo esc_html( $position ) . ', ';
										}
										echo esc_html( get_post_meta( get_the_ID(), 'testimonial_company', true ) );
										?>
									</div>
								</div>
								<?php if ( empty( $navigation_type ) || 'arrows' === $navigation_type ) : ?>
									<div class="slick-navs">
										<div class="slick-prev slick-prev-extra">
											<i class="fas fa-chevron-left"></i>
										</div>
										<div class="slick-next slick-next-extra">
											<i class="fas fa-chevron-right"></i>
										</div>
									</div>
								<?php elseif ( 'bullets' === $navigation_type ) : ?>
									<div class="slick-bullets">
										<ul class="slick-dots" role="tablist">
											<?php for ( $i = 1; $i <= $amount_dots; $i++ ) { ?>
												<li role="presentation" <?php echo ( $p_i === $i ) ? 'class="slick-active"' : ''; ?> data-index="<?php echo esc_attr( $i - 1 ); ?>">
													<button type="button" role="tab" tabindex="0" data-index="<?php echo esc_attr( $i - 1 ); ?>"></button>
												</li>
												<?php
											}
											?>
										</ul>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php $p_i++; ?>
		<?php endwhile; ?>
	</div>
<?php endif;
wp_reset_postdata(); ?>
