<?php

/**
 * @var $settings
 * @var $css_class
 * @var $count
 * @var $category
 * @var $disable_carousel
 * @var $disable_image
 * @var $style
 * @var $disable_carousel_arrows
 * @var $show_quote
 * @var $show_navigation
 * @var $hide_navigation_on_mobile
 * @var $navigation_position
 * @var $navigation_vertical_position
 * @var $autoplay_carousel
 * @var $autoplay_time
 * @var $show_pagination
 * @var $hide_pagination_on_mobile
 * @var $pagination_alignment
 * @var $image_size
 * @var $excerpt_length
 */

extract( $settings );

if ( ! empty( $style ) ) {
	$css_class .= ' ' . esc_attr( $style );
}

if ( ! empty( $show_quote ) ) {
	$css_class .= ' show-quote';
}

if ( ! empty( $hide_navigation_on_mobile ) ) {
	$css_class .= ' hide-navs-xs';
}

if ( ! empty( $hide_pagination_on_mobile ) ) {
	$css_class .= ' hide-dots-xs';
}

if ( $show_navigation ) {
	if ( ! empty( $navigation_position ) ) {
		$css_class .= ' nav-' . $navigation_position;
	}
	if ( ! empty( $navigation_vertical_position ) && 'together' === $navigation_position ) {
		$css_class .= ' nav-' . $navigation_vertical_position;
	}
}

if ( $show_pagination ) {
	if ( ! empty( $pagination_alignment ) ) {
		$css_class .= ' dots-' . $pagination_alignment;
	}
}

$autoplay_carousel_js = ( 'yes' === $autoplay_carousel ) ? 'true' : 'false';
$autoplay_time        = ( 'yes' === $autoplay_carousel ) ? $autoplay_time : 5000;

$args = array(
	'post_type'      => 'stm_testimonials',
	'posts_per_page' => $count,
);

if ( 'all' !== $category ) {
	$args['stm_testimonials_category'] = $category;
}

if ( $disable_carousel ) {
	$css_class .= ' disable_carousel';
}

if ( empty( $image_size ) ) {
	$image_size = '600x600';
}

$excerpt_length = ( ! empty( $excerpt_length ) ) ? intval( $excerpt_length ) : 0;

$testimonials = new WP_Query( $args );
$id           = uniqid( 'testimonial_carousel_' );

$carousel_attr = '';
if ( ! $disable_carousel ) {
	$carousel_attr .= ( $show_navigation ) ? ' data-navs="true"' : ' data-navs="false"';
	$carousel_attr .= ( $show_pagination ) ? ' data-dots="true"' : ' data-dots="false"';
	$carousel_attr .= ' data-autoplay="' . $autoplay_carousel_js . '"';
	$carousel_attr .= ' data-time="' . $autoplay_time . '"';
	$carousel_attr .= ' data-slides="1"';
}

if ( $testimonials->have_posts() ) : ?>
	<div class="<?php echo esc_attr( $css_class ); ?>" id="<?php echo esc_attr( $id ); ?>" <?php echo wp_kses_post( $carousel_attr ); ?>>
		<?php
		while ( $testimonials->have_posts() ) :
			$testimonials->the_post();
			?>

			<div class="consulting-testimonial">
				<div class="consulting-testimonial-inner">
					<?php
					if ( ! $disable_image && has_post_thumbnail() ) :
						$author_photo = consulting_get_image( get_post_thumbnail_id(), $image_size );
						?>
						<div class="consulting-testimonial__image">
							<span>
								<?php echo wp_kses_post( consulting_filtered_output( $author_photo ) ); ?>
							</span>
						</div>
					<?php endif; ?>
					<div class="consulting-testimonial__info">
						<h6 class="consulting-testimonial__heading">
							<?php
							if ( $link['url'] ) {
								echo '<a href="' . esc_url( $link['url'] ) . '">';
								the_title();
								echo '</a>';
							} else {
								the_title();
							}
							?>
						</h6>
						<div class="consulting-testimonial__position">
							<?php
							$position = get_post_meta( get_the_ID(), 'testimonial_position', true );
							if ( ! empty( $position ) ) {
								echo esc_html( $position ) . ', ';
							}
							echo esc_html( get_post_meta( get_the_ID(), 'testimonial_company', true ) );
							?>
						</div>
						<div class="consulting-testimonial__excerpt">
							<?php if ( ! empty( $show_quote ) ) : ?>
								<i class="stm-quote_13"></i>
								<?php
							endif;
							echo wp_kses_post( get_consulting_excerpt( get_the_excerpt(), $excerpt_length ) );
							?>
						</div>
					</div>
				</div>
			</div>

		<?php endwhile; ?>
	</div>

	<?php
endif;
wp_reset_postdata();
