<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;

class Elementor_STM_Testimonials_Carousel extends \Elementor\Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );
		wp_register_style( 'consulting-testimonials-carousel-style-10', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials-carousel/style_10.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-carousel-side-image', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials-carousel/side_image.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-carousel-side-image-2', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials-carousel/side_image_2.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-carousel-top-image', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials-carousel/top_image.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-carousel-info-above', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials-carousel/info_above.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-carousel-full-image', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials-carousel/full_image.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_script( 'consulting-testimonials-carousel', CONSULTING_ELEMENTOR_URL . 'assets/js/widgets/testimonials-carousel.js', array( 'elementor-frontend', 'isotope' ), CONSULTING_ELEMENTOR_VERSION, true );
	}
	public function get_name() {
		return 'stm_testimonials_carousel';
	}

	public function get_title() {
		return esc_html__( 'Testimonials Carousel', 'consulting-elementor-widgets' );
	}

	public function get_icon() {
		return 'consulting-eicon-testimonials';
	}

	public function get_categories() {
		return array( 'consulting-widgets' );
	}

	public function get_script_depends() {
		return array( 'slick', 'consulting-testimonials-carousel' );
	}

	public function get_style_depends() {
		return array(
			'slick',
			'consulting-testimonials-carousel-style-10',
			'consulting-testimonials-carousel-side-image',
			'consulting-testimonials-carousel-side-image-2',
			'consulting-testimonials-carousel-top-image',
			'consulting-testimonials-carousel-info-above',
			'consulting-testimonials-carousel-full-image',
		);
	}

	public function add_dimensions( $selector = '' ) {
		$this->start_controls_section(
			'section_dimensions',
			array(
				'label' => __( 'Dimensions', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_responsive_control(
			'margin',
			array(
				'label'      => __( 'Margin', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function register_controls() {
		$testimonial_categories_array = get_terms( 'stm_testimonials_category' );
		$testimonial_categories       = array(
			'all' => esc_html__( 'All', 'consulting-elementor-widgets' ),
		);
		if ( $testimonial_categories_array && ! is_wp_error( $testimonial_categories_array ) ) {
			foreach ( $testimonial_categories_array as $cat ) {
				$testimonial_categories[ $cat->slug ] = $cat->name;
			}
		}

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'style',
			array(
				'label'   => __( 'Style', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'side_image',
				'options' => array(
					'side_image'   => esc_html__( 'Side Image', 'consulting-elementor-widgets' ),
					'side_image_2' => esc_html__( 'Side Image 2', 'consulting-elementor-widgets' ),
					'top_image'    => esc_html__( 'Top Image', 'consulting-elementor-widgets' ),
					'info_above'   => esc_html__( 'Info Above', 'consulting-elementor-widgets' ),
					'full_image'   => esc_html__( 'Full Image', 'consulting-elementor-widgets' ),
					'style_1'      => esc_html__( 'Style 1', 'consulting-elementor-widgets' ),
					'style_2'      => esc_html__( 'Style 2', 'consulting-elementor-widgets' ),
					'style_3'      => esc_html__( 'Style 3', 'consulting-elementor-widgets' ),
					'style_4'      => esc_html__( 'Style 4', 'consulting-elementor-widgets' ),
					'style_5'      => esc_html__( 'Style 5', 'consulting-elementor-widgets' ),
					'style_6'      => esc_html__( 'Style 6', 'consulting-elementor-widgets' ),
					'style_7'      => esc_html__( 'Style 7', 'consulting-elementor-widgets' ),
					'style_8'      => esc_html__( 'Style 8', 'consulting-elementor-widgets' ),
					'style_9'      => esc_html__( 'Style 9', 'consulting-elementor-widgets' ),
					'style_10'     => esc_html__( 'Style 10', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'category',
			array(
				'label'   => __( 'Category', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT2,
				'options' => $testimonial_categories,
				'default' => 'all',
			)
		);

		$this->add_control(
			'count',
			array(
				'label'   => __( 'Count', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => 0,
			)
		);

		$this->add_control(
			'thumb_size',
			array(
				'label'       => __( 'Photo - Size', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter photo size 350x250', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style' => 'style_1',
				),
			)
		);

		$this->add_control(
			'per_row',
			array(
				'label'     => __( 'Testimonials Per Row', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
					5 => 5,
				),
				'condition' => array(
					'style!' => array( 'style_10', 'side_image_2', 'full_image' ),
				),
				'default'   => 2,
			),
		);

		$this->add_control(
			'excerpt_length',
			array(
				'label'       => __( 'Excerpt length', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'e.g. 160', 'consulting-elementor-widgets' ),
				'description' => __( 'Trims text to a certain number of symbols.', 'consulting-elementor-widgets' ),
				'default'     => 0,
			)
		);

		$this->add_control(
			'link',
			array(
				'label'         => __( 'Link', 'consulting-elementor-widgets' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'show_external' => true,
				'style!'        => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_settings',
			array(
				'label' => __( 'Carousel Settings', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'show_navigation',
			array(
				'label'        => __( 'Show Navigation', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
				),
			)
		);

		$this->add_control(
			'navigation_position',
			array(
				'label'     => __( 'Navigation Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'separate' => esc_html__( 'Separate', 'consulting-elementor-widgets' ),
					'together' => esc_html__( 'Together', 'consulting-elementor-widgets' ),
				),
				'default'   => 'separate',
				'condition' => array(
					'style'           => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'show_navigation' => 'yes',
				),
			)
		);

		$this->add_control(
			'navigation_alignment',
			array(
				'label'     => __( 'Navigation Alignment', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'style'               => array( 'side_image', 'top_image', 'info_above' ),
					'navigation_position' => 'together',
					'show_navigation'     => 'yes',
				),
			)
		);

		$this->add_control(
			'navigation_vertical_position',
			array(
				'label'     => __( 'Navigation Vertical Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'top'    => esc_html__( 'Top', 'consulting-elementor-widgets' ),
					'bottom' => esc_html__( 'Bottom', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'style'               => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'show_navigation'     => 'yes',
					'navigation_position' => 'together',
				),
			)
		);

		$this->add_control(
			'navigation_horizontal_offset',
			array(
				'label'        => __( 'Navigation Horizontal Offset', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SLIDER,
				'size_units'   => array( 'px', 'em', 'rem', 'custom' ),
				'range'        => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'    => array(
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .slick-prev'   => 'left: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .slick-next'   => 'right: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .slick-prev' => 'left: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .slick-next' => 'right: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .slick-prev'    => 'left: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .slick-next'    => 'right: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .slick-prev'   => 'left: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .slick-next'   => 'right: -{{SIZE}}{{UNIT}};',
				),
				'default'      => array(
					'size' => 90,
					'unit' => 'px',
				),
				'return_value' => '90',
				'condition'    => array(
					'style'               => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'show_navigation'     => 'yes',
					'navigation_position' => 'separate',
				),
			)
		);

		$this->add_control(
			'hide_navigation_on_mobile',
			array(
				'label'     => __( 'Hide on Mobile', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_mage' ),
				),
			)
		);

		$this->add_control(
			'navigation_type',
			array(
				'label'     => __( 'Navigation Type', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'arrows'  => esc_html__( 'Arrows', 'consulting-elementor-widgets' ),
					'bullets' => esc_html__( 'Bullets', 'consulting-elementor-widgets' ),
				),
				'default'   => 'arrows',
				'condition' => array(
					'style' => array( 'style_3', 'style_4', 'style_5', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'show_pagination',
			array(
				'label'        => __( 'Show Pagination', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'separator'    => 'before',
				'condition'    => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
				),
			)
		);

		$this->add_control(
			'pagination_alignment',
			array(
				'label'     => __( 'Pagination Alignment', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
				),
				'default'   => 'center',
				'condition' => array(
					'style'           => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'show_pagination' => 'yes',
				),
			)
		);

		$this->add_control(
			'pagination_vertical_offset',
			array(
				'label'      => __( 'Pagination Vertical Offset', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .slick-dots'   => 'margin-top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .slick-dots' => 'margin-top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .slick-dots'    => 'margin-top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .slick-dots'   => 'margin-top: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'size' => 22,
					'unit' => 'px',
				),
				'condition'  => array(
					'style'           => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'show_pagination' => 'yes',
				),
			)
		);

		$this->add_control(
			'space_between_bullets',
			array(
				'label'      => __( 'Space Between Bullets', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .slick-dots > li'   => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .slick-dots > li' => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .slick-dots > li'    => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .slick-dots > li'   => 'margin-right: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'size' => 10,
					'unit' => 'px',
				),
				'condition'  => array(
					'style'           => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'show_pagination' => 'yes',
				),
			)
		);

		$this->add_control(
			'space_between_bullets_full_image',
			array(
				'label'      => __( 'Space Between Bullets', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .slick-dots > li'   => 'margin-right: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'size' => 10,
					'unit' => 'px',
				),
				'condition'  => array(
					'style'           => array( 'full_image' ),
					'navigation_type' => 'bullets',
				),
			)
		);

		$this->add_control(
			'hide_pagination_on_mobile',
			array(
				'label'     => __( 'Hide on Mobile', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_mage' ),
				),
			)
		);

		$this->add_control(
			'autoplay_carousel',
			array(
				'label'        => __( 'Carousel Autoplay', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'separator'    => 'before',
				'return_value' => 'yes',
				'description'  => esc_html__( 'Enable autoplay mode.', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'autoplay_time',
			array(
				'label'       => __( 'Autoplay Timeout', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 5000,
				'description' => esc_html__( 'Autoplay interval timeout (in ms).', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'autoplay_carousel' => 'yes',
					'style'             => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'disable_carousel_arrows',
			array(
				'label'        => __( 'Disable Carousel Arrows', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style!' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'timeout',
			array(
				'label'       => __( 'Autoplay Timeout', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 5000,
				'description' => esc_html__( 'Autoplay interval timeout (in ms).', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'autoplay' => 'yes',
				),
			)
		);

		$this->add_control(
			'loop',
			array(
				'label'        => __( 'Slider Loop', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'description'  => esc_html__( 'Enable slider loop mode.', 'consulting-elementor-widgets' ),
				'condition'    => array(
					'style' => array( 'style_3', 'style_4', 'style_5' ),
				),
			)
		);

		$this->add_control(
			'navigation',
			array(
				'label'        => __( 'Slider Navigation', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'hide',
				'description'  => esc_html__( 'Disable navigation.', 'consulting-elementor-widgets' ),
				'condition'    => array(
					'style' => array( 'style_3', 'style_4', 'style_5' ),
				),
			)
		);

		$this->add_control(
			'smart_speed',
			array(
				'label'     => __( 'Smart Speed', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 250,
				'condition' => array(
					'style' => array( 'style_3', 'style_4', 'style_5' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text_section',
			array(
				'label' => __( 'Text', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'name_color',
			array(
				'label'     => __( 'Name Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonials_carousel.style_1 .testimonial .info h4'                                                       => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_2 .testimonial-info .testimonial-text .name'                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_3 .testimonial .testimonial_inner .info h6'                                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_4 .testimonial .testimonial_inner .info h6'                                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_5 .testimonial .testimonial_inner .info h6'                                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_6 .item .testimonial-info .testimonial-text .name'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_7 .item .testimonial-info .testimonial-text .name'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_8 .item .testimonial-info .testimonial-text .name'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_9 .testimonial .testimonial-inner .testimonial-info .testimonial-bottom .name' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_10 .testimonial .testimonial_inner .info .testimonial_name'                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .consulting-testimonial__heading'                              => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .consulting-testimonial__heading'                            => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .consulting-testimonial__heading'                               => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .consulting-testimonial__heading'                              => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__heading'                              => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'name_color_hover',
			array(
				'label'     => __( 'Name Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonials_carousel.style_1 .testimonial .info h4:hover'                                                       => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_2 .testimonial-info .testimonial-text .name:hover'                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_3 .testimonial .testimonial_inner .info h6:hover'                                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_4 .testimonial .testimonial_inner .info h6:hover'                                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_5 .testimonial .testimonial_inner .info h6:hover'                                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_6 .item .testimonial-info .testimonial-text .name:hover'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_7 .item .testimonial-info .testimonial-text .name:hover'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_8 .item .testimonial-info .testimonial-text .name:hover'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_9 .testimonial .testimonial-inner .testimonial-info .testimonial-bottom .name:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_10 .testimonial .testimonial_inner .info .testimonial_name:hover'                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .consulting-testimonial__heading:hover'                              => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .consulting-testimonial__heading:hover'                            => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .consulting-testimonial__heading:hover'                               => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .consulting-testimonial__heading:hover'                              => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__heading:hover'                              => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'name_typography',
				'label'    => __( 'Name Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__heading',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_responsive_control(
			'name_margin',
			array(
				'label'      => __( 'Name Margin', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'position_color',
			array(
				'label'     => __( 'Position Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'separator' => 'before',
				'selectors' => array(
					'{{WRAPPER}} .testimonials_carousel.style_1 .testimonial .info .position' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'style_1' ),
				),
			)
		);

		$this->add_control(
			'position_color_hover',
			array(
				'label'     => __( 'Position Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonials_carousel.style_1 .testimonial .info .position:hover' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'style_1' ),
				),
			)
		);

		$this->add_control(
			'company_color',
			array(
				'label'     => __( 'Company Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'separator' => 'before',
				'selectors' => array(
					'{{WRAPPER}} .testimonials_carousel.style_1 .testimonial .info .company'                                                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_2 .testimonial-info .testimonial-text .company'                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_3 .testimonial .testimonial_inner .info .position'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_4 .testimonial .testimonial_inner .info .position'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_5 .testimonial .testimonial_inner .info .position'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_6 .item .testimonial-info .testimonial-text .company'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_7 .item .testimonial-info .testimonial-text .company'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_8 .item .testimonial-info .testimonial-text .company'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_9 .testimonial .testimonial-inner .testimonial-info .testimonial-bottom .company' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_10 .testimonial .testimonial_inner .info .position'                               => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .consulting-testimonial__position'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .consulting-testimonial__position'                              => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .consulting-testimonial__position'                                 => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .consulting-testimonial__position'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__position'                                => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'company_color_hover',
			array(
				'label'     => __( 'Company Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonials_carousel.style_1 .testimonial .info .company'                                                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_2 .testimonial-info .testimonial-text .company:hover'                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_3 .testimonial .testimonial_inner .info .position:hover'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_4 .testimonial .testimonial_inner .info .position:hover'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_5 .testimonial .testimonial_inner .info .position:hover'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_6 .item .testimonial-info .testimonial-text .company:hover'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_7 .item .testimonial-info .testimonial-text .company:hover'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_8 .item .testimonial-info .testimonial-text .company:hover'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_9 .testimonial .testimonial-inner .testimonial-info .testimonial-bottom .company:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_10 .testimonial .testimonial_inner .info .position:hover'                               => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .consulting-testimonial__position:hover'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .consulting-testimonial__position:hover'                              => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .consulting-testimonial__position:hover'                                 => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .consulting-testimonial__position:hover'                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__position:hover'                                => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'           => 'company_typography',
				'label'          => __( 'Company Typography', 'consulting-elementor-widgets' ),
				'selector'       => '{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__position',
				'global'         => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
				'fields_options' => array(
					'font_weight' => array(
						'default' => '500',
					),
				),
			)
		);

		$this->add_responsive_control(
			'company_margin',
			array(
				'label'      => __( 'Company Margin', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__position' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'colorpicker',
			array(
				'label'     => __( 'Excerpt Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'separator' => 'before',
				'selectors' => array(
					'{{WRAPPER}} .testimonials_carousel.style_1 .testimonial .info p'                                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_2 .item .testimonial p'                                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_3 .testimonial .testimonial_inner .info .stm_testimonials_content_unit p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_4 .testimonial .testimonial_inner .info .stm_testimonials_content_unit p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_5 .testimonial .testimonial_inner .info .stm_testimonials_content_unit p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_6 .item .testimonial p'                                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_7 .item .testimonial-info .testimonial p'                                 => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_8 .item .testimonial p'                                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_9 .testimonial .testimonial-inner .testimonial-text p'                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_10 .testimonial .info .stm_testimonials_content_unit p'                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .consulting-testimonial__excerpt p'                       => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .consulting-testimonial__excerpt p'                     => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .consulting-testimonial__excerpt p'                        => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .consulting-testimonial__excerpt p'                       => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__excerpt p'                       => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'colorpicker_hover',
			array(
				'label'     => __( 'Excerpt Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonials_carousel.style_1 .testimonial .info:hover p'                                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_2 .item .testimonial:hover p'                                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_3 .testimonial .testimonial_inner .info .stm_testimonials_content_unit:hover p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_4 .testimonial .testimonial_inner .info .stm_testimonials_content_unit:hover p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_5 .testimonial .testimonial_inner .info .stm_testimonials_content_unit:hover p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_6 .item .testimonial:hover p'                                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_7 .item .testimonial-info .testimonial:hover p'                                 => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_8 .item .testimonial:hover p'                                                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_9 .testimonial .testimonial-inner .testimonial-text:hover p'                    => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonials_carousel.style_10 .testimonial .info .stm_testimonials_content_unit:hover p'                   => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image .consulting-testimonial__excerpt:hover p'                       => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.side_image_2 .consulting-testimonial__excerpt:hover p'                     => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.top_image .consulting-testimonial__excerpt:hover p'                        => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.info_above .consulting-testimonial__excerpt:hover p'                       => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__excerpt:hover p'                       => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'excerpt_typography',
				'label'    => __( 'Excerpt Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__excerpt',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_responsive_control(
			'excerpt_margin',
			array(
				'label'      => __( 'Excerpt Margin', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'image_section',
			array(
				'label' => __( 'Image', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'disable_image',
			array(
				'label'        => __( 'Disable Image', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'background_position',
			array(
				'label'     => __( 'Background Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					''              => esc_html__( 'Default', 'elementor' ),
					'center center' => esc_html__( 'Center Center', 'consulting-elementor-widgets' ),
					'center left'   => esc_html__( 'Center Left', 'consulting-elementor-widgets' ),
					'center right'  => esc_html__( 'Center Right', 'consulting-elementor-widgets' ),
					'top center'    => esc_html__( 'Top Center', 'consulting-elementor-widgets' ),
					'top left'      => esc_html__( 'Top Left', 'consulting-elementor-widgets' ),
					'top right'     => esc_html__( 'Top Right', 'consulting-elementor-widgets' ),
					'bottom center' => esc_html__( 'Bottom Center', 'consulting-elementor-widgets' ),
					'bottom left'   => esc_html__( 'Bottom Left', 'consulting-elementor-widgets' ),
					'bottom right'  => esc_html__( 'Bottom Right', 'consulting-elementor-widgets' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial-inner' => 'background-position: {{VALUE}};',
				),
				'condition' => array(
					'style'          => array( 'full_image' ),
					'disable_image!' => 'yes',
				),
			)
		);

		$this->add_control(
			'background_repeat',
			array(
				'label'     => __( 'Background Repeat', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					''          => esc_html__( 'Default', 'consulting-elementor-widgets' ),
					'no-repeat' => esc_html__( 'No-repeat', 'elementor' ),
					'repeat'    => esc_html__( 'Repeat', 'consulting-elementor-widgets' ),
					'repeat-x'  => esc_html__( 'Repeat-x', 'consulting-elementor-widgets' ),
					'repeat-y'  => esc_html__( 'Repeat-y', 'consulting-elementor-widgets' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial-inner' => 'background-repeat: {{VALUE}};',
				),
				'condition' => array(
					'style'          => array( 'full_image' ),
					'disable_image!' => 'yes',
				),
			)
		);

		$this->add_control(
			'background_size',
			array(
				'label'     => __( 'Background Size', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					''        => esc_html__( 'Default', 'consulting-elementor-widgets' ),
					'auto'    => esc_html__( 'Auto', 'consulting-elementor-widgets' ),
					'cover'   => esc_html__( 'Cover', 'consulting-elementor-widgets' ),
					'contain' => esc_html__( 'Contain', 'consulting-elementor-widgets' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial-inner' => 'background-size: {{VALUE}};',
				),
				'condition' => array(
					'style'          => array( 'full_image' ),
					'disable_image!' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'image_width',
			array(
				'label'      => __( 'Image Container Width', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__image' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'style'          => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'disable_image!' => 'yes',
				),
			)
		);

		$this->add_control(
			'image_size',
			array(
				'label'       => __( 'Image Size', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => __( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use default size.', 'consulting-elementor-widgets' ),
				'default'     => 'full',
				'condition'   => array(
					'style'          => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'disable_image!' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'image_border_radius',
			array(
				'label'      => __( 'Image Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'style'          => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'disable_image!' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'image_margin',
			array(
				'label'      => __( 'Image Margin', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial__image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'style'          => array( 'side_image', 'side_image_2', 'top_image', 'info_above' ),
					'disable_image!' => 'yes',
				),
			)
		);

		$this->add_control(
			'image_shape',
			array(
				'label'     => __( 'Image Shape', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'circle'         => __( 'Circle', 'consulting-elementor-widgets' ),
					'rounded_square' => __( 'Rounded Square', 'consulting-elementor-widgets' ),
				),
				'default'   => 'rounded_square',
				'condition' => array(
					'style'          => array( 'info_above' ),
					'disable_image!' => 'yes',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'box_section',
			array(
				'label' => __( 'Box', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'box_style',
			array(
				'label'        => __( 'Add Box Style', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style' => array( 'side_image', 'top_image', 'info_above' ),
				),
			)
		);

		$this->add_control(
			'box_position',
			array(
				'label'     => __( 'Box Position', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'left'   => esc_html__( 'Left', 'consulting-elementor-widgets' ),
					'right'  => esc_html__( 'Right', 'consulting-elementor-widgets' ),
					'center' => esc_html__( 'Center', 'consulting-elementor-widgets' ),
				),
				'condition' => array(
					'style' => array( 'full_image' ),
				),
			)
		);

		$this->add_responsive_control(
			'box_height',
			array(
				'label'      => __( 'Box Height', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 1000,
						'step' => 10,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__info' => 'height: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'size' => 368,
					'unit' => 'px',
				),
				'condition'  => array(
					'style' => array( 'full_image' ),
				),
			)
		);

		$this->add_responsive_control(
			'box_width',
			array(
				'label'      => __( 'Box Width', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 1000,
						'step' => 10,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__info' => 'max-width: {{SIZE}}{{UNIT}};',
				),
				'default'    => array(
					'size' => 540,
					'unit' => 'px',
				),
				'condition'  => array(
					'style' => array( 'full_image' ),
				),
			)
		);

		$this->add_control(
			'box_bg_color',
			array(
				'label'     => __( 'Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'box_style' => 'yes',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'      => 'box_border',
				'selector'  => '{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial-inner',
				'condition' => array(
					'box_style' => 'yes',
				),
			)
		);

		$this->add_control(
			'box_border_radius',
			array(
				'label'      => esc_html__( 'Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel:not(.full_image) .consulting-testimonial-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'box_style' => 'yes',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'label'     => esc_html__( 'Box Shadow', 'consulting-elementor-widgets' ),
				'name'      => 'box_shadow',
				'selector'  => '{{WRAPPER}} .consulting-testimonials-carousel:not(.full_image) .consulting-testimonial-inner, {{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__info',
				'condition' => array(
					'style'     => array( 'side_image', 'side_image_2', 'top_image', 'full_image' ),
					'box_style' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'box_outer_padding',
			array(
				'label'      => __( 'Box Outer Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel:not(.full_image) .consulting-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'box_style' => 'yes',
				),
				'separator'  => 'before',
			)
		);

		$this->add_responsive_control(
			'box_inner_padding',
			array(
				'label'      => __( 'Box Inner Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel:not(.full_image) .consulting-testimonial-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel.full_image .consulting-testimonial__info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'box_style' => 'yes',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'quote_section',
			array(
				'label' => __( 'Quote', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'show_quote',
			array(
				'label'        => __( 'Show Quote', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'quote_size',
			array(
				'label'      => __( 'Quote Size', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial i.testimonial-quote' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial i.testimonial-quote-bullet' => 'font-size: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'style'      => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
					'show_quote' => 'yes',
				),
			)
		);

		$this->add_control(
			'quote_color',
			array(
				'label'     => __( 'Quote Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial i.testimonial-quote' => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel .consulting-testimonial i.testimonial-quote-bullet' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style'      => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
					'show_quote' => 'yes',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'navigation_section',
			array(
				'label'          => __( 'Navigation', 'consulting-elementor-widgets' ),
				'tab'            => Controls_Manager::TAB_STYLE,
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'relation' => 'and',
							'terms'    => array(
								array(
									'name'     => 'style',
									'operator' => '!==',
									'value'    => 'full_image',
								),
								array(
									'name'     => 'show_navigation',
									'operator' => '===',
									'value'    => 'yes',
								),
							),
						),
						array(
							'relation' => 'and',
							'terms'    => array(
								array(
									'name'     => 'style',
									'operator' => '===',
									'value'    => 'full_image',
								),
								array(
									'name'     => 'navigation_type',
									'operator' => '===',
									'value'    => 'arrows',
								),
							),
						),
					),
				),
			)
		);

		$this->add_control(
			'navigation_arrow_color',
			array(
				'label'     => __( 'Arrows Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-prev i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-next i' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'navigation_arrow_color_hover',
			array(
				'label'     => __( 'Arrows Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-prev:hover i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-next:hover i' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'navigation_bg_color',
			array(
				'label'     => __( 'Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-prev' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-next' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'navigation_bg_color_hover',
			array(
				'label'     => __( 'Background Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-prev:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-next:hover' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'navigation_border_color',
			array(
				'label'     => __( 'Border Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-prev' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-next' => 'border-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'navigation_border_color_hover',
			array(
				'label'     => __( 'Border Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-prev:hover' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-next:hover' => 'border-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'pagination_section',
			array(
				'label'      => __( 'Pagination', 'consulting-elementor-widgets' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'relation' => 'and',
							'terms'    => array(
								array(
									'name'     => 'style',
									'operator' => '!==',
									'value'    => 'full_image',
								),
								array(
									'name'     => 'show_pagination',
									'operator' => '===',
									'value'    => 'yes',
								),
							),
						),
						array(
							'relation' => 'and',
							'terms'    => array(
								array(
									'name'     => 'style',
									'operator' => '===',
									'value'    => 'full_image',
								),
								array(
									'name'     => 'navigation_type',
									'operator' => '===',
									'value'    => 'bullets',
								),
							),
						),
					),
				),
			)
		);

		$this->add_control(
			'pagination_color',
			array(
				'label'     => __( 'Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-dots li button' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->add_control(
			'pagination_color_active',
			array(
				'label'     => __( 'Active Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials-carousel .slick-dots li.slick-active button' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'side_image', 'side_image_2', 'top_image', 'info_above', 'full_image' ),
				),
			)
		);

		$this->end_controls_section();

		$this->add_dimensions( '.consulting_elementor_testimonials_carousel' );
	}

	protected function render() {
		if ( function_exists( 'consulting_show_template' ) ) {
			$settings = $this->get_settings_for_display();

			$settings['disable_carousel'] = '';

			if ( ! empty( $settings['link']['url'] ) ) {
				$settings['link'] = Consulting_Elementor_Widgets::build_link( $settings );
			}

			if ( str_contains( $settings['style'], 'style' ) ) {

				$settings['css_class'] = ' consulting_elementor_testimonials_carousel testimonials_carousel';

				if ( function_exists( 'consulting_show_template' ) ) {
					consulting_load_vc_element( 'testimonials_carousel', $settings, $settings['style'] );
				}
			} else {

				$settings['css_class'] = ' consulting_elementor_testimonials_carousel consulting-testimonials-carousel';

				stm_load_variations_template( $settings, '/testimonials-carousel/styles/' . sanitize_file_name( $settings['style'] ) );

			}
		}
	}
}
