<?php
/**
 * @var $settings
 * @var $count
 * @var $per_row
 * @var $css_class
 * @var $style
 * @var $category
 * @var $show_quote
 * @var $image_size
 * @var $excerpt_length
 * @var $show_quote
 * @var $image_shape
 * @var $box_type
 */

extract( $settings );

$args = array(
	'post_type'      => 'stm_testimonials',
	'posts_per_page' => $count_2,
);

if ( $per_row_2 ) {
	$css_class .= ' cols-' . $per_row_2;
}

if ( $style ) {
	$css_class .= ' ' . $style;
}

if ( ! empty( $show_quote ) && ! empty( $settings['testimonial_icon_1']['value'] ) ) {
	$css_class .= ' show-quote';
}

$css_class .= 'yes' === $show_image ? ' show-image-yes' : ' show-image-no';

if ( 'all' !== $category ) {
	$args['stm_testimonials_category'] = $category;
}

$excerpt_length = ( ! empty( $excerpt_length ) ) ? intval( $excerpt_length ) : 0;

$testimonials = new WP_Query( $args );

if ( $testimonials->have_posts() ) {
	?>
	<div class="<?php echo esc_attr( $css_class ); ?>">
		<?php
		while ( $testimonials->have_posts() ) {
			$testimonials->the_post();
			$testimonial_id = get_the_ID();
			?>
			<div class="consulting-testimonial">
				<div class="consulting-testimonial-inner">
					<?php
					if ( ! empty( $show_quote ) && ! empty( $settings['testimonial_icon_1']['value'] ) ) {
						?>
						<div class="consulting-testimonial-icon">
							<?php
							\Elementor\Icons_Manager::render_icon(
								$settings['testimonial_icon_1'],
								array(
									'aria-hidden' => 'true',
								)
							);
							?>
						</div>
						<?php
					}
					?>
					<div class="consulting-testimonial-content-wrapper">
						<div class="consulting-testimonial-excerpt">
								<?php
								echo wp_kses_post( get_consulting_excerpt( get_the_excerpt(), $excerpt_length ) );
								?>
						</div>
					</div>
					<div class="consulting-testimonial-info">
						<div class="consulting-testimonial-group">
							<div class="consulting-testimonial-heading"><?php the_title(); ?></div>
							<div class="consulting-testimonial-position">
								<?php
								$position = get_post_meta( $testimonial_id, 'testimonial_position', true );
								echo esc_html( get_post_meta( $testimonial_id, 'testimonial_company', true ) );
								?>
							</div>
						</div>
					</div>
					<?php
					if ( has_post_thumbnail() && 'yes' === $show_image ) {
						$author_photo = consulting_get_image( get_post_thumbnail_id(), 'full' );
						?>
						<div class="consulting-testimonial-image">
							<?php echo wp_kses_post( consulting_filtered_output( $author_photo ) ); ?>
						</div>
					<?php } ?>
				</div>
			</div>
		<?php } ?>
	</div>
	<?php
}
wp_reset_postdata();
