<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;

class Elementor_STM_Testimonials extends \Elementor\Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );

		wp_register_style( 'consulting-testimonials-general', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials/general.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-info-above', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials/info_above.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-info-above-2', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials/info_above_2.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-side-image', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials/side_image.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
		wp_register_style( 'consulting-testimonials-boxed', CONSULTING_ELEMENTOR_URL . 'assets/css/widgets/testimonials/boxed.css', array(), CONSULTING_ELEMENTOR_VERSION, false );
	}

	public function get_name() {
		return 'stm_testimonials';
	}

	public function get_title() {
		return esc_html__( 'Testimonials', 'consulting-elementor-widgets' );
	}

	public function get_icon() {
		return 'consulting-eicon-testimonial';
	}

	public function get_categories() {
		return array( 'consulting-widgets' );
	}

	public function get_script_depends() {
		return array( 'owl.carousel' );
	}

	public function get_style_depends() {
		return array(
			'owl.carousel',
			'consulting-testimonials-general',
			'consulting-testimonials-info-above',
			'consulting-testimonials-info-above-2',
			'consulting-testimonials-side-image',
			'consulting-testimonials-boxed',
		);
	}

	public function add_dimensions( $selector = '' ) {
		$this->start_controls_section(
			'section_dimensions',
			array(
				'label' => __( 'Dimensions', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_responsive_control(
			'margin',
			array(
				'label'      => __( 'Margin', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function register_controls() {

		$testimonial_categories_array = get_terms( 'stm_testimonials_category' );
		$testimonial_categories       = array(
			'all' => esc_html__( 'All', 'consulting-elementor-widgets' ),
		);
		if ( $testimonial_categories_array && ! is_wp_error( $testimonial_categories_array ) ) {
			foreach ( $testimonial_categories_array as $cat ) {
				$testimonial_categories[ $cat->slug ] = $cat->name;
			}
		}

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'style',
			array(
				'label'   => __( 'Style', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'style_1',
				'options' => array(
					'info_above'   => esc_html__( 'Info Above', 'consulting-elementor-widgets' ),
					'info_above_2' => esc_html__( 'Info Above 2', 'consulting-elementor-widgets' ),
					'side_image'   => esc_html__( 'Side Image', 'consulting-elementor-widgets' ),
					'boxed'        => esc_html__( 'Boxed', 'consulting-elementor-widgets' ),
					'style_1'      => esc_html__( 'Style 1', 'consulting-elementor-widgets' ),
					'style_2'      => esc_html__( 'Style 2', 'consulting-elementor-widgets' ),
					'style_3'      => esc_html__( 'Style 3', 'consulting-elementor-widgets' ),
					'style_4'      => esc_html__( 'Style 4', 'consulting-elementor-widgets' ),
					'style_5'      => esc_html__( 'Style 5', 'consulting-elementor-widgets' ),
					'style_6'      => esc_html__( 'Style 6', 'consulting-elementor-widgets' ),
					'style_7'      => esc_html__( 'Style 7', 'consulting-elementor-widgets' ),
				),
			)
		);

		$this->add_control(
			'count',
			array(
				'label'     => __( 'Count', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 2,
				'condition' => array(
					'style!' => array( 'info_above_2', 'boxed' ),
				),
			)
		);

		$this->add_control(
			'count_2',
			array(
				'label'     => __( 'Count', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 3,
				'condition' => array(
					'style' => array( 'info_above_2', 'boxed' ),
				),
			)
		);

		$this->add_control(
			'per_row',
			array(
				'label'     => __( 'Per Row', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
				),
				'default'   => 2,
				'condition' => array(
					'style' => array( 'info_above', 'side_image', 'style_1', 'style_2' ),
				),
			)
		);

		$this->add_control(
			'per_row_2',
			array(
				'label'     => __( 'Per Row', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
				),
				'default'   => 3,
				'condition' => array(
					'style' => array( 'info_above_2', 'boxed' ),
				),
			)
		);

		$this->add_control(
			'category',
			array(
				'label'   => __( 'Category', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT2,
				'options' => $testimonial_categories,
				'default' => 'all',
			)
		);

		$this->add_control(
			'excerpt_length',
			array(
				'label'       => __( 'Excerpt length', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'e.g. 160', 'consulting-elementor-widgets' ),
				'description' => __( 'Trims text to a certain number of symbols.', 'consulting-elementor-widgets' ),
				'default'     => 160,
			)
		);

		$this->add_control(
			'show_image',
			array(
				'label'        => __( 'Show Image', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$this->add_control(
			'show_quote',
			array(
				'label'        => __( 'Show Quote', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$this->add_control(
			'navigation_type',
			array(
				'label'     => __( 'Navigation', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'arrows',
				'options'   => array_flip(
					array(
						esc_html__( 'Arrows', 'consulting-elementor-widgets' ) => 'arrows',
						esc_html__( 'Bullets', 'consulting-elementor-widgets' ) => 'bullets',
					)
				),
				'condition' => array(
					'style' => array( 'style_3', 'style_4', 'style_5' ),
				),
			)
		);

		$this->add_control(
			'autoplay',
			array(
				'label'        => __( 'Slider Autoplay', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'description'  => esc_html__( 'Enable autoplay mode.', 'consulting-elementor-widgets' ),
				'condition'    => array(
					'style!' => array( 'info_above', 'info_above_2', 'side_image', 'boxed' ),
				),
			)
		);

		$this->add_control(
			'timeout',
			array(
				'label'       => __( 'Autoplay Timeout', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 5000,
				'description' => esc_html__( 'Autoplay interval timeout (in ms).', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'autoplay' => 'yes',
					'style!'   => array( 'info_above', 'info_above_2', 'side_image', 'boxed' ),
				),
			)
		);

		$this->add_control(
			'loop',
			array(
				'label'        => __( 'Slider Loop', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'description'  => esc_html__( 'Enable slider loop mode.', 'consulting-elementor-widgets' ),
				'condition'    => array(
					'style' => array( 'style_3', 'style_4', 'style_5' ),
				),
			)
		);

		$this->add_control(
			'navigation',
			array(
				'label'        => __( 'Slider Navigation', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'hide',
				'description'  => esc_html__( 'Disable navigation.', 'consulting-elementor-widgets' ),
				'condition'    => array(
					'style' => array( 'style_3', 'style_4', 'style_5' ),
				),
			)
		);

		$this->add_control(
			'disable_container',
			array(
				'label'        => __( 'Remove default block size', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'description'  => esc_html__( 'If you enable this option, the block size will be gone. And you can place widget in one small column.', 'consulting-elementor-widgets' ),
				'condition'    => array(
					'style!' => array( 'info_above', 'info_above_2', 'side_image', 'boxed' ),
				),
			)
		);

		$this->add_control(
			'smart_speed',
			array(
				'label'     => __( 'Smart Speed', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 250,
				'condition' => array(
					'style' => array( 'style_3', 'style_4', 'style_5' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text_section',
			array(
				'label' => __( 'Text', 'consulting-elementor-widgets' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'name_color',
			array(
				'label'     => __( 'Name Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial-heading' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'name_color_hover',
			array(
				'label'     => __( 'Name Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial:hover .consulting-testimonial-heading' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'name_typography',
				'label'    => __( 'Name Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-testimonials .consulting-testimonial-heading',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_responsive_control(
			'name_margin',
			array(
				'label'      => __( 'Name Margin', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'company_color',
			array(
				'label'     => __( 'Company Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'separator' => 'before',
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial-position' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'company_color_hover',
			array(
				'label'     => __( 'Company Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial:hover .consulting-testimonial-position' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'company_typography',
				'label'    => __( 'Company Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-testimonials .consulting-testimonial-position',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_responsive_control(
			'company_margin',
			array(
				'label'      => __( 'Company Margin', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial-position' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'excerpt_color',
			array(
				'label'     => __( 'Excerpt Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'separator' => 'before',
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial-excerpt' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'excerpt_color_hover',
			array(
				'label'     => __( 'Excerpt Hover Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial:hover .consulting-testimonial-excerpt' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'excerpt_typography',
				'label'    => __( 'Excerpt Typography', 'consulting-elementor-widgets' ),
				'selector' => '{{WRAPPER}} .consulting-testimonials .consulting-testimonial-excerpt',
				'global'   => array(
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				),
			)
		);

		$this->add_responsive_control(
			'excerpt_margin',
			array(
				'label'      => __( 'Excerpt Margin', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'box_section',
			array(
				'label'     => __( 'Box', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'style' => array( 'info_above', 'info_above_2', 'side_image', 'boxed' ),
				),
			)
		);

		$this->add_control(
			'box_bg_color',
			array(
				'label'     => __( 'Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials.info_above .consulting-testimonial-content-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial-inner' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials.side_image .consulting-testimonial-info' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials.boxed .consulting-testimonial-inner' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'     => 'box_border',
				'selector' => '{{WRAPPER}} .consulting-testimonials.info_above .consulting-testimonial-content-wrapper, {{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial-inner, {{WRAPPER}} .consulting-testimonials.side_image .consulting-testimonial-inner, {{WRAPPER}} .consulting-testimonials.boxed .consulting-testimonial-inner',
			)
		);

		$this->add_control(
			'box_border_radius',
			array(
				'label'      => esc_html__( 'Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials.info_above .consulting-testimonial-content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.side_image .consulting-testimonial-info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.boxed .consulting-testimonial-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'label'    => esc_html__( 'Box Shadow', 'consulting-elementor-widgets' ),
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .consulting-testimonials.info_above .consulting-testimonial-content-wrapper, {{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial-inner, {{WRAPPER}} .consulting-testimonials.side_image .consulting-testimonial-info, {{WRAPPER}} .consulting-testimonials.boxed .consulting-testimonial-inner',
			)
		);

		$this->add_responsive_control(
			'box_outer_padding',
			array(
				'label'      => __( 'Box Outer Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials.info_above .consulting-testimonial-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.side_image .consulting-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.boxed .consulting-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'separator'  => 'before',
			)
		);

		$this->add_responsive_control(
			'box_inner_padding',
			array(
				'label'      => __( 'Box Inner Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials.info_above .consulting-testimonial-content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.side_image .consulting-testimonial-group' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.boxed .consulting-testimonial-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'image_section',
			array(
				'label'     => __( 'Image', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_image' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'image_border_radius',
			array(
				'label'      => __( 'Image Border Radius', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'image_vertical_position',
			array(
				'label'      => __( 'Vertical Position', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => -100,
						'max' => 100,
					),
					'rem' => array(
						'min' => -100,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial .consulting-testimonial-inner .consulting-testimonial-image'   => 'bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.side_image .consulting-testimonial .consulting-testimonial-inner .consulting-testimonial-info .consulting-testimonial-image'   => 'top: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'style' => array( 'info_above_2', 'side_image' ),
				),
			)
		);

		$this->add_control(
			'image_horizontal_position',
			array(
				'label'      => __( 'Horizontal Position', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => -100,
						'max' => 100,
					),
					'rem' => array(
						'min' => -100,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial .consulting-testimonial-info .consulting-testimonial-image'   => 'left: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'style' => array( 'side_image' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_icon_section',
			array(
				'label'     => __( 'Quote', 'consulting-elementor-widgets' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_quote' => 'yes',
				),
			)
		);

		$this->add_control(
			'testimonial_icon_1',
			array(
				'label'       => esc_html__( 'Icon', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'default'     => array(
					'value'   => 'fas fa-quote-left',
					'library' => 'fa-solid',
				),
				'label_block' => false,
				'separator'   => 'before',
				'condition'   => array(
					'style' => array( 'info_above', 'info_above_2' ),
				),
			)
		);

		$this->add_control(
			'testimonial_icon_2',
			array(
				'label'       => esc_html__( 'Icon', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'default'     => array(
					'value'   => 'fas fa-quote-right',
					'library' => 'fa-solid',
				),
				'label_block' => false,
				'separator'   => 'before',
				'condition'   => array(
					'style' => array( 'side_image', 'boxed' ),
				),
			)
		);

		$this->add_control(
			'testimonial_icon_size',
			array(
				'label'      => __( 'Size', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => 0,
						'max' => 100,
					),
					'rem' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial .consulting-testimonial-icon i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial .consulting-testimonial-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'testimonial_icon_padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial-inner .consulting-testimonial-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'style' => array( 'info_above_2' ),
				),
			)
		);

		$this->add_control(
			'testimonial_icon_color',
			array(
				'label'     => __( 'Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial .consulting-testimonial-icon i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .consulting-testimonials .consulting-testimonial .consulting-testimonial-icon svg' => 'fill: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'testimonial_icon_bg_color',
			array(
				'label'     => __( 'Background Color', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial .consulting-testimonial-icon'   => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'info_above_2' ),
				),
			)
		);

		$this->add_control(
			'testimonial_icon_vertical_position',
			array(
				'label'      => __( 'Vertical Position', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem', 'custom' ),
				'range'      => array(
					'px'  => array(
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					),
					'em'  => array(
						'min' => -100,
						'max' => 100,
					),
					'rem' => array(
						'min' => -100,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials.info_above_2 .consulting-testimonial .consulting-testimonial-icon'   => 'top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .consulting-testimonials.boxed .consulting-testimonial .consulting-testimonial-icon'   => 'bottom: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'style' => array( 'info_above_2', 'boxed' ),
				),
			)
		);

		$this->add_responsive_control(
			'testimonial_icon_margin',
			array(
				'label'      => __( 'Margin', 'consulting-elementor-widgets' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em', 'rem', 'custom' ),
				'selectors'  => array(
					'{{WRAPPER}} .consulting-testimonials.side_image .consulting-testimonial-group' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'style' => array( 'side_image' ),
				),
			)
		);

		$this->end_controls_section();

		$this->add_dimensions( '.consulting_elementor_testimonials' );
	}

	protected function render() {
		if ( function_exists( 'consulting_show_template' ) ) {
			$settings = $this->get_settings_for_display();

			if ( str_contains( $settings['style'], 'style' ) ) {

				$settings['css_class'] = ' consulting_elementor_testimonials';

				if ( function_exists( 'consulting_show_template' ) ) {
					consulting_show_template( 'testimonials', $settings );
				}
			} else {

				$settings['css_class'] = ' consulting_elementor_testimonials consulting-testimonials';
				stm_load_variations_template( $settings, '/testimonials/styles/' . sanitize_file_name( $settings['style'] ) );

			}
		}
	}
}
