<?php

use Elementor\Controls_Manager;

class Elementor_STM_Works extends \Elementor\Widget_Base {

	public function get_name() {
		return 'stm_works';
	}

	public function get_title() {
		return esc_html__( 'Works', 'consulting-elementor-widgets' );
	}

	public function get_icon() {
		return 'consulting-eicon-briefcase';
	}

	public function get_categories() {
		return array( 'consulting-widgets' );
	}

	public function get_script_depends() {
		return array( 'imagesloaded', 'isotope', 'owl.carousel' );
	}

	public function get_style_depends() {
		return array( 'owl.carousel' );
	}

	public function add_dimensions( $selector = '' ) {
		$this->start_controls_section(
			'section_dimensions',
			array(
				'label' => __( 'Dimensions', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_responsive_control(
			'margin',
			array(
				'label'      => __( 'Margin', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'padding',
			array(
				'label'      => __( 'Padding', 'consulting-elementor-widgets' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					"{{WRAPPER}} {$selector}" => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function register_controls() {
		$works_categories     = get_terms( 'stm_works_category' );
		$works_categories_arr = array();

		if ( ! empty( $works_categories ) && ! is_wp_error( $works_categories ) ) {
			foreach ( $works_categories as $works_category ) {
				$works_categories_arr[ $works_category->slug ] = $works_category->name;
			}
		}

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'consulting-elementor-widgets' ),
			)
		);

		$this->add_control(
			'style',
			array(
				'label'   => __( 'Style', 'consulting-elementor-widgets' ),
				'type'    => \Elementor\Controls_Manager::SELECT2,
				'default' => 'grid',
				'options' => array_flip(
					array(
						esc_html__( 'Grid', 'consulting-elementor-widgets' ) => 'grid',
						esc_html__( 'Grid with filter', 'consulting-elementor-widgets' ) => 'grid_with_filter',
						esc_html__( 'Grid with carousel', 'consulting-elementor-widgets' ) => 'grid_with_carousel',
						esc_html__( 'Masonry', 'consulting-elementor-widgets' ) => 'masonry',
						esc_html__( 'Tiles', 'consulting-elementor-widgets' ) => 'tiles',
					)
				),
			)
		);

		$this->add_control(
			'grid_style',
			array(
				'label'     => __( 'View Style', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT2,
				'default'   => 'style_1',
				'options'   => array_flip(
					array(
						esc_html__( 'Style 1', 'consulting-elementor-widgets' ) => 'style_1',
						esc_html__( 'Style 2', 'consulting-elementor-widgets' ) => 'style_2',
						esc_html__( 'Style 3', 'consulting-elementor-widgets' ) => 'style_3',
					)
				),
				'condition' => array(
					'style' => 'grid',
				),
			)
		);

		$this->add_control(
			'grid_with_filter_style',
			array(
				'label'     => __( 'View Style', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT2,
				'default'   => 'style_1',
				'options'   => array_flip(
					array(
						esc_html__( 'Style 1', 'consulting-elementor-widgets' ) => 'style_1',
						esc_html__( 'Style 2', 'consulting-elementor-widgets' ) => 'style_2',
					)
				),
				'condition' => array(
					'style' => 'grid_with_filter',
				),
			)
		);

		$this->add_control(
			'tiles_style',
			array(
				'label'     => __( 'View Style', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT2,
				'default'   => 'style_1',
				'options'   => array_flip(
					array(
						esc_html__( 'Style 1', 'consulting-elementor-widgets' ) => 'style_1',
						esc_html__( 'Style 2', 'consulting-elementor-widgets' ) => 'style_2',
					)
				),
				'condition' => array(
					'style' => 'tiles',
				),
			)
		);

		$this->add_control(
			'works_categories',
			array(
				'label'       => __( 'Include Category', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'multiple'    => true,
				'description' => __( 'Add Category. If not added show all category', 'consulting-elementor-widgets' ),
				'options'     => $works_categories_arr,
				'condition'   => array(
					'style' => 'grid_with_filter',
				),
			)
		);

		$this->add_control(
			'works_count',
			array(
				'label'       => __( 'Count', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'The number of items you want to see on the screen.', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style' => array( 'grid', 'masonry', 'tiles' ),
				),
				'default' => 5,
			)
		);

		$this->add_control(
			'works_count_visible',
			array(
				'label'       => __( 'Count', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'The number of items you want to see on the screen.', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style' => array( 'grid_with_filter' ),
				),
			)
		);

		$this->add_control(
			'items',
			array(
				'label'       => __( 'Items', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'The number of items you want to see on the screen.', 'consulting-elementor-widgets' ),
				'default'     => 4,
				'condition'   => array(
					'style' => array( 'grid_with_carousel' ),
				),
			)
		);

		$this->add_control(
			'items_small_desktop',
			array(
				'label'       => __( 'Items (Small Desktop)', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 4,
				'description' => esc_html__( 'Number of items the carousel will display. Default: at <980px - 4 items.', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style' => array( 'grid_with_carousel' ),
				),
			)
		);

		$this->add_control(
			'items_tablet',
			array(
				'label'       => __( 'Items (Tablet)', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 3,
				'description' => esc_html__( 'Number of items the carousel will display. Default: at <768px - 3 items.', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style' => array( 'grid_with_carousel' ),
				),
			)
		);

		$this->add_control(
			'items_land',
			array(
				'label'       => __( 'Items (Tablet)', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 2,
				'description' => esc_html__( 'Number of items the carousel will display. Default: at <480px - 2 items.', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style' => array( 'grid_with_carousel' ),
				),
			)
		);

		$this->add_control(
			'items_mobile',
			array(
				'label'       => __( 'Items (Mobile)', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 1,
				'description' => esc_html__( 'Number of items the carousel will display. Default: at <479px - 1 item.', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style' => array( 'grid_with_carousel' ),
				),
			)
		);

		$this->add_control(
			'loop',
			array(
				'label'        => __( 'Slider Loop', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'description'  => esc_html__( 'Enable slider loop mode.', 'consulting-elementor-widgets' ),
				'condition'    => array(
					'style' => 'grid_with_carousel',
				),
			)
		);

		$this->add_control(
			'autoplay',
			array(
				'label'        => __( 'Carousel Autoplay', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'description'  => esc_html__( 'Enable autoplay mode.', 'consulting-elementor-widgets' ),
				'condition'    => array(
					'style' => 'grid_with_carousel',
				),
			)
		);

		$this->add_control(
			'timeout',
			array(
				'label'       => __( 'Autoplay Timeout', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 5000,
				'description' => esc_html__( 'Autoplay interval timeout (in ms).', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'autoplay' => 'yes',
				),
			)
		);

		$this->add_control(
			'dots',
			array(
				'label'        => __( 'Slider dots', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style' => 'grid_with_carousel',
				),
			)
		);

		$this->add_control(
			'nav',
			array(
				'label'        => __( 'Slider arrows', 'consulting-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'condition'    => array(
					'style' => 'grid_with_carousel',
				),
			)
		);

		$this->add_control(
			'smart_speed',
			array(
				'label'     => __( 'Smart Speed', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 250,
				'condition' => array(
					'style' => 'grid_with_carousel',
				),
			)
		);

		$this->add_control(
			'cols',
			array(
				'label'     => __( 'Cols', 'consulting-elementor-widgets' ),
				'type'      => \Elementor\Controls_Manager::SELECT2,
				'options'   => array(
					4 => 4,
					3 => 3,
					2 => 2,
					1 => 1,
				),
				'condition' => array(
					'style' => array( 'grid', 'grid_with_filter' ),
				),
				'default' => 3,
			)
		);

		$this->add_control(
			'img_size',
			array(
				'label'       => __( 'Image size', 'consulting-elementor-widgets' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use default size.', 'consulting-elementor-widgets' ),
				'condition'   => array(
					'style' => array( 'grid', 'grid_with_filter' ),
				),
				'default' => 'full',
			)
		);

		$this->end_controls_section();

		$this->add_dimensions( '.consulting_elementor_works' );
	}

	protected function render() {
		if ( function_exists( 'consulting_show_template' ) ) {
			$settings = $this->get_settings_for_display();

			$settings['css_class'] = ' consulting_elementor_works';

			if ( isset( $settings['style'] ) ) {
				$substyle = ( isset( $settings[ $settings['style'] . '_style' ] ) ) ? $settings[ $settings['style'] . '_style' ] : 'style_1';
				consulting_load_vc_element( 'works/' . $settings['style'], $settings, $substyle );
			}
		}
	}
}
