<?php
/**
 * Plugin list of WPMU DEV for the cross-sell sub-module. Includes Free and Pro plugins.
 *
 * @link    https://wpmudev.com/
 * @since   1.0.0
 *
 * @author  WPMUDEV (https://wpmudev.com)
 * @package WPMUDEV\Plugin_Cross_Sell
 *
 * @copyright (c) 2025, WPMU DEV (http://wpmudev.com)
 */

return array(
	'free-plugins' => array(
		array(
			'slug'            => 'wp-smushit',
			'path'            => 'wp-smushit/wp-smush.php',
			'url'             => 'https://wordpress.org/plugins/wp-smushit/',
			'utm_source'      => 'smush',
			'utm_campaign'    => 'cross-sell_plugin_smush',
			'admin_url_page'  => 'smush',
			'logo'            => 'wp-smushit.png',
			'title'           => __( 'Smush', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Smush images down to size for faster page loading.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '1M +',
		),
		array(
			'slug'            => 'forminator',
			'path'            => 'forminator/forminator.php',
			'url'             => 'https://wordpress.org/plugins/forminator/',
			'utm_source'      => 'forminator',
			'utm_campaign'    => 'cross-sell_plugin_forminator',
			'admin_url_page'  => 'forminator',
			'logo'            => 'forminator.png',
			'title'           => __( 'Forminator', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Surveys, subscriptions, feedback, quizzes: Forminator makes it easy.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.5,
			'active_installs' => '500k +',
		),
		array(
			'slug'            => 'defender-security',
			'path'            => 'defender-security/wp-defender.php',
			'url'             => 'https://wordpress.org/plugins/defender-security/',
			'utm_source'      => 'defender',
			'utm_campaign'    => 'cross-sell_plugin_defender',
			'admin_url_page'  => 'wp-defender',
			'logo'            => 'defender-security.png',
			'title'           => __( 'Defender', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Keep your site’s security on lockdown.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '90k +',
		),
		array(
			'slug'            => 'hummingbird-performance',
			'path'            => 'hummingbird-performance/wp-hummingbird.php',
			'url'             => 'https://wordpress.org/plugins/hummingbird-performance/',
			'utm_source'      => 'hummingbird',
			'utm_campaign'    => 'cross-sell_plugin_hummingbird',
			'admin_url_page'  => 'wphb',
			'logo'            => 'hummingbird-performance.png',
			'title'           => __( 'Hummingbird', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'For sites that load in one flap of a hummingbird’s wing. ', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.7,
			'active_installs' => '100k +',
		),
		array(
			'slug'            => 'smartcrawl-seo',
			'path'            => 'smartcrawl-seo/wpmu-dev-seo.php',
			'url'             => 'https://wordpress.org/plugins/smartcrawl-seo/',
			'utm_source'      => 'smartcrawl',
			'utm_campaign'    => 'cross-sell_plugin_smartcrawl',
			'admin_url_page'  => 'wds_wizard',
			'logo'            => 'smartcrawl-seo.png',
			'title'           => __( 'SmartCrawl', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Take the mystery out of optimizing your site.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '20k +',
		),
		array(
			'slug'            => 'wordpress-popup',
			'path'            => 'wordpress-popup/popover.php',
			'url'             => 'https://wordpress.org/plugins/wordpress-popup/',
			'utm_source'      => 'hustle',
			'utm_campaign'    => 'cross-sell_plugin_hustle',
			'admin_url_page'  => 'hustle',
			'logo'            => 'wordpress-popup.png',
			'title'           => __( 'Hustle', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Create high-converting and targeted marketing campaigns in minutes.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.6,
			'active_installs' => '100k +',
		),
		array(
			'slug'            => 'branda-white-labeling',
			'path'            => 'branda-white-labeling/ultimate-branding.php',
			'url'             => 'https://wordpress.org/plugins/branda-white-labeling/',
			'utm_source'      => 'branda',
			'utm_campaign'    => 'cross-sell_plugin_branda',
			'admin_url_page'  => 'branding',
			'logo'            => 'branda-white-labeling.png',
			'title'           => __( 'Branda', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Rebrand, customize, and white label WordPress without code.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.5,
			'active_installs' => '20k +',
		),
		array(
			'slug'            => 'beehive-analytics',
			'path'            => 'beehive-analytics/beehive-analytics.php',
			'url'             => 'https://wordpress.org/plugins/beehive-analytics/',
			'utm_source'      => 'beehive',
			'utm_campaign'    => 'cross-sell_plugin_beehive',
			'admin_url_page'  => 'beehive',
			'logo'            => 'beehive-analytics.png',
			'title'           => __( 'Beehive', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Customizable Google Analytics dashboards, statistics, and reports.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '30k +',
		),
		array(
			'slug'            => 'broken-link-checker',
			'path'            => 'broken-link-checker/broken-link-checker.php',
			'url'             => 'https://wordpress.org/plugins/broken-link-checker/',
			'utm_source'      => 'blc',
			'utm_campaign'    => 'cross-sell_plugin_blc',
			'admin_url_page'  => 'blc_dash',
			'logo'            => 'broken-link-checker.png',
			'title'           => __( 'Broken Link Checker', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Check posts, pages & content for broken links to improve SEO. ', 'plugin-cross-sell-textdomain' ),
			'features'        => array(),
			'installed'       => false,
			'active'          => false,
			'rating'          => 3.8,
			'active_installs' => '600k +',
		),
	),

	'pro-plugins'  => array(
		array(
			'slug'            => 'forminator-pro',
			'path'            => 'forminator-pro/forminator.php',
			'url'             => 'https://wpmudev.com/project/forminator-pro/',
			'utm_source'      => 'forminator',
			'utm_campaign'    => 'cross-sell_plugin_forminator',
			'admin_url_page'  => 'forminator',
			'logo'            => 'forminator.png',
			'title'           => __( 'Forminator Pro', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Surveys, subscriptions, feedback, quizzes: Forminator makes it easy.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(
				__( 'Generate and send PDF files', 'plugin-cross-sell-textdomain' ),
				__( 'Accept recurring payment', 'plugin-cross-sell-textdomain' ),
				__( 'Get form submitter’s geolocation', 'plugin-cross-sell-textdomain' ),
			),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.5,
			'active_installs' => '550k +',
		),
		array(
			'slug'            => 'smush-pro',
			'path'            => 'wp-smush-pro/wp-smush.php',
			'url'             => 'https://wpmudev.com/project/wp-smush-pro/',
			'utm_source'      => 'smush',
			'utm_campaign'    => 'cross-sell_plugin_smush',
			'admin_url_page'  => 'smush',
			'logo'            => 'wp-smushit.png',
			'title'           => __( 'Smush Pro', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Smush images down to size for faster page loading.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(
				__( 'Ultra Smush with 5X compression', 'plugin-cross-sell-textdomain' ),
				__( '123 point CDN + 50GB bandwidth', 'plugin-cross-sell-textdomain' ),
				__( 'Unlimited bulk and auto smushing', 'plugin-cross-sell-textdomain' ),
			),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '1M +',
		),
		array(
			'slug'            => 'defender-pro',
			'path'            => 'wp-defender/wp-defender.php',
			'url'             => 'https://wpmudev.com/project/wp-defender/',
			'utm_source'      => 'defender',
			'utm_campaign'    => 'cross-sell_plugin_defender',
			'admin_url_page'  => 'wp-defender',
			'logo'            => 'defender-security.png',
			'title'           => __( 'Defender Pro', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Keep your site’s security on lockdown.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(
				__( 'Scheduled malware scanning', 'plugin-cross-sell-textdomain' ),
				__( 'AntiBot Global Firewall', 'plugin-cross-sell-textdomain' ),
				__( 'Comprehensive audit logging', 'plugin-cross-sell-textdomain' ),
			),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '260k +',
		),
		array(
			'slug'            => 'hummingbird-pro',
			'path'            => 'wp-hummingbird/wp-hummingbird.php',
			'url'             => 'https://wpmudev.com/project/wp-hummingbird/',
			'utm_source'      => 'hummingbird',
			'utm_campaign'    => 'cross-sell_plugin_hummingbird',
			'admin_url_page'  => 'wphb',
			'logo'            => 'hummingbird-performance.png',
			'title'           => __( 'Hummingbird Pro', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'For sites that load in one flap of a hummingbird’s wing.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(
				__( 'Delay JavaScript execution', 'plugin-cross-sell-textdomain' ),
				__( 'Automated critical CSS generation', 'plugin-cross-sell-textdomain' ),
				__( 'Turbocharged asset optimization', 'plugin-cross-sell-textdomain' ),
			),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '185k +',
		),
		array(
			'slug'            => 'smartcrawl-pro',
			'path'            => 'wpmu-dev-seo/wpmu-dev-seo.php',
			'url'             => 'https://wpmudev.com/project/smartcrawl-wordpress-seo/',
			'utm_source'      => 'smartcrawl',
			'utm_campaign'    => 'cross-sell_plugin_smartcrawl',
			'admin_url_page'  => 'wds_wizard',
			'logo'            => 'smartcrawl-seo.png',
			'title'           => __( 'SmartCrawl Pro', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Take the mystery out of optimizing your site.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(
				__( 'Site crawler SEO scan & reports', 'plugin-cross-sell-textdomain' ),
				__( 'SEO health audit reports', 'plugin-cross-sell-textdomain' ),
				__( 'Automatic integrated linking', 'plugin-cross-sell-textdomain' ),
			),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '100k +',
		),
		array(
			'slug'            => 'snapshot-pro',
			'path'            => 'snapshot-backups/snapshot-backups.php',
			'url'             => 'https://wpmudev.com/project/snapshot/',
			'utm_source'      => 'snapshot',
			'utm_campaign'    => 'cross-sell_plugin_snapshot',
			'admin_url_page'  => 'snapshot',
			'logo'            => 'snapshot.png',
			'title'           => __( 'Snapshot Pro', 'plugin-cross-sell-textdomain' ),
			'description'     => __( 'Space-efficient backups that happen effortlessly while you sleep.', 'plugin-cross-sell-textdomain' ),
			'features'        => array(
				__( 'Our PRO-only backup plugin', 'plugin-cross-sell-textdomain' ),
				__( 'Comes with up to 50GB storage', 'plugin-cross-sell-textdomain' ),
				__( 'Store backups for 50 days', 'plugin-cross-sell-textdomain' ),
			),
			'installed'       => false,
			'active'          => false,
			'rating'          => 4.8,
			'active_installs' => '50k +',
		),
	),
);
