<?php
if ( ! function_exists( 'consulting_config' ) ) {
	function consulting_config() {
		$config            = array();
		$consulting_layout = get_option( 'consulting_layout' );

		$config['layout'] = ( ( ! empty( $consulting_layout ) ) ? $consulting_layout : 'layout_1' );
		$config['fonts']  = '';

		switch ( $config['layout'] ) {
			case 'layout_monaco':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.stm_contacts_widget.style_3,
					.stats_counter h3,
					a.allservices,
					.elementor-container .elementor-progress-text, 
					.elementor-container .elementor-tab-title a, 
					.elementor-container .consulting_heading_font, 
					.elementor-container .elementor-widget-wp-widget-nav_menu ul li, 
					.elementor-container .elementor-button-text, 
					.elementor-container .elementor-tab-title,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.icon_box.style_10 .icon_box_inner h4,
					.elementor-button .elementor-button-text,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body .vc_general.vc_btn3';

				$config['secondary_font_family']  = 'Open Sans';
				$config['secondary_font_classes'] = 'h1 em, .h1 em,
					h2 em, .h2 em,
					h3 em, .h3 em,
					h4 em, .h4 em,
					h5 em, .h5 em,
					h6 em, .h6 em,
					p,
					.stm_service__link';

				$config['base_color']      = '#182132';
				$config['secondary_color'] = '#5C616A';
				$config['third_color']     = '#D2182C';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '0, 142, 109',
					'alpha' => array( '0.9', '0.8' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '243, 100, 56',
					'alpha' => array( '0.5', '0.8' ),
				);

				break;
			case 'layout_houston':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.stm_contacts_widget.style_3,
					.stats_counter h3,
					a.allservices,
					.elementor-container .elementor-progress-text, 
					.elementor-container .elementor-tab-title a, 
					.elementor-container .consulting_heading_font, 
					.elementor-container .elementor-widget-wp-widget-nav_menu ul li, 
					.elementor-container .elementor-button-text, 
					.elementor-container .elementor-tab-title,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.icon_box.style_10 .icon_box_inner h4,
					.elementor-button .elementor-button-text,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body .vc_general.vc_btn3';

				$config['secondary_font_family']  = 'Open Sans';
				$config['secondary_font_classes'] = 'h1 em, .h1 em,
					h2 em, .h2 em,
					h3 em, .h3 em,
					h4 em, .h4 em,
					h5 em, .h5 em,
					h6 em, .h6 em,
					p,
					.stm_service__link';

				$config['base_color']      = '#101419';
				$config['secondary_color'] = '#40993e';
				$config['third_color']     = '#59D355';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '0, 142, 109',
					'alpha' => array( '0.9', '0.8' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '243, 100, 56',
					'alpha' => array( '0.5', '0.8' ),
				);

				break;
			case 'layout_kyiv':
				$config['primary_font_family']  = 'DM Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.stm_contacts_widget.style_3,
					.stats_counter h3,
					a.allservices,
					.elementor-container .elementor-progress-text, 
					.elementor-container .elementor-tab-title a, 
					.elementor-container .consulting_heading_font, 
					.elementor-container .elementor-widget-wp-widget-nav_menu ul li, 
					.elementor-container .elementor-button-text, 
					.elementor-container .elementor-tab-title,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.icon_box.style_10 .icon_box_inner h4,
					.elementor-button .elementor-button-text,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body .vc_general.vc_btn3';

				$config['secondary_font_family']  = 'Open Sans';
				$config['secondary_font_classes'] = 'h1 em, .h1 em,
					h2 em, .h2 em,
					h3 em, .h3 em,
					h4 em, .h4 em,
					h5 em, .h5 em,
					h6 em, .h6 em,
					p,
					.stm_service__link';

				$config['base_color']      = '#333333';
				$config['secondary_color'] = '#0555DA';
				$config['third_color']     = '#06163A';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '0, 142, 109',
					'alpha' => array( '0.9', '0.8' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '243, 100, 56',
					'alpha' => array( '0.5', '0.8' ),
				);

				break;
			case 'layout_valencia':
				$config['primary_font_family']  = 'Poppins';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.stm_contacts_widget.style_3,
					.stats_counter h3,
					a.allservices,
					.elementor-container .elementor-progress-text, 
					.elementor-container .elementor-tab-title a, 
					.elementor-container .consulting_heading_font, 
					.elementor-container .elementor-widget-wp-widget-nav_menu ul li, 
					.elementor-container .elementor-button-text, 
					.elementor-container .elementor-tab-title,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.icon_box.style_10 .icon_box_inner h4,
					.elementor-button .elementor-button-text,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body .vc_general.vc_btn3';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1 em, .h1 em,
					h2 em, .h2 em,
					h3 em, .h3 em,
					h4 em, .h4 em,
					h5 em, .h5 em,
					h6 em, .h6 em,
					p,
					.stm_service__link';

				$config['base_color']      = '#333333';
				$config['secondary_color'] = '#03274A';
				$config['third_color']     = '#F05836';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '0, 142, 109',
					'alpha' => array( '0.9', '0.8' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '243, 100, 56',
					'alpha' => array( '0.5', '0.8' ),
				);

				break;
			case 'layout_kuala_lumpur':
				$config['primary_font_family']  = 'Rubik';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.stm_contacts_widget.style_3,
					.stats_counter h3,
					a.allservices,
					.elementor-container .elementor-progress-text, 
					.elementor-container .elementor-tab-title a, 
					.elementor-container .consulting_heading_font, 
					.elementor-container .elementor-widget-wp-widget-nav_menu ul li, 
					.elementor-container .elementor-button-text, 
					.elementor-container .elementor-tab-title,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.icon_box.style_10 .icon_box_inner h4,
					.elementor-button .elementor-button-text,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body .vc_general.vc_btn3';

				$config['secondary_font_family']  = 'Open Sans';
				$config['secondary_font_classes'] = 'h1 em, .h1 em,
					h2 em, .h2 em,
					h3 em, .h3 em,
					h4 em, .h4 em,
					h5 em, .h5 em,
					h6 em, .h6 em,
					p,
					.stm_service__link';

				$config['base_color']      = '#333333';
				$config['secondary_color'] = '#008e6d';
				$config['third_color']     = '#f36438';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '0, 142, 109',
					'alpha' => array( '0.9', '0.8' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '243, 100, 56',
					'alpha' => array( '0.5', '0.8' ),
				);

				break;
			case 'layout_atlanta':
				$config['primary_font_family']  = 'Sen';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.stm_contacts_widget.style_3,
					.stats_counter h3,
					a.allservices,
					.elementor-container .elementor-progress-text, 
					.elementor-container .elementor-tab-title a, 
					.elementor-container .consulting_heading_font, 
					.elementor-container .elementor-widget-wp-widget-nav_menu ul li, 
					.elementor-container .elementor-tab-title,
					.elementor-button, .elementor-button-text, 
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.icon_box.style_10 .icon_box_inner h4,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body .vc_general.vc_btn3';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = '';

				$config['base_color']      = '#002e5b';
				$config['secondary_color'] = '#4a57fe';
				$config['third_color']     = '#ffd61f';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '55, 99, 235',
					'alpha' => array( '0.9', '0.8' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '243, 82, 90',
					'alpha' => array( '0.5', '0.8' ),
				);

				break;
			case 'layout_manchester':
				$config['primary_font_family']  = 'Sen';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.stm_contacts_widget.style_3,
					.stats_counter h3,
					a.allservices,
					.elementor-container .elementor-progress-text, 
					.elementor-container .elementor-tab-title a, 
					.elementor-container .consulting_heading_font, 
					.elementor-container .elementor-widget-wp-widget-nav_menu ul li, 
					.elementor-container .elementor-button-text, 
					.elementor-container .elementor-tab-title,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.icon_box.style_10 .icon_box_inner h4,
					.elementor-button .elementor-button-text,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body .vc_general.vc_btn3';

				$config['secondary_font_family']  = 'Playfair Display';
				$config['secondary_font_classes'] = 'h1 em, .h1 em,
					h2 em, .h2 em,
					h3 em, .h3 em,
					h4 em, .h4 em,
					h5 em, .h5 em,
					h6 em, .h6 em';

				$config['base_color']      = '#082471';
				$config['secondary_color'] = '#082471';
				$config['third_color']     = '#f96156';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '55, 99, 235',
					'alpha' => array( '0.9', '0.8' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '243, 82, 90',
					'alpha' => array( '0.5', '0.8' ),
				);

				break;
			case 'layout_jakarta':
				$config['primary_font_family']  = 'Roboto';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.icon_box.style_10 .icon_box_inner h4,
					.elementor-button .elementor-button-text,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body .vc_general.vc_btn3';

				$config['secondary_font_family']  = 'Kumbh Sans';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#333333';
				$config['secondary_color'] = '#3763eb';
				$config['third_color']     = '#f3525a';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '55, 99, 235',
					'alpha' => array( '0.9' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '243, 82, 90',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_geneva':
				$config['primary_font_family']  = 'Montserrat';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.heading_font,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#162043';
				$config['secondary_color'] = '#fd5e1f';
				$config['third_color']     = '#fd5e1f';

				$config['base_rgb_color']      = array(
					'rgb'   => '22, 32, 67',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '253, 94, 31',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 94, 31',
					'alpha' => '',
				);

				break;
			case 'layout_melbourne':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong, normal-font';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b, #header, .icon_box.style_5 .text_more, .heading-font,
					.countdown_box .stm-register-form .user_validated_field, .stm_works_wr.grid_with_filter.style_1 .works_filter a, .vc_testimonials.style_3.navigation-arrows .vc_testimonials_carousel_wr .item>p,
					.testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .stm_testimonial_excerpt p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Poppins:300,400,500,600,700',
				);

				$config['base_color']      = '#002e5b';
				$config['secondary_color'] = '#6c98e1';
				$config['third_color']     = '#fde428';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 46, 91',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '108, 152, 225',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 228, 40',
					'alpha' => '',
				);

				break;
			case 'layout_lyon':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong, normal-font';

				$config['secondary_font_family']  = 'DM Sans';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b, #header, .icon_box.style_5 .text_more, .heading-font,
					.countdown_box .stm-register-form .user_validated_field, .stm_works_wr.grid_with_filter.style_1 .works_filter a, .vc_testimonials.style_3.navigation-arrows .vc_testimonials_carousel_wr .item>p,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .stm_testimonial_excerpt p';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'DM Sans:400,600,700',
				);

				$config['base_color']      = '#283043';
				$config['secondary_color'] = '#f47957';
				$config['third_color']     = '#0b86a8';

				$config['base_rgb_color']      = array(
					'rgb'   => '40, 48, 67',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '244, 121, 87',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '11, 134, 168',
					'alpha' => '',
				);

				break;
			case 'layout_stockholm':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong, normal-font';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b, #header, .icon_box.style_5 .text_more, .heading-font,
					.countdown_box .stm-register-form .user_validated_field, .stm_works_wr.grid_with_filter.style_1 .works_filter a, .vc_testimonials.style_3.navigation-arrows .vc_testimonials_carousel_wr .item>p,
					.testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .stm_testimonial_excerpt p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#222831';
				$config['secondary_color'] = '#4a57fe';
				$config['third_color']     = '#3a57fe';

				$config['base_rgb_color']      = array(
					'rgb'   => '34, 40, 49',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '74, 87, 254',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '58, 87, 254',
					'alpha' => '',
				);

				break;
			case 'layout_ankara':
				$config['primary_font_family']  = 'Montserrat';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong, normal-font';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b, #header, .icon_box.style_5 .text_more, .heading-font,
					.countdown_box .stm-register-form .user_validated_field, .stm_works_wr.grid_with_filter.style_1 .works_filter a, .vc_testimonials.style_3.navigation-arrows .vc_testimonials_carousel_wr .item>p,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .stm_testimonial_excerpt p';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#333333';
				$config['secondary_color'] = '#73c73b';
				$config['third_color']     = '#607d8b';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '115, 199, 59',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '96, 125, 139',
					'alpha' => '',
				);

				break;
			case 'layout_budapest':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong, normal-font';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b, #header, .icon_box.style_5 .text_more, .heading-font,
					.countdown_box .stm-register-form .user_validated_field, .stm_works_wr.grid_with_filter.style_1 .works_filter a, .vc_testimonials.style_3.navigation-arrows .vc_testimonials_carousel_wr .item>p,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .stm_testimonial_excerpt p';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#304156';
				$config['secondary_color'] = '#304157';
				$config['third_color']     = '#ffcf2f';

				$config['base_rgb_color']      = array(
					'rgb'   => '48, 65, 86',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '48, 65, 87',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '255, 207, 47',
					'alpha' => '',
				);

				break;
			case 'layout_osaka':
				$config['primary_font_family']  = 'Poppins';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong, normal-font';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b, #header, .icon_box.style_5 .text_more, .heading-font,
					.countdown_box .stm-register-form .user_validated_field, .stm_works_wr.grid_with_filter.style_1 .works_filter a, .vc_testimonials.style_3.navigation-arrows .vc_testimonials_carousel_wr .item>p,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .stm_testimonial_excerpt p';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#333333';
				$config['secondary_color'] = '#5a4af5';
				$config['third_color']     = '#49aafe';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '90, 74, 245',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '73, 170, 254',
					'alpha' => '',
				);

				break;
			case 'layout_barcelona':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong, normal-font';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b, #header, .icon_box.style_5 .text_more, .heading-font,
					.countdown_box .stm-register-form .user_validated_field, .stm_works_wr.grid_with_filter.style_1 .works_filter a, .vc_testimonials.style_3.navigation-arrows .vc_testimonials_carousel_wr .item>p,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .stm_testimonial_excerpt p';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#222831';
				$config['secondary_color'] = '#4a57fe';
				$config['third_color']     = '#3a57fe';

				$config['base_rgb_color']      = array(
					'rgb'   => '34, 40, 49',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '74, 87, 254',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '58, 87, 254',
					'alpha' => '',
				);

				break;
			case 'layout_lisbon':
				$config['primary_font_family']  = 'Poppins';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					strong, b,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong, normal-font';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					body.header_style_5 .header_top .info-text b, #header, .icon_box.style_5 .text_more, .heading-font,
					.countdown_box .stm-register-form .user_validated_field, .stm_works_wr.grid_with_filter.style_1 .works_filter a, .vc_testimonials.style_3.navigation-arrows .vc_testimonials_carousel_wr .item>p';

				$config['fonts'] = array();

				$config['base_color']      = '#222831';
				$config['secondary_color'] = '#7bc74d';
				$config['third_color']     = '#6bc74d';

				$config['base_rgb_color']      = array(
					'rgb'   => '34, 40, 49',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '123, 199, 77',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '107, 199, 77',
					'alpha' => '',
				);

				break;
			case 'layout_berlin':
				$config['primary_font_family']  = 'Poppins';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					body.header_style_5 .header_top .info-text b';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#002e5b';
				$config['secondary_color'] = '#6c98e1';
				$config['third_color']     = '#fde428';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 46, 91',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '108, 152, 225',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 228, 40',
					'alpha' => '',
				);

				break;
			case 'layout_marseille':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 13;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Raleway';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					body.header_style_5 .header_top .info-text b';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#000000';
				$config['secondary_color'] = '#3595d6';
				$config['third_color']     = '#3595d5';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 0, 0',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '53, 149, 214',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '53, 149, 213',
					'alpha' => '',
				);

				break;
			case 'layout_vienna':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 13;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					body.header_style_5 .header_top .info-text b';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#001a57';
				$config['secondary_color'] = '#297ee8';
				$config['third_color']     = '#fd9b28';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 26, 87',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '41, 126, 232',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 155, 40',
					'alpha' => '',
				);

				break;
			case 'layout_milan':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 13;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Fira Sans';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#002e5b';
				$config['secondary_color'] = '#6c98e1';
				$config['third_color']     = '#fde428';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 46, 91',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '108, 152, 225',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 228, 40',
					'alpha' => '',
				);

				break;
			case 'layout_new_delhi':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 15;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Oswald';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#00263b';
				$config['secondary_color'] = '#e5452b';
				$config['third_color']     = '#009aee';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 38, 59',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '229, 69, 43',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '0, 154, 238',
					'alpha' => '',
				);

				break;
			case 'layout_istanbul':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 13;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#2b212c';
				$config['secondary_color'] = '#fde428';
				$config['third_color']     = '#cba671';

				$config['base_rgb_color']      = array(
					'rgb'   => '43, 33, 44',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '253, 228, 40',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '203, 166, 113',
					'alpha' => '',
				);

				break;
			case 'layout_beijing':
				$config['primary_font_family']  = 'Poppins';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Lato';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#0b2a41';
				$config['secondary_color'] = '#a0ce4e';
				$config['third_color']     = '#a0ce3e';

				$config['base_rgb_color']      = array(
					'rgb'   => '11, 42, 65',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '160, 206, 78',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '160, 206, 62',
					'alpha' => '',
				);

				break;
			case 'layout_munich':
				$config['primary_font_family']  = 'Poppins';
				$config['primary_font_size']    = 16;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Epilogue';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#19BD78';
				$config['secondary_color'] = '#1B3041';
				$config['third_color']     = '#1F2529';

				$config['base_rgb_color']      = array(
					'rgb'   => '27, 48, 65',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '25, 189, 120',
					'alpha' => '',
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '31, 37, 41',
					'alpha' => array( '0.2', '0.6', '0.7', '0.8' ),
				);

				break;
			case 'layout_san_francisco':
				$config['primary_font_family']  = 'Mulish';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Mulish';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#1c1c1c';
				$config['secondary_color'] = '#fde428';
				$config['third_color']     = '#fde427';

				$config['base_rgb_color']      = array(
					'rgb'   => '28, 28, 28',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '253, 228, 40',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 228, 39',
					'alpha' => '',
				);

				break;
			case 'layout_toronto':
				$config['primary_font_family']  = 'Mulish';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Mulish';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#1c1c1c';
				$config['secondary_color'] = '#ff7043';
				$config['third_color']     = '#ff7042';

				$config['base_rgb_color']      = array(
					'rgb'   => '28, 28, 28',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '255, 112, 67',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '255, 112, 66',
					'alpha' => '',
				);

				break;
			case 'layout_los_angeles':
				$config['primary_font_family']  = 'Poppins';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#002e5b';
				$config['secondary_color'] = '#6c98e1';
				$config['third_color']     = '#fde428';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 46, 91',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '108, 152, 225',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 228, 40',
					'alpha' => '',
				);

				break;
			case 'layout_brussels':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#1e1c1b';
				$config['secondary_color'] = '#fd4f02';
				$config['third_color']     = '#fd4f01';

				$config['base_rgb_color']      = array(
					'rgb'   => '30, 28, 27',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '253, 79, 2',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 79, 1',
					'alpha' => '',
				);

				break;
			case 'layout_denver':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#000000';
				$config['secondary_color'] = '#2c33d2';
				$config['third_color']     = '#e61e3a';

				$config['base_rgb_color']      = array(
					'rgb'   => '0,0,0',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '44, 51, 210',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '230, 30, 58',
					'alpha' => '',
				);

				break;
			case 'layout_davos':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Rajdhani';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#1c6876';
				$config['secondary_color'] = '#d79953';
				$config['third_color']     = '#d79952';

				$config['base_rgb_color']      = array(
					'rgb'   => '28, 104, 118',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '215, 153, 83',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '215, 153, 82',
					'alpha' => '',
				);

				break;
			case 'layout_amsterdam':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Rubik';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm-header__hb .stm-navigation__default ul li,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#243238';
				$config['secondary_color'] = '#8fc8f8';
				$config['third_color']     = '#d7562d';

				$config['base_rgb_color']      = array(
					'rgb'   => '36, 50, 56',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '143, 200, 248',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '215, 86, 45',
					'alpha' => '',
				);

				break;
			case 'layout_mumbai':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Cairo';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#000000';
				$config['secondary_color'] = '#e3002a';
				$config['third_color']     = '#e3001a';

				$config['base_rgb_color']      = array(
					'rgb'   => '0,0,0',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '227, 0, 42',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '227, 0, 26',
					'alpha' => '',
				);

				break;
			case 'layout_zurich':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Roboto Slab';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#002e5b';
				$config['secondary_color'] = '#ff636a';
				$config['third_color']     = '#ff635a';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 46, 91',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '255, 99, 106',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '255, 99, 90',
					'alpha' => '',
				);

				break;
			case 'layout_20':
				$config['primary_font_family']  = 'Maven Pro';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, Catamaran,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Catamaran';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Maven+Pro:400,500,700',
					'montserrat' => 'Catamaran:300,400,500,600,700',
				);

				$config['base_color']      = '#785e4d';
				$config['secondary_color'] = '#ff8426';
				$config['third_color']     = '#baaf92';

				$config['base_rgb_color']      = array(
					'rgb'   => '120, 94, 77',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '255, 132, 38',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '186, 175, 146',
					'alpha' => '',
				);

				break;
			case 'layout_19':
				$config['primary_font_family']  = 'Exo';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#001040';
				$config['secondary_color'] = '#5f96ee';
				$config['third_color']     = '#ffa200';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 16, 64',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '95, 150, 238',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '255, 162, 0',
					'alpha' => '',
				);

				break;
			case 'layout_18':
				$config['fonts'] = array(
					'mirza' => 'Mirza:400,700&subset=arabic',
					'mada'  => 'Lalezar:400&subset=arabic',
				);

				$config['primary_font_family']  = 'Mirza';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body.site_layout_17 #footer .footer_widgets .widget.widget_nav_menu ul li a,
					.stm_normal_font,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					body.site_layout_15 .stats_counter .counter_title,
					body.site_layout_15 .testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .position,
					body.site_layout_15 .testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .company,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p';

				$config['secondary_font_family']  = 'Lalezar';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading_font,
					.staff_list.grid.short-view ul .staff_custom_link a,
					body.site_layout_16 .stats_counter.style_2 .inner h3,
					body.site_layout_15 .stm_works_wr.style_1 .works_filter li a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#260000';
				$config['secondary_color'] = '#911f27';
				$config['third_color']     = '#f7d098';

				$config['base_rgb_color']      = array(
					'rgb'   => '38, 0, 0',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '145, 31, 39',
					'alpha' => array( '0.9' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '247, 208, 152',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_17':
				$config['fonts'] = array(
					'mirza' => 'Mirza:400,700&subset=arabic',
					'mada'  => 'Mada:300,400,900',
				);

				$config['primary_font_family']  = 'Mirza';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body.site_layout_17 #footer .footer_widgets .widget.widget_nav_menu ul li a,
					.stm_normal_font,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					body.site_layout_15 .stats_counter .counter_title,
					body.site_layout_15 .testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .position,
					body.site_layout_15 .testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .company,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p';

				$config['secondary_font_family']  = 'Mada';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading_font,
					.staff_list.grid.short-view ul .staff_custom_link a,
					body.site_layout_16 .stats_counter.style_2 .inner h3,
					body.site_layout_15 .stm_works_wr.style_1 .works_filter li a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#00032d';
				$config['secondary_color'] = '#f7825d';
				$config['third_color']     = '#f5e495';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 3, 45',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '247, 130, 93',
					'alpha' => array( '0.9' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '245, 228, 149',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_16':
				$config['fonts'] = array(
					'rubik' => 'Rubik:300,400,700&subset=hebrew',
					'alef'  => 'Alef:400,700&subset=hebrew',
				);

				$config['primary_font_family']  = 'Rubik';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					.stm_normal_font,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					body.site_layout_15 .stats_counter .counter_title,
					body.site_layout_15 .testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .position,
					body.site_layout_15 .testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .company,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p';

				$config['secondary_font_family']  = 'Alef';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading_font,
					.staff_list.grid.short-view ul .staff_custom_link a,
					body.site_layout_16 .stats_counter.style_2 .inner h3,
					body.site_layout_15 .stm_works_wr.style_1 .works_filter li a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#000000';
				$config['secondary_color'] = '#00bbcc';
				$config['third_color']     = '#10bbcc';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 0, 0',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '0, 187, 204',
					'alpha' => array( '0.9' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '16, 187, 204',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_15':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					body.site_layout_15 .stats_counter .counter_title,
					body.site_layout_15 .testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .position,
					body.site_layout_15 .testimonials_carousel.style_1:not(.disable_carousel) .testimonial .info .company,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading_font,
					.staff_list.grid.short-view ul .staff_custom_link a,
					body.site_layout_15 .stm_works_wr.style_1 .works_filter li a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#444036';
				$config['secondary_color'] = '#50c19a';
				$config['third_color']     = '#e4f68f';

				$config['base_rgb_color']      = array(
					'rgb'   => '68, 64, 54',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '80, 193, 154',
					'alpha' => array( '0.9' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '228, 246, 143',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_14':
				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
				    .testimonials_carousel .testimonial .info .position,
				    .testimonials_carousel .testimonial .info .company,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					body.site_layout_14 .testimonials_carousel.disable_carousel .testimonial .info .position,
					body.site_layout_14 .testimonials_carousel.disable_carousel .testimonial .info .company,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					body.site_layout_14 .header_top .stm_l14_h5-right .stm_l14_h5-wh .text a,
					body.site_layout_14 .info_box .read_more span,
					body.site_layout_14 .staff_list.grid ul li .staff_info .read_more span,
					.heading_font,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#2d4059';
				$config['secondary_color'] = '#ea5455';
				$config['third_color']     = '#ea5454';

				$config['base_rgb_color']      = array(
					'rgb'   => '45, 64, 89',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '234, 84, 85',
					'alpha' => array( '0.9' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '234, 84, 84',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_13':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.testimonials_carousel .testimonial .info .position,
                    .testimonials_carousel .testimonial .info .company,
                    .stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
                    .widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.stm_slider_title_reply,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.testimonials_carousel .testimonial .info .stm_testimonials_content_unit,
					body.site_layout_13.header_style_4 .header_top .icon_text a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#347a2a';
				$config['secondary_color'] = '#202e24';
				$config['third_color']     = '#b3c87a';

				$config['base_rgb_color']      = array(
					'rgb'   => '52, 122, 42',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '32, 46, 36',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '179, 200, 122',
					'alpha' => '',
				);

				break;
			case 'layout_12':
				$config['fonts'] = array(
					'open_sans' => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'rubik'     => 'Rubik:400,300,500,700,900&subset=latin,latin-ext',
				);

				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p';

				$config['secondary_font_family']  = 'Rubik';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#002e5b';
				$config['secondary_color'] = '#6c98e1';
				$config['third_color']     = '#fde428';

				$config['base_rgb_color']      = array(
					'rgb'   => '0, 46, 91',
					'alpha' => array( '0.9', '0.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '108, 152, 225',
					'alpha' => array( '0.9' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 228, 40',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_11':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#222831';
				$config['secondary_color'] = '#7bc74d';
				$config['third_color']     = '#6bc74d';

				$config['base_rgb_color']      = array(
					'rgb'   => '34, 40, 49',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '123, 199, 77',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '107, 199, 77',
					'alpha' => '',
				);

				break;
			case 'layout_10':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					body.header_style_4 .header_top .icon_text .text strong,
					body.header_style_4 .header_top .icon_text .text b,
					body.header_style_6 .top_bar_contacts_text strong,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_6 .top_bar_contacts_text b';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#17181d';
				$config['secondary_color'] = '#e33062';
				$config['third_color']     = '#e33061';

				$config['base_rgb_color']      = array(
					'rgb'   => '23, 24, 29',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.35' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '227, 48, 98',
					'alpha' => array( '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '227, 48, 97',
					'alpha' => '',
				);

				break;
			case 'layout_9':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#1e1f21';
				$config['secondary_color'] = '#fd9b28';
				$config['third_color']     = '#fd9b27';

				$config['base_rgb_color']      = array(
					'rgb'   => '30, 31, 33',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '253, 155, 40',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 155, 39',
					'alpha' => array( '0.9', '0.5' ),
				);

				break;
			case 'layout_8':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					body.header_style_4 .header_top .icon_text .text strong,
					body.header_style_4 .header_top .icon_text .text b,
					body.header_style_6 .top_bar_contacts_text strong,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_6 .top_bar_contacts_text b';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#29363b';
				$config['secondary_color'] = '#b2ac90';
				$config['third_color']     = '#f15822';

				$config['base_rgb_color']      = array(
					'rgb'   => '41, 54, 59',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.35' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '178, 172, 144',
					'alpha' => array( '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '241, 88, 34',
					'alpha' => '',
				);

				break;
			case 'layout_7':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					body.header_style_4 .header_top .icon_text .text strong,
					body.header_style_4 .header_top .icon_text .text b,
					body.header_style_6 .top_bar_contacts_text strong,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_6 .top_bar_contacts_text b';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#142440';
				$config['secondary_color'] = '#4ac8ed';
				$config['third_color']     = '#3ac8ed';

				$config['base_rgb_color']      = array(
					'rgb'   => '20, 36, 64',
					'alpha' => array( '0.25', '0.21', '0.75', '0.9', '0.6', '0.5' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '74, 200, 237',
					'alpha' => array( '0.6' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '58, 200, 237',
					'alpha' => array( '0.6' ),
				);

				break;
			case 'layout_6':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 13;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#090821';
				$config['secondary_color'] = '#c79d63';
				$config['third_color']     = '#c79d62';

				$config['base_rgb_color']      = array(
					'rgb'   => '9, 8, 33',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '199, 157, 99',
					'alpha' => array( '0.75', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '199, 157, 98',
					'alpha' => '',
				);

				break;
			case 'layout_5':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#251021';
				$config['secondary_color'] = '#6991d1';
				$config['third_color']     = '#6cbaae';

				$config['base_rgb_color']      = array(
					'rgb'   => '37, 16, 33',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '105, 145, 209',
					'alpha' => array( '0.6' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '108, 186, 174',
					'alpha' => array( '0.8', '0.5' ),
				);

				break;
			case 'layout_4':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 13;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#30344d';
				$config['secondary_color'] = '#038875';
				$config['third_color']     = '#a5d4ce';

				$config['base_rgb_color']      = array(
					'rgb'   => '48, 52, 77',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.3', '0.5' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '3, 136, 117',
					'alpha' => '',
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '165, 212, 206',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_3':
				$config['fonts'] = array(
					'open_sans' => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'poppins'   => 'Poppins:400,500,300,600,700&subset=latin,latin-ext,devanagari',
				);

				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#153e4d';
				$config['secondary_color'] = '#fde953';
				$config['third_color']     = '#fde952';

				$config['base_rgb_color']      = array(
					'rgb'   => '21, 62, 77',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.78' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '253, 233, 83',
					'alpha' => '',
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 233, 82',
					'alpha' => '',
				);

				break;
			case 'layout_2':
				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.wpb_text_column ul li,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,700',
				);

				$config['base_color']      = '#1e1f21';
				$config['secondary_color'] = '#fd9b28';
				$config['third_color']     = '#fd9b27';

				$config['base_rgb_color']      = array(
					'rgb'   => '30, 31, 33',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '253, 155, 40',
					'alpha' => array( '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 155, 39',
					'alpha' => array( '0.5' ),
				);

				break;
			case 'layout_liverpool':
				$config['primary_font_family']  = 'Poppins';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					body.header_style_4 .header_top .icon_text .text strong';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.heading_font,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					body.header_style_5 .header_top .info-text b';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#333333';
				$config['secondary_color'] = '#ff3833';
				$config['third_color']     = '#ff3833';

				$config['base_rgb_color']      = array(
					'rgb'   => '51, 51, 51',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '255, 56, 51',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '255, 56, 51',
					'alpha' => '',
				);

				break;
			case 'layout_miami':
				$config['primary_font_family']  = 'Kumbh Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,                
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item .testimonial_info,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					body.header_style_4 .header_top .icon_text .text strong,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.elementor-widget-accordion .elementor-accordion .elementor-accordion-item .elementor-tab-title .elementor-accordion-title';

				$config['secondary_font_family']  = 'Montserrat';
				$config['secondary_font_classes'] = 'h1, .h1,
                    .heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.stm_works_wr.grid_with_carousel .owl-stage-outer .info .title,
					.stocks_table .single-item div.exchange_box .stock-exchange,
					.stm-header__hb .stm-navigation__default ul li,
					.vc_testimonials.style_4.navigation-bullets .vc_testimonials_carousel_wr .item > p,
					.vc_testimonials.style_4.navigation-arrows .vc_testimonials_carousel_wr .item > p,
					.icon_box.style_1.icon_left p,
					.stm_pricing_plan .top .title,
					.stm_pricing_plan .top .price,
					.stm_pricing_plan .top .subtitle,
					.stm_pricing_plan .top .stm_label,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.comment-body .comment-text ul li,
					body.header_style_4 .header_top .icon_text.big .text strong,
					.info_box .read_more,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_cost,
					.vc_custom_heading .subtitle,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.info_box h4,
					.testimonials_carousel.style_2 .item .testimonial-info .testimonial-text .name,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body .vc_progress_bar .vc_label,
					body .quote_box .quote,
					body .quote_box .author_info .author_name,
					.wpb_wrapper .vc_pie_chart,
					.stm_portfolio_info .stm_portfolio_info_row .item .portfolio_info_title,
					.heading_font,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name a,
					body.header_style_5 .header_top .info-text b,
					.vc_general.vc_btn3,
					.vc_cta3 .vc_custom_heading .consulting-custom-title,
                    .elementor-widget-container h1,
                    .elementor-177 .elementor-element.elementor-element-b751ccb .ce_cta__content__title,
                    .elementor-tabs .elementor-tabs-wrapper .elementor-tab-title,
                    .consulting_elementor_sidebar .elementor-button .elementor-button-text,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['fonts'] = array(
					'open_sans'  => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'montserrat' => 'Montserrat:400,500,600,600semi-bold,700,700bold',
				);

				$config['base_color']      = '#1bcb81';
				$config['secondary_color'] = '#002e5b';
				$config['third_color']     = '#1bcb81';

				$config['base_rgb_color']      = array(
					'rgb'   => '27, 203, 129',
					'alpha' => array( '0.25', '0.21', '0.9', '0.75', '0.5', '0.8', '0.85', '0.7' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '0, 46, 91',
					'alpha' => array( '0.9', '0.5' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '27, 203, 129',
					'alpha' => '',
				);

				break;
			default:
				$config['fonts'] = array(
					'open_sans' => 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
					'poppins'   => 'Poppins:400,500,300,600,700&subset=latin,latin-ext,devanagari',
				);

				$config['primary_font_family']  = 'Open Sans';
				$config['primary_font_size']    = 14;
				$config['primary_font_classes'] = 'html, body,
					body .vc_general.vc_btn3 small,
					.stm_contacts_widget.style_3,
					a.allservices,
					.top_bar .cart_count .count,
					.default_widgets .widget.widget_nav_menu ul li .children li,
					.default_widgets .widget.widget_categories ul li .children li,
					.default_widgets .widget.widget_product_categories ul li .children li,
					.stm_sidebar .widget.widget_nav_menu ul li .children li,
					.stm_sidebar .widget.widget_categories ul li .children li,
					.stm_sidebar .widget.widget_product_categories ul li .children li,
					.shop_widgets .widget.widget_nav_menu ul li .children li,
					.shop_widgets .widget.widget_categories ul li .children li,
					.shop_widgets .widget.widget_product_categories ul li .children li,
					.item .item_wr .content .stm-event__meta li,
					.wpb_text_column ul li p, .comment-body ul li p, .comment-text ul li p,
					.widget.widget_nav_menu ul li.children ul li, .widget.widget_nav_menu ul li.sub-menu ul li,
					.widget.widget_categories ul li.children ul li, .widget.widget_categories ul li.sub-menu ul li,
					.widget.widget_product_categories ul li.children ul li, .widget.widget_product_categories ul li.sub-menu ul li,
					.widget.widget_archive ul li.children ul li, .widget.widget_archive ul li.sub-menu ul li,
					.widget.widget_pages ul li.children ul li, .widget.widget_pages ul li.sub-menu ul li,
					.widget.widget_meta ul li.children ul li, .widget.widget_meta ul li.sub-menu ul li,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title .portfolio-category';

				$config['secondary_font_family']  = 'Poppins';
				$config['secondary_font_classes'] = 'h1, .h1,
					h2, .h2,
					h3, .h3,
					h4, .h4,
					h5, .h5,
					h6, .h6,
					.heading-font,
					.countdown_box .stm-register-form .user_validated_field,
					.staff_list.grid.short-view ul .staff_custom_link a,
					.top_nav .top_nav_wrapper > ul,
					.nav-box .main_menu_nav,
					.top_nav .icon_text strong,
					.stm_testimonials .item .testimonial-info .testimonial-text .name,
					.stats_counter .counter_title,
					.stm_contact .stm_contact_info .stm_contact_job,
					.vacancy_table_wr .vacancy_table thead th,
					.testimonials_carousel .testimonial .info .position,
					.testimonials_carousel .testimonial .info .company,
					.stm_gmap_wrapper .gmap_addresses .addresses .item .title,
					.company_history > ul > li .year,
					.stm_contacts_widget, .stm_contacts_widget.style_4,
					.stm_works_wr.grid .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter .stm_works .item .info .title,
					body .vc_general.vc_btn3,
					.consulting-rev-title,
					.consulting-rev-title-2,
					.consulting-rev-title-3,
					.consulting-rev-text,
					body .vc_tta-container .vc_tta.vc_general.vc_tta-tabs.theme_style .vc_tta-tabs-container .vc_tta-tabs-list .vc_tta-tab a,
					strong, b,
					.button,
					.page-links > span, .page-links > span a,
					body.header_style_2 .header_top .top_nav .header_socials a.cart_count .count,
					.woocommerce a.button,
					.woocommerce button.button,
					.woocommerce input.button,
					.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
					.woocommerce input.button.alt,
					.woocommerce-account .woocommerce-MyAccount-navigation ul li a,
					.woocommerce .widget_price_filter ul.product_list_widget li .product-title,
					.request_callback p,
					ul.comment-list .comment .comment-author,
					.page-numbers .page-numbers,
					#footer .footer_widgets .widget.widget_recent_entries ul li a,
					.default_widgets .widget.widget_nav_menu ul li,
					.default_widgets .widget.widget_categories ul li,
					.default_widgets .widget.widget_product_categories ul li,
					.stm_sidebar .widget.widget_nav_menu ul li, .stm_sidebar .widget.widget_categories ul li,
					.stm_sidebar .widget.widget_product_categories ul li,
					.shop_widgets .widget.widget_nav_menu ul li,
					.shop_widgets .widget.widget_categories ul li,
					.shop_widgets .widget.widget_product_categories ul li,
					.default_widgets .widget.widget_recent_entries ul li a,
					.stm_sidebar .widget.widget_recent_entries ul li a,
					.shop_widgets .widget.widget_recent_entries ul li a,
					.staff_bottom_wr .staff_bottom .infos .info,
					.consulting-rev-title, .consulting-rev-title-2, .consulting-rev-title-3, .consulting-rev-text,
					.woocommerce .widget_price_filter .price_slider_amount .button,
					.woocommerce ul.product_list_widget li .product-title,
					.woocommerce ul.products li.product .price,
					.woocommerce a.added_to_cart,
					.woocommerce div.product .woocommerce-tabs ul.tabs li a,
					.woocommerce div.product form.cart .variations label,
					.woocommerce table.shop_table th,
					.woocommerce-cart table.cart th.product-name a,
					.woocommerce-cart table.cart td.product-name a,
					.woocommerce-cart table.cart th .amount,
					.woocommerce-cart table.cart td .amount,
					.stm_services .item .item_wr .content .read_more,
					.staff_list ul li .staff_info .staff_department,
					.stm_partner.style_2 .stm_partner_content .position,
					.staff_carousel_item .staff_department,
					body.header_style_5 .header_top .info-text strong,
					.stm_services_tabs .services_categories ul li a,
					.stm_services_tabs .service_tab_item .service_name,
					.stm_services_tabs .service_tab_item .service_cost,
					.stm_works_wr.grid_2.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_2.style_2 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_1 .stm_works .item .item_wr .title,
					.stm_works_wr.grid_with_filter.style_2 .stm_works .item .item_wr .title,
					body.header_style_7 .side_nav .main_menu_nav > li > a,
					body.header_style_7 .side_nav .main_menu_nav > li ul li a,
					body.header_style_5 .header_top .info-text b,
					.stm_portfolio_grid .item .item_thumbnail a .portfolio-title,
					.stm_portfolio_info .stm_portfolio_info_row .item,
					.post_links_box.style_3 a .post_links_info,
					.stm_events_modern .stm_events_modern_list .item .item_wr .content .stm_events_modern_row .event_speaker_content .event_speaker_name,
					.event_content .event_info_table .event_info ul li,
					.event_lesson_tabs a,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_speakers li .event_speaker_content .event_speaker_name,
					.event_lesson_info .event_lesson_info_content_wrap .event_lesson_info_content .event_lesson_info_title,
					.widget.widget_nav_menu ul li,
					.widget.widget_categories ul li,
					.widget.widget_product_categories ul li,
					.widget.widget_archive ul li,
					.widget.widget_pages ul li,
					.widget.widget_meta ul li,
					.widget.widget_recent_comments ul li,
					.widget.widget_rss ul li,
					.widget.widget_recent_entries ul li a,
					.post_links_box.style_3 .post_link_text';

				$config['base_color']      = '#002e5b';
				$config['secondary_color'] = '#6c98e1';
				$config['third_color']     = '#fde428';

				$config['base_rgb_color']      = array(
					'rgb'   => '0,46,91',
					'alpha' => array( '0.9', '.75', '0.5', '0.25', '0.21' ),
				);
				$config['secondary_rgb_color'] = array(
					'rgb'   => '108, 152, 225',
					'alpha' => array( '0.9' ),
				);
				$config['third_rgb_color']     = array(
					'rgb'   => '253, 228, 40',
					'alpha' => array( '0.5' ),
				);
		}

		$config['secondary_font_classes'] = implode( ',', apply_filters( 'consulting_secondary_font_classes', array() ) ) . ' ' . $config['secondary_font_classes'];

		return $config;
	}
}

function consulting_get_layout() {
	$consulting_layout = get_option( 'consulting_layout', 'layout_1' );

	return $consulting_layout;
}

function consulting_layout_plugins( $layout = 'layout_1', $get_layouts = false ) {
	$required = array(
		'envato-market',
		'stm-importer',
		'stm-post-type',
		'stm-elementor-icons',
		'revslider',
		'breadcrumb-navxt',
		'contact-form-7',
		'woocommerce',
		'instagram-feed',
		'cost-calculator-builder',
		'stm-templates-library',
	);

	$plugins = array(
		'layout_20'           => array(
			'mailchimp-for-wp',
		),
		'layout_osaka'        => array(
			'mailchimp-for-wp',
		),
		'layout_budapest'     => array(
			'mailchimp-for-wp',
		),
		'layout_manchester'   => array(
			'header-footer-elementor',
		),
		'layout_atlanta'      => array(
			'header-footer-elementor',
			'mailchimp-for-wp',
		),
		'layout_kuala_lumpur' => array(
			'header-footer-elementor',
		),
		'layout_valencia'     => array(
			'header-footer-elementor',
		),
		'layout_kyiv'         => array(
			'header-footer-elementor',
		),
		'layout_houston'      => array(
			'header-footer-elementor',
		),
		'layout_monaco'       => array(
			'header-footer-elementor',
		),
		'layout_munich'       => array(
			'header-footer-elementor',
		),
	);

	if ( $get_layouts ) {
		return $plugins;
	}

	return ( ! empty( $plugins[ $layout ] ) ) ? array_merge( $required, $plugins[ $layout ] ) : $required;

}

function consulting_premium_bundled_plugins() {
	return array(
		'js_composer',
		'elementor',
		'consulting-elementor-widgets',
		'cost-calculator-builder',
		'gdpr-compliance-cookie-consent',
	);
}

add_filter( 'cew_before_converting_content', 'consulting_cew_before_converting_content' );

function consulting_cew_before_converting_content( $content ) {
	$layout       = consulting_config();
	$heading_font = $layout['secondary_font_family'];

	$content = str_replace( array( 'Montserrat', 'Poppins' ), $heading_font, $content );

	return $content;
}

add_action( 'cew_patch_ended', 'consulting_cew_patch_ended' );

function consulting_cew_patch_ended() {
	$color_opt_name    = 'elementor_scheme_color';
	$consulting_config = consulting_config();

	$base_color      = consulting_theme_option( 'site_skin_base_color', $consulting_config['base_color'] );
	$secondary_color = consulting_theme_option( 'site_skin_secondary_color', $consulting_config['secondary_color'] );
	$third_color     = consulting_theme_option( 'site_skin_third_color', $consulting_config['third_color'] );

	$colors = array(
		'1' => $base_color,
		'2' => $secondary_color,
		'3' => '#222222',
		'4' => $third_color,
	);

	update_option( $color_opt_name, $colors );

	$font_opt_name = 'elementor_scheme_typography';
	$fonts         = array(
		'1' => array(
			'font_family' => '',
			'font_weight' => '',
		),
		'2' => array(
			'font_family' => '',
			'font_weight' => '',
		),
		'3' => array(
			'font_family' => '',
			'font_weight' => '',
		),
		'4' => array(
			'font_family' => '',
			'font_weight' => '',
		),
	);

	update_option( $font_opt_name, $fonts );

}

function consulting_get_actual_colors() {
	$consulting_config = consulting_config();
	$colors            = array(
		'base_color'      => consulting_theme_option( 'site_skin_base_color', $consulting_config['base_color'] ),
		'secondary_color' => consulting_theme_option( 'site_skin_secondary_color', $consulting_config['secondary_color'] ),
		'third_color'     => consulting_theme_option( 'site_skin_third_color', $consulting_config['third_color'] ),
	);

	$skin = consulting_theme_option( 'site_skin', 'skin_default' );

	if ( 'skin_default' === $skin ) {
		$colors = array(
			'base_color'      => $consulting_config['base_color'],
			'secondary_color' => $consulting_config['secondary_color'],
			'third_color'     => $consulting_config['third_color'],
		);
	}

	return $colors;
}

function consulting_get_demos() {
	return array(
		'layout_1'             => array(
			'label'    => esc_html__( 'New York', 'consulting' ),
			'slug'     => 'new_york',
			'live_url' => '',
		),
		'layout_munich'        => array(
			'label'    => esc_html__( 'Munich', 'consulting' ),
			'slug'     => 'munich',
			'live_url' => 'munich/',
			'builder'  => 'elementor',
		),
		'layout_monaco'        => array(
			'label'    => esc_html__( 'Monaco', 'consulting' ),
			'slug'     => 'monaco',
			'live_url' => 'monaco/',
			'builder'  => 'elementor',
		),
		'layout_houston'       => array(
			'label'    => esc_html__( 'Houston', 'consulting' ),
			'slug'     => 'houston',
			'live_url' => 'houston/',
			'builder'  => 'elementor',
		),
		'layout_kyiv'          => array(
			'label'    => esc_html__( 'Kyiv', 'consulting' ),
			'slug'     => 'kyiv',
			'live_url' => 'kyiv/',
			'builder'  => 'elementor',
		),
		'layout_valencia'      => array(
			'label'    => esc_html__( 'Valencia', 'consulting' ),
			'slug'     => 'valencia',
			'live_url' => 'valencia/',
			'builder'  => 'elementor',
		),
		'layout_kuala_lumpur'  => array(
			'label'    => esc_html__( 'Kuala Lumpur', 'consulting' ),
			'slug'     => 'kuala-lumpur',
			'live_url' => 'kuala-lumpur/',
			'builder'  => 'elementor',
		),
		'layout_atlanta'       => array(
			'label'    => esc_html__( 'Atlanta', 'consulting' ),
			'slug'     => 'atlanta',
			'live_url' => 'atlanta/',
			'builder'  => 'elementor',
		),
		'layout_manchester'    => array(
			'label'    => esc_html__( 'Manchester', 'consulting' ),
			'slug'     => 'manchester',
			'live_url' => 'manchester/',
			'builder'  => 'elementor',
		),
		'layout_jakarta'       => array(
			'label'    => esc_html__( 'Jakarta', 'consulting' ),
			'slug'     => 'jakarta',
			'live_url' => 'jakarta/',
		),
		'layout_geneva'        => array(
			'label'    => esc_html__( 'Geneva', 'consulting' ),
			'slug'     => 'geneva',
			'live_url' => 'geneva/',
		),
		'layout_liverpool'     => array(
			'label'    => esc_html__( 'Liverpool', 'consulting' ),
			'slug'     => 'liverpool',
			'live_url' => 'liverpool/',
		),
		'layout_budapest'      => array(
			'label'    => esc_html__( 'Budapest', 'consulting' ),
			'slug'     => 'budapest',
			'live_url' => 'budapest/',
		),
		'layout_ankara'        => array(
			'label'    => esc_html__( 'Ankara', 'consulting' ),
			'slug'     => 'ankara',
			'live_url' => 'ankara/',
		),
		'layout_osaka'         => array(
			'label'    => esc_html__( 'Osaka', 'consulting' ),
			'slug'     => 'osaka',
			'live_url' => 'osaka/',
		),
		'layout_barcelona'     => array(
			'label'    => esc_html__( 'Barcelona', 'consulting' ),
			'slug'     => 'barcelona',
			'live_url' => 'barcelona/',
		),
		'layout_melbourne'     => array(
			'label'    => esc_html__( 'Melbourne', 'consulting' ),
			'slug'     => 'melbourne',
			'live_url' => 'melbourne/',
		),
		'layout_lyon'          => array(
			'label'    => esc_html__( 'Lyon', 'consulting' ),
			'slug'     => 'lyon',
			'live_url' => 'lyon/',
		),
		'layout_stockholm'     => array(
			'label'    => esc_html__( 'Stockholm', 'consulting' ),
			'slug'     => 'stockholm',
			'live_url' => 'stockholm/',
		),
		'layout_lisbon'        => array(
			'label'    => esc_html__( 'Lisbon', 'consulting' ),
			'slug'     => 'lisbon',
			'live_url' => 'lisbon/',
		),
		'layout_berlin'        => array(
			'label'    => esc_html__( 'Berlin', 'consulting' ),
			'slug'     => 'berlin',
			'live_url' => 'berlin/',
		),
		'layout_los_angeles'   => array(
			'label'    => esc_html__( 'Los Angeles', 'consulting' ),
			'slug'     => 'los_angeles',
			'live_url' => 'los-angeles/',
		),
		'layout_zurich'        => array(
			'label'    => esc_html__( 'Zurich', 'consulting' ),
			'slug'     => 'zurich',
			'live_url' => 'zurich/',
		),
		'layout_mumbai'        => array(
			'label'    => esc_html__( 'Mumbai', 'consulting' ),
			'slug'     => 'mumbai',
			'live_url' => 'mumbai/',
		),
		'layout_2'             => array(
			'label'    => esc_html__( 'Shanghai', 'consulting' ),
			'slug'     => 'shanghai',
			'live_url' => 'five/',
		),
		'layout_new_delhi'     => array(
			'label'    => esc_html__( 'New Delhi', 'consulting' ),
			'slug'     => 'new_delhi',
			'live_url' => 'new-delhi/',
		),
		'layout_12'            => array(
			'label'    => esc_html__( 'Singapore', 'consulting' ),
			'slug'     => 'singapore',
			'live_url' => 'twelve/',
		),
		'layout_8'             => array(
			'label'    => esc_html__( 'Seoul', 'consulting' ),
			'slug'     => 'seoul',
			'live_url' => 'eight/',
		),
		'layout_6'             => array(
			'label'    => esc_html__( 'London', 'consulting' ),
			'slug'     => 'london',
			'live_url' => 'two/',
		),
		'layout_13'            => array(
			'label'    => esc_html__( 'Sao Paulo', 'consulting' ),
			'slug'     => 'sao_paulo',
			'live_url' => 'thirteen/',
		),
		'layout_brussels'      => array(
			'label'    => esc_html__( 'Brussels', 'consulting' ),
			'slug'     => 'brussels',
			'live_url' => 'brussels/',
		),
		'layout_3'             => array(
			'label'    => esc_html__( 'Tokyo', 'consulting' ),
			'slug'     => 'tokyo',
			'live_url' => 'seven/',
		),
		'layout_marseille'     => array(
			'label'    => esc_html__( 'Marseille', 'consulting' ),
			'slug'     => 'marseille',
			'live_url' => 'marseille/',
		),
		'layout_toronto'       => array(
			'label'    => esc_html__( 'Toronto', 'consulting' ),
			'slug'     => 'toronto',
			'live_url' => 'toronto/',
		),
		'layout_beijing'       => array(
			'label'    => esc_html__( 'Beijing', 'consulting' ),
			'slug'     => 'beijing',
			'live_url' => 'beijing/',
		),
		'layout_milan'         => array(
			'label'    => esc_html__( 'Milan', 'consulting' ),
			'slug'     => 'milan',
			'live_url' => 'milan/',
		),
		'layout_7'             => array(
			'label'    => esc_html__( 'Madrid', 'consulting' ),
			'slug'     => 'madrid',
			'live_url' => 'six/',
		),
		'layout_9'             => array(
			'label'    => esc_html__( 'Frankfurt', 'consulting' ),
			'slug'     => 'frankfurt',
			'live_url' => 'three/',
		),
		'layout_amsterdam'     => array(
			'label'    => esc_html__( 'Amsterdam', 'consulting' ),
			'slug'     => 'amsterdam',
			'live_url' => 'amsterdam/',
		),
		'layout_vienna'        => array(
			'label'    => esc_html__( 'Vienna', 'consulting' ),
			'slug'     => 'vienna',
			'live_url' => 'vienna/',
		),
		'layout_19'            => array(
			'label'    => esc_html__( 'Oslo', 'consulting' ),
			'slug'     => 'oslo',
			'live_url' => 'nineteen/',
		),
		'layout_4'             => array(
			'label'    => esc_html__( 'Sydney', 'consulting' ),
			'slug'     => 'sydney',
			'live_url' => 'nine/',
		),
		'layout_14'            => array(
			'label'    => esc_html__( 'Abu Dhabi', 'consulting' ),
			'slug'     => 'abu_dhabi',
			'live_url' => 'fourteen/',
		),
		'layout_5'             => array(
			'label'    => esc_html__( 'Moscow', 'consulting' ),
			'slug'     => 'moscow',
			'live_url' => 'four/',
		),
		'layout_15'            => array(
			'label'    => esc_html__( 'Dublin', 'consulting' ),
			'slug'     => 'dublin',
			'live_url' => 'fifteen/',
		),
		'layout_11'            => array(
			'label'    => esc_html__( 'Paris', 'consulting' ),
			'slug'     => 'paris',
			'live_url' => 'eleven/',
		),
		'layout_denver'        => array(
			'label'    => esc_html__( 'Denver', 'consulting' ),
			'slug'     => 'denver',
			'live_url' => 'denver/',
		),
		'layout_17'            => array(
			'label'    => esc_html__( 'Dubai', 'consulting' ),
			'slug'     => 'dubai',
			'live_url' => 'seventeen/',
		),
		'layout_davos'         => array(
			'label'    => esc_html__( 'Davos', 'consulting' ),
			'slug'     => 'davos',
			'live_url' => 'davos/',
		),
		'layout_istanbul'      => array(
			'label'    => esc_html__( 'Istanbul', 'consulting' ),
			'slug'     => 'istanbul',
			'live_url' => 'istanbul/',
		),
		'layout_20'            => array(
			'label'    => esc_html__( 'Rome', 'consulting' ),
			'slug'     => 'rome',
			'live_url' => 'twenty/',
		),
		'layout_san_francisco' => array(
			'label'    => esc_html__( 'San Francisco', 'consulting' ),
			'slug'     => 'san_francisco',
			'live_url' => 'san-francisco/',
		),
		'layout_10'            => array(
			'label'    => esc_html__( 'Hong Kong', 'consulting' ),
			'slug'     => 'hong_kong',
			'live_url' => 'ten/',
		),
		'layout_18'            => array(
			'label'    => esc_html__( 'Tehran', 'consulting' ),
			'slug'     => 'tehran',
			'live_url' => 'eighteen/',
		),
		'layout_16'            => array(
			'label'    => esc_html__( 'Tel Aviv', 'consulting' ),
			'slug'     => 'tel_aviv',
			'live_url' => 'sixteen/',
		),
		'layout_miami'         => array(
			'label'    => esc_html__( 'Miami', 'consulting' ),
			'slug'     => 'miami',
			'live_url' => 'miami/',
		),
	);
}

function consulting_theme_option_indents( $option_name ) {
	$theme_settings = get_option( 'consulting_settings', array() );
	$indents        = isset( $theme_settings[ $option_name ] ) ? $theme_settings[ $option_name ] : '';

	if ( ! empty( $indents ) ) {
		$indent_top    = isset( $indents['top'] ) ? $indents['top'] : '';
		$indent_right  = isset( $indents['right'] ) ? $indents['right'] : '';
		$indent_bottom = isset( $indents['bottom'] ) ? $indents['bottom'] : '';
		$indent_left   = isset( $indents['left'] ) ? $indents['left'] : '';
		$unit          = $indents['unit'];

		if ( '' !== ( $indent_top ) && '' !== ( $indent_right ) && '' !== ( $indent_bottom ) && '' !== ( $indent_left ) ) {
			$indents = $indent_top . $unit . ' ' . $indent_right . $unit . ' ' . $indent_bottom . $unit . ' ' . $indent_left . $unit;
		} else {
			$indents = '';
		}
	}

	return $indents;
}

function consulting_inline_styles() {
	$config        = consulting_config();
	$theme_options = get_option( 'consulting_settings', array() );

	ob_start();
	?>
	:root {
	--con_base_color: <?php echo esc_attr( ( 'skin_custom' === $theme_options['site_skin'] ) ? $theme_options['site_skin_base_color'] : $config['base_color'] ); ?>;
	--con_secondary_color: <?php echo esc_attr( ( 'skin_custom' === $theme_options['site_skin'] ) ? $theme_options['site_skin_secondary_color'] : $config['secondary_color'] ); ?>;
	--con_third_color: <?php echo esc_attr( ( 'skin_custom' === $theme_options['site_skin'] ) ? $theme_options['site_skin_third_color'] : $config['third_color'] ); ?>;
	--con_primary_font_family: <?php echo esc_attr( ( $theme_options['body_font_family']['font-family'] ) ? $theme_options['body_font_family']['font-family'] : $config['primary_font_family'] ); ?>;
	--con_secondary_font_family: <?php echo esc_attr( ( $theme_options['secondary_font_family']['font-family'] ) ? $theme_options['secondary_font_family']['font-family'] : $config['secondary_font_family'] ); ?>;
	}
	<?php
	$css = ob_get_contents();
	ob_end_clean();
	return $css;
}
