<?php
consulting_get_header();

$sidebar_type = consulting_theme_option( 'blog_sidebar_type', 'wp' );
if ( 'wp' === $sidebar_type ) {
	$sidebar_id = consulting_theme_option( 'blog_wp_sidebar', 'consulting-right-sidebar' );
} else {
	$sidebar_id = consulting_theme_option( 'blog_vc_sidebar' );
}

$structure = consulting_get_structure( $sidebar_id, $sidebar_type, consulting_theme_option( 'blog_sidebar_position', 'right' ), consulting_theme_option( 'blog_layout' ) );

echo consulting_filtered_output( $structure['content_before'] ); //phpcs:ignore
?>
	<div class="<?php echo esc_attr( $structure['class'] ); ?>">
		<?php
		$posts_class         = '';
		$paginate_links_data = paginate_links( array( 'type' => 'array' ) );

		if ( empty( $paginate_links_data ) ) {
			$posts_class .= ' no-paginate';
		}

		if ( is_tax( 'stm_event_category' ) ) {
			if ( 'grid' === consulting_blog_layout() ) {
				?>
				<div class="stm_events_grid cols_2">
					<?php
					if ( have_posts() ) {
						while ( have_posts() ) {
							the_post();
							get_template_part( 'partials/content-event', 'grid' );
						}
					} else {
						get_template_part( 'partials/content', 'none' );
					}
					?>
				</div>
			<?php } else { ?>
				<div class="stm_events_classic cols_4">
					<?php
					if ( have_posts() ) {
						while ( have_posts() ) {
							the_post();
							get_template_part( 'partials/content-event', 'classic' );
						}
					} else {
						get_template_part( 'partials/content', 'none' );
					}
					?>
					<div class="stm_events_list_form">
						<?php get_template_part( 'partials/content', 'event-list-form' ); ?>
					</div>
				</div>
				<?php
			}
		} else {
			?>
			<ul class="post_list_ul<?php echo esc_attr( $posts_class ); ?>">
				<?php
				if ( have_posts() ) {
					while ( have_posts() ) {
						the_post();
						if ( 'grid' === consulting_blog_layout() ) {
							get_template_part( 'partials/content', 'loop_grid' );
						} else {
							get_template_part( 'partials/content', 'loop_list' );
						}
					}
				} else {
					get_template_part( 'partials/content', 'none' );
				}
				?>
			</ul>
		<?php } ?>
	</div>
<?php
//phpcs:disable
echo paginate_links(
	array(
		'type'      => 'list',
		'prev_text' => '<i class="fa fa-chevron-left"></i>',
		'next_text' => '<i class="fa fa-chevron-right"></i>',
	)
);
//phpcs:enable
echo consulting_filtered_output( $structure['content_after'] ); //phpcs:ignore
wp_reset_postdata();

echo consulting_filtered_output( $structure['sidebar_before'] ); //phpcs:ignore

if ( $sidebar_id ) {
	if ( 'wp' === $sidebar_type ) {
		$sidebar = true;
	} else {
		$sidebar_query = new WP_Query(
			array(
				'p'         => $sidebar_id,
				'post_type' => 'stm_vc_sidebar',
			)
		);
	}
}

if ( isset( $sidebar_query->post ) ) {
	$sidebar = $sidebar_query->post;

	if ( 'vc' === $sidebar_type ) {
		$is_elementor_sidebar = consulting_is_elementor_page( $sidebar_id );

		if ( $is_elementor_sidebar && class_exists( 'Elementor\Plugin' ) ) {
			echo \Elementor\Plugin::$instance->frontend->get_builder_content( $sidebar_id ); //phpcs:ignore
		} else {
			?>
			<div class="sidebar-area stm_sidebar">
				<style type="text/css" scoped>
					<?php echo get_post_meta( $sidebar_id, '_wpb_shortcodes_custom_css', true ); //phpcs:ignore ?>
				</style>
				<?php

				if ( $sidebar_query->have_posts() ) {
					while ( $sidebar_query->have_posts() ) {
						$sidebar_query->the_post();
						echo apply_filters( 'the_content', $sidebar->post_content ); //phpcs:ignore
					}
				}

				wp_reset_postdata();
				?>
			</div>
			<?php
		}
	} else {
		?>
		<div class="sidebar-area default_widgets">
			<?php dynamic_sidebar( $sidebar_id ); ?>
		</div>
		<?php
	}
}

echo consulting_filtered_output( $structure['sidebar_after'] ); //phpcs:ignore

get_footer();
