<?php
defined( 'ABSPATH' ) || exit;

$stm_event_count = get_post_meta( get_the_ID(), 'stm_event_count', true );
$event_attended  = get_post_meta( get_the_ID(), 'event_attended', true );
if ( empty( $event_attended ) ) {
	$event_attended = 0;
}
wp_enqueue_style( 'fancybox' );
wp_enqueue_script( 'fancybox' );

$date_format = get_option( 'date_format' );
$time_format = get_option( 'time_format' );

// Date
$stm_event_date_start = get_post_meta( get_the_ID(), 'stm_event_date_start', true );
$stm_event_date_start = $stm_event_date_start && strlen( $stm_event_date_start ) > 3 ? consulting_normalize_meta_timestamp( $stm_event_date_start ) : 0;
$stm_event_date_end   = get_post_meta( get_the_ID(), 'stm_event_date_end', true );
$stm_event_date_end   = $stm_event_date_end && strlen( $stm_event_date_end ) > 3 ? consulting_normalize_meta_timestamp( $stm_event_date_end ) : 0;
$today                = wp_date( 'Ymd' );

// Time - Number
$stm_event_time_end   = get_post_meta( get_the_ID(), 'stm_event_time_end', true );
$stm_event_time_start = get_post_meta( get_the_ID(), 'stm_event_time_start', true );

// Venue
$stm_event_venue = get_post_meta( get_the_ID(), 'stm_event_venue', true );

// Time - Text
$stm_event_time_text = get_post_meta( get_the_ID(), 'stm_event_time_text', true );
?>

<div class="item">
	<input type="hidden" class="event-item-id" value="<?php echo esc_html( get_the_ID() ); ?>" />
	<div class="item_wr">
		<div class="content">
			<h4><?php the_title(); ?></h4>
			<ul class="stm-event__meta">
				<?php if ( ! empty( $stm_event_date_start ) ) : ?>
					<li>
						<div class="event__calendar">
							<i class="fa fa-calendar" aria-hidden="true"></i>
							<?php echo esc_html( date_i18n( $date_format, $stm_event_date_start ) ); ?>
						</div>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $stm_event_time_text ) ) : ?>
					<li>
						<div class="event__time">
							<i class="fa fa-clock-o"></i> <?php echo esc_html( $stm_event_time_text ); ?>
						</div>
					</li>
				<?php else : ?>
					<?php if ( ! empty( $stm_event_time_start ) || ! empty( $stm_event_time_end ) ) : ?>
						<li>
							<div class="event__time"><i class="fa fa-clock-o"></i>
								<?php
								if ( ! empty( $stm_event_time_start ) && ! empty( $stm_event_time_end ) ) {
									/* translators: %s time start, %s time end */
									printf( esc_html__( '%1$s to %2$s', 'consulting' ), esc_html( date_i18n( $time_format, $stm_event_time_start ) ), esc_html( date_i18n( $time_format, $stm_event_time_end ) ) );
								} elseif ( empty( $stm_event_time_start ) ) {
									echo esc_html( date_i18n( $time_format, $stm_event_time_end ) );
								} elseif ( empty( $stm_event_time_end ) ) {
									echo esc_html( date_i18n( $time_format, $stm_event_time_start ) );
								}
								?>
							</div>
						</li>
					<?php endif; ?>
				<?php endif; ?>
				<?php if ( ! empty( $stm_event_venue ) ) : ?>
					<li>
						<div class="event__venue">
							<i class="fa fa-map-marker" aria-hidden="true"></i> <?php echo esc_html( $stm_event_venue ); ?>
						</div>
					</li>
				<?php endif; ?>
			</ul>
		</div>
		<?php if ( has_post_thumbnail() ) : ?>
			<div class="item_thumbnail">
				<?php
				echo wp_kses(
					consulting_get_image( get_post_thumbnail_id(), empty( $img_size ) ? 'consulting-image-700x390-croped' : $img_size ),
					array(
						'img' => array(
							'src'           => true,
							'srcset'        => true,
							'sizes'         => true,
							'alt'           => true,
							'class'         => true,
							'width'         => true,
							'height'        => true,
							'loading'       => true,
							'decoding'      => true,
							'fetchpriority' => true,
						),
					)
				);
				?>
			</div>
		<?php endif; ?>
		<div class="event_read_more">
			<a class="button bordered icon_right" href="<?php the_permalink(); ?>">
				<?php esc_html_e( 'read more', 'consulting' ); ?>
				<i class="fa fa-chevron-right"></i>
			</a>
		</div>
		<div class="event_joining_count_box">
			<?php if ( date_i18n( 'Ymd', $stm_event_date_end ) < $today ) : ?>
				<div class="event_joining">
					<span class="vc_general disabled vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-outline vc_btn3-color-theme_style_4">
						<?php esc_html_e( 'past event', 'consulting' ); ?>
					</span>
				</div>
			<?php elseif ( $event_attended < $stm_event_count || empty( $stm_event_count ) ) : ?>
				<div class="event_joining">
					<a href="javascript:void(0);" class="vc_general show_event_list_form vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-outline vc_btn3-color-theme_style_4">
						<?php esc_html_e( 'i am going', 'consulting' ); ?>
					</a>
				</div>
			<?php else : ?>
				<div class="event_joining">
				<span class="vc_general disabled vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-outline vc_btn3-color-theme_style_4">
					<?php esc_html_e( 'fully booked', 'consulting' ); ?>
				</span>
				</div>
			<?php endif; ?>
			<div class="event_joining_count">
				<i class="fa fa-angle-left" aria-hidden="true"></i>
				<span class="event-attended-count"><?php echo esc_html( $event_attended ); ?></span>
			</div>
		</div>
	</div>
</div>
