<?php
defined( 'ABSPATH' ) || exit;

$stm_event_count = get_post_meta( get_the_ID(), 'stm_event_count', true );
$event_attended  = get_post_meta( get_the_ID(), 'event_attended', true );
if ( empty( $event_attended ) ) {
	$event_attended = 0;
}

$date_format = get_option( 'date_format' );
$time_format = get_option( 'time_format' );

// Date
$stm_event_date_start = get_post_meta( get_the_ID(), 'stm_event_date_start', true );
$stm_event_date_start = $stm_event_date_start && strlen( $stm_event_date_start ) > 3 ? consulting_normalize_meta_timestamp( $stm_event_date_start ) : 0;
$stm_event_date_end   = get_post_meta( get_the_ID(), 'stm_event_date_end', true );
$stm_event_date_end   = $stm_event_date_end && strlen( $stm_event_date_end ) > 3 ? consulting_normalize_meta_timestamp( $stm_event_date_end ) : 0;
$today                = wp_date( 'Ymd' );

// Time - Number
$stm_event_time_end   = get_post_meta( get_the_ID(), 'stm_event_time_end', true );
$stm_event_time_start = get_post_meta( get_the_ID(), 'stm_event_time_start', true );

// Time - Text
$stm_event_time_text = get_post_meta( get_the_ID(), 'stm_event_time_text', true );

// Venue
$stm_event_venue = get_post_meta( get_the_ID(), 'stm_event_venue', true );

$stm_event_tel = get_post_meta( get_the_ID(), 'stm_event_tel', true );

$stm_event_month_start = date_i18n( $date_format, $stm_event_date_start );
$stm_event_month_end   = date_i18n( $date_format, $stm_event_date_end );
$stm_event_date        = '';

if ( $stm_event_month_start === $stm_event_month_end ) {
	$stm_event_date .= $stm_event_month_start;
} else {
	$stm_event_date .= $stm_event_month_start . ' - ' . $stm_event_month_end;
}
?>

<h2><?php consulting_page_title(); ?></h2>
<?php if ( has_post_thumbnail() ) : ?>
	<div class="item_thumbnail">
		<?php
		echo wp_kses(
			consulting_get_image( get_post_thumbnail_id(), 'full' ),
			array(
				'img' => array(
					'src'           => true,
					'srcset'        => true,
					'sizes'         => true,
					'alt'           => true,
					'class'         => true,
					'width'         => true,
					'height'        => true,
					'loading'       => true,
					'decoding'      => true,
					'fetchpriority' => true,
				),
			)
		);
		?>
	</div>
<?php endif; ?>
<div class="event_info_table">
	<?php if ( ! empty( $stm_event_date_start ) || ! empty( $stm_event_time_start ) || ! empty( $stm_event_time_text ) ) : ?>
		<div class="event_info">
			<ul class="event-info__datetime" style="min-width: 134px;">
				<?php if ( ! empty( $stm_event_date ) ) : ?>
					<li>
						<i class="fa fa-calendar" aria-hidden="true"></i>
						<?php echo esc_html( $stm_event_date ); ?>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $stm_event_time_text ) ) : ?>
					<li>
						<i class="fa fa-clock-o"></i>
						<?php echo esc_html( $stm_event_time_text ); ?>
					</li>
				<?php else : ?>
					<?php if ( ! empty( $stm_event_time_start ) || ! empty( $stm_event_time_end ) ) : ?>
						<li>
							<i class="fa fa-clock-o"></i>
							<?php
							if ( ! empty( $stm_event_time_start ) && ! empty( $stm_event_time_end ) ) {
								/* translators: %s time start, %s time end */
								printf( esc_html__( '%1$s to %2$s', 'consulting' ), esc_html( date_i18n( $time_format, $stm_event_time_start ) ), esc_html( date_i18n( $time_format, $stm_event_time_end ) ) );
							} elseif ( empty( $stm_event_time_start ) ) {
								echo esc_html( date_i18n( $time_format, $stm_event_time_end ) );
							} elseif ( empty( $stm_event_time_end ) ) {
								echo esc_html( date_i18n( $time_format, $stm_event_time_start ) );
							} elseif ( $stm_event_time_start === $stm_event_time_end ) {
								echo esc_html( date_i18n( $time_format, $stm_event_time_start ) );
							}
							?>
						</li>
					<?php endif; ?>
				<?php endif; ?>
			</ul>
		</div>
	<?php endif; ?>
	<?php if ( ! empty( $stm_event_venue ) || ! empty( $stm_event_tel ) ) : ?>
		<div class="event_info">
			<ul>
				<?php if ( ! empty( $stm_event_venue ) ) : ?>
					<li>
						<i class="fa fa-map-marker" aria-hidden="true"></i>
						<?php echo esc_html( $stm_event_venue ); ?>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $stm_event_tel ) ) : ?>
					<li>
						<?php
						$stm_event_tel = explode( ';', $stm_event_tel );
						foreach ( $stm_event_tel as $stm_event_tel_val ) :
							?>
							<i class="fa fa-phone" aria-hidden="true"></i>
							<?php echo esc_html( $stm_event_tel_val ); ?>
						<?php endforeach; ?>
					</li>
				<?php endif; ?>
			</ul>
		</div>
	<?php endif; ?>
	<?php if ( $event_attended < $stm_event_count || empty( $stm_event_count ) && date_i18n( 'Ymd', $stm_event_date_end ) > $today ) : ?>
		<div class="event_info text-right">
			<a href="#event-form-box" class="vc_general scroll_to_event_form vc_btn3 vc_btn3-size-lg vc_btn3-shape-rounded vc_btn3-style-flat vc_btn3-icon-right vc_btn3-color-theme_style_3">
				<?php esc_html_e( 'join now', 'consulting' ); ?>
				<i class="vc_btn3-icon fa fa-chevron-right"></i>
			</a>
		</div>
	<?php endif; ?>
</div>
