<?php
defined( 'ABSPATH' ) || exit;

// Date
$stm_event_date_start = get_post_meta( get_the_ID(), 'stm_event_date_start', true );
$stm_event_date_start = $stm_event_date_start && strlen( $stm_event_date_start ) > 3 ? consulting_normalize_meta_timestamp( $stm_event_date_start ) : 0;

// Venue
$stm_event_venue = get_post_meta( get_the_ID(), 'stm_event_venue', true );

$date_format        = get_option( 'date_format' );
$stm_event_speakers = get_post_meta( get_the_ID(), 'stm_event_speakers', true );
?>
<div class="item">
	<div class="item_wr">
		<div class="content">
			<div class="stm_events_modern_row">
				<h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
			</div>
			<?php if ( ! empty( $stm_event_speakers ) ) : ?>
				<div class="stm_events_modern_row">
					<?php
					$stm_event_speakers = json_decode( $stm_event_speakers, true );

					if ( is_array( $stm_event_speakers ) ) {
						$stm_event_speakers = array_filter(
							$stm_event_speakers,
							function( $speaker ) {
								return ! empty( $speaker );
							}
						);
					} else {
						$stm_event_speakers = array();
					}

					foreach ( $stm_event_speakers as $stm_event_speaker ) :
						$speaker_id = $stm_event_speaker['value'] ?? 0;
						if ( empty( $speaker_id ) ) {
							continue;
						}

						$thumbnail_id     = get_post_thumbnail_id( $speaker_id );
						$stm_event_venues = get_post_meta( $speaker_id, 'department', true )
						?>
						<div class="event_speaker_row">
							<div class="event_speaker_thumbnail">
								<?php
								echo wp_kses(
									consulting_get_image( $thumbnail_id, empty( $img_size ) ? 'consulting-image-700x390-croped' : $img_size ),
									array(
										'img' => array(
											'src'      => true,
											'srcset'   => true,
											'sizes'    => true,
											'alt'      => true,
											'class'    => true,
											'width'    => true,
											'height'   => true,
											'loading'  => true,
											'decoding' => true,
											'fetchpriority' => true,
										),
									)
								);
								?>
							</div>
							<div class="event_speaker_content">
								<?php if ( ! empty( $stm_event_venues ) ) : ?>
									<div class="event_speaker_description">
										<?php echo esc_html( $stm_event_venues ); ?>
									</div>
								<?php endif; ?>
								<div class="event_speaker_name">
									<a href="<?php the_permalink( $speaker_id ); ?>">
										<?php echo esc_html( get_the_title( $speaker_id ) ); ?>
									</a>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>
			<?php if ( ! empty( $stm_event_date_start ) ) : ?>
				<div class="stm_events_modern_row">
					<div class="event__calendar">
						<i class="fa fa-calendar" aria-hidden="true"></i>
						<?php echo esc_html( date_i18n( $date_format, $stm_event_date_start ) ); ?>
					</div>
				</div>
			<?php endif; ?>
			<?php if ( ! empty( $stm_event_venue ) ) : ?>
				<div class="stm_events_modern_row">
					<div class="event__venue">
						<i class="fa fa-map-marker" aria-hidden="true"></i>
						<?php echo esc_html( $stm_event_venue ); ?>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
