<?php
defined( 'ABSPATH' ) || exit;

$date_format = get_option( 'date_format' );
$time_format = get_option( 'time_format' );

// Date
$stm_event_date_start = get_post_meta( get_the_ID(), 'stm_event_date_start', true );
$stm_event_date_start = $stm_event_date_start && strlen( $stm_event_date_start ) > 3 ? consulting_normalize_meta_timestamp( $stm_event_date_start ) : 0;

// Time - Number
$stm_event_time_end   = get_post_meta( get_the_ID(), 'stm_event_time_end', true );
$stm_event_time_start = get_post_meta( get_the_ID(), 'stm_event_time_start', true );

// Venue
$stm_event_venue = get_post_meta( get_the_ID(), 'stm_event_venue', true );

// Time - Text
$stm_event_time_text = get_post_meta( get_the_ID(), 'stm_event_time_text', true );
?>

<div class="item">
	<div class="item_wr">
		<div class="content">
			<h6><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>
			<ul class="stm-event__meta">
				<?php if ( ! empty( $stm_event_date_start ) ) : ?>
					<li>
						<div class="event__calendar">
							<i class="fa fa-calendar" aria-hidden="true"></i>
							<?php echo esc_html( date_i18n( $date_format, $stm_event_date_start ) ); ?>
						</div>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $stm_event_time_text ) ) : ?>
					<li>
						<div class="event__time">
							<i class="fa fa-clock-o"></i>
							<?php echo esc_html( $stm_event_time_text ); ?>
						</div>
					</li>
				<?php else : ?>
					<?php if ( ! empty( $stm_event_time_start ) || ! empty( $stm_event_time_end ) ) : ?>
						<li>
							<div class="event__time">
								<i class="fa fa-clock-o"></i>
								<?php
								if ( ! empty( $stm_event_time_start ) && ! empty( $stm_event_time_end ) ) {
									/* translators: %s time start, %s time end */
									printf( esc_html__( '%1$s to %2$s', 'consulting' ), esc_html( date_i18n( $time_format, $stm_event_time_start ) ), esc_html( date_i18n( $time_format, $stm_event_time_end ) ) );
								} elseif ( empty( $stm_event_time_start ) ) {
									echo esc_html( date_i18n( $time_format, $stm_event_time_end ) );
								} elseif ( empty( $stm_event_time_end ) ) {
									echo esc_html( date_i18n( $time_format, $stm_event_time_start ) );
								}
								?>
							</div>
						</li>
					<?php endif; ?>
				<?php endif; ?>
				<?php if ( ! empty( $stm_event_venue ) ) : ?>
					<li>
						<div class="event__venue">
							<i class="fa fa-map-marker" aria-hidden="true"></i>
							<?php echo esc_html( $stm_event_venue ); ?>
						</div>
					</li>
				<?php endif; ?>
			</ul>
		</div>
	</div>
</div>
