<?php
$vc_status    = get_post_meta( get_the_ID(), '_wpb_vc_js_status', true );
$is_elementor = consulting_is_elementor_page( get_the_ID() );
if ( $is_elementor ) {
	$vc_status = 1;
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-content consulting_elementor_wrapper">
		<?php
		if ( 'false' !== $vc_status && $vc_status ) :

			if ( is_singular( 'stm_event' ) ) {
				echo '<div class="event_content ">';
				the_content();
				echo '</div>';
			} else {
				the_content();
			}
		else :
			if ( is_singular( 'stm_event' ) ) :
				$sidebar_type = consulting_theme_option( 'event_sidebar_type', 'wp' );
				if ( 'wp' === $sidebar_type ) {
					$sidebar_id = consulting_theme_option( 'event_wp_sidebar', 'consulting-right-sidebar' );
				} else {
					$sidebar_id = consulting_theme_option( 'event_vc_sidebar' );
				}
				if ( ! empty( $_GET['sidebar_id'] ) ) {
					$sidebar_id = sanitize_text_field( $_GET['sidebar_id'] );
				}
				$structure = consulting_get_structure( $sidebar_id, $sidebar_type, consulting_theme_option( 'blog_sidebar_position', 'right' ), consulting_theme_option( 'blog_layout' ) );
				echo consulting_filtered_output( $structure['content_before'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				?>
				<div class="without_vc">
					<div class="event_content">
						<?php
						get_template_part( 'partials/content', 'event-info' );
						the_content();
						get_template_part( 'partials/content', 'event-form' );
						?>
					</div>
				</div>
				<?php
				echo consulting_filtered_output( $structure['content_after'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo consulting_filtered_output( $structure['sidebar_before'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				if ( $sidebar_id ) {
					if ( 'wp' === $sidebar_type ) {
						$sidebar = true;
					} else {
						$sidebar = get_post( $sidebar_id );
					}
				}
				if ( isset( $sidebar ) ) {
					if ( 'vc' === $sidebar_type ) {
						$is_elementor_sidebar = consulting_is_elementor_page( $sidebar_id );
						if ( $is_elementor_sidebar && class_exists( 'Elementor\Plugin' ) ) :
							echo \Elementor\Plugin::$instance->frontend->get_builder_content( $sidebar_id ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						else :
							?>
							<style type="text/css" scoped>
								<?php echo get_post_meta( $sidebar_id, '_wpb_shortcodes_custom_css', true ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</style>
							<div class="sidebar-area stm_sidebar">
								<?php echo apply_filters( 'the_content', $sidebar->post_content ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</div>
							<?php
						endif;
					} else {
						?>
						<div class="sidebar-area default_widgets">
							<?php dynamic_sidebar( $sidebar_id ); ?>
						</div>
						<?php
					}
				}
				echo consulting_filtered_output( $structure['sidebar_after'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			else :
				$sidebar_type = consulting_theme_option( 'blog_sidebar_type', 'wp' );
				if ( 'wp' === $sidebar_type ) {
					$sidebar_id = consulting_theme_option( 'blog_wp_sidebar', 'consulting-right-sidebar' );
				} else {
					$sidebar_id = consulting_theme_option( 'blog_vc_sidebar' );
				}
				if ( ! empty( $_GET['sidebar_id'] ) ) {
					$sidebar_id = sanitize_text_field( $_GET['sidebar_id'] );
				}
				$structure = consulting_get_structure( $sidebar_id, $sidebar_type, consulting_theme_option( 'blog_sidebar_position', 'right' ), consulting_theme_option( 'blog_layout' ) );
				echo consulting_filtered_output( $structure['content_before'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				?>
				<div class="without_vc">
					<?php
					if ( 'off' !== get_post_meta( get_the_ID(), 'disable_title', true ) ) :
						the_title( '<h1 class="h2 no_stripe page_title_2">', '</h1>' );
					endif;
					?>
					<div class="post_details_wr">
						<?php get_template_part( 'partials/content', 'post_details' ); ?>
					</div>
					<div class="wpb_text_column">
						<?php the_content(); ?>
					</div>
					<br/>
					<br/>
					<?php
					get_template_part( 'partials/content', 'post_bottom' );
					get_template_part( 'partials/content', 'about_author' );

					wp_link_pages(
						array(
							'before'      => '<div class="page-links"><label>' . esc_html__( 'Pages:', 'consulting' ) . '</label>',
							'after'       => '</div>',
							'link_before' => '<span>',
							'link_after'  => '</span>',
							'pagelink'    => '%',
							'separator'   => '',
						)
					);

					if ( comments_open() || get_comments_number() ) :
						?>
						<div class="stm_post_comments">
							<?php comments_template(); ?>
						</div>
					<?php endif; ?>
				</div>
				<?php
				echo consulting_filtered_output( $structure['content_after'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo consulting_filtered_output( $structure['sidebar_before'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				if ( $sidebar_id ) {
					if ( 'wp' === $sidebar_type ) {
						$sidebar = true;
					} else {
						$sidebar = get_post( $sidebar_id );
					}
				}
				if ( isset( $sidebar ) ) {
					if ( 'vc' === $sidebar_type ) {
						$is_elementor_sidebar = consulting_is_elementor_page( $sidebar_id );
						if ( $is_elementor_sidebar && class_exists( 'Elementor\Plugin' ) ) :
							echo \Elementor\Plugin::$instance->frontend->get_builder_content( $sidebar_id ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						else :
							?>
							<style type="text/css" scoped>
								<?php echo get_post_meta( $sidebar_id, '_wpb_shortcodes_custom_css', true ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</style>
							<div class="sidebar-area stm_sidebar">
								<?php echo apply_filters( 'the_content', $sidebar->post_content ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</div>
							<?php
						endif;
					} else {
						?>
						<div class="sidebar-area default_widgets">
							<?php dynamic_sidebar( $sidebar_id ); ?>
						</div>
						<?php
					}
				}
				echo consulting_filtered_output( $structure['sidebar_after'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			endif;
		endif;
		?>
	</div>
</article> <!-- #post-## -->
