<?php
$consulting_config = consulting_config();
$logo_tmp_src      = '';
if ( ! empty( $consulting_config['layout'] ) && 'layout_1' !== $consulting_config['layout'] && 'layout_12' !== $consulting_config['layout'] ) {
	$logo_tmp_src = $consulting_config['layout'] . '/';
}
$wc_cart_hide = consulting_theme_option( 'wc_cart_hide', false );
?>

<div class="top_nav">
	<div class="container">
		<div class="top_nav_wrapper clearfix">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'consulting-primary_menu',
					'container'      => false,
					'depth'          => 4,
					'menu_class'     => 'main_menu_nav',
				)
			);

			if ( class_exists( 'WooCommerce' ) && ! $wc_cart_hide ) :
				?>
				<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="cart_count"><i class="stm-cart_13"></i><span
							class="count"><?php echo esc_html( WC()->cart->get_cart_contents_count() ); ?></span></a>
			<?php endif; ?>
		</div>
	</div>
</div>
<div class="header_top clearfix">
	<div class="container">
		<?php
		$header_working_hours = consulting_theme_option( 'header_working_hours', esc_html__( 'Write us', 'consulting' ) . '<a href="mailto:info@consulting.com">info@consulting.com</a>' );

		$header_phone = consulting_theme_option( 'header_phone', '<strong>212 386 5575</strong><span data-popup="request-call-back">' . esc_html__( 'Request a call back', 'consulting' ) . '</span>' );

		if ( ! empty( $header_phone ) ) :
			$header_popup = consulting_theme_option( 'header_popup', 'none' );
			if ( 'none' !== $header_popup ) :
				?>
				<a href="#stm_header_popup" class="stm_fancybox">
			<?php endif; ?>
			<div class="stm_l14_h5-phone">
				<div class="icon"><?php echo consulting_get_icon( 'header_phone_icon', 'stm-phone_13' ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
				<div class="text">
					<?php
					echo wp_kses(
						nl2br( $header_phone ),
						array(
							'br'     => array(),
							'strong' => array(),
							'span'   => array(
								'data-popup'     => array(),
								'data-scroll-to' => array(),
							),
							'a'      => array( 'href' => array() ),
						)
					);
					?>
				</div>
			</div>
			<?php if ( 'none' !== $header_popup ) : ?>
				</a>
				<div id="stm_header_popup">
					<?php
					$cf7 = get_post( $header_popup );
					echo( do_shortcode( '[contact-form-7 id="' . $cf7->ID . '" title="' . ( $cf7->post_title ) . '"]' ) );
					?>
				</div>
				<?php
			endif;
			endif;
		?>

		<div class="stm_l14_h5-right">
			<div class="clearfix">
				<div class="logo">
					<?php
					$page_ID        = consulting_page_id();
					$header_inverse = 'default' === get_post_meta( $page_ID, 'header_inverse', true ) && ! consulting_theme_option( 'header_inverse' ) ? 'off' : get_post_meta( $page_ID, 'header_inverse', true );
					$logo           = consulting_get_logo_url( 'logo', get_template_directory_uri() . '/assets/images/tmp/' . $logo_tmp_src . 'logo_default.svg' );
					$dark_logo      = consulting_get_logo_url( 'dark_logo', get_template_directory_uri() . '/assets/images/tmp/' . $logo_tmp_src . 'logo_dark.svg' );
					if ( 'on' === $header_inverse && $logo ) :
						?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $logo ); ?>" style="width: <?php echo esc_attr( consulting_theme_option( 'logo_width' ) ); ?>px; height: <?php echo esc_attr( consulting_theme_option( 'logo_height' ) ); ?>px;" alt="<?php bloginfo( 'name' ); ?>"/></a>
					<?php elseif ( $dark_logo ) : ?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $dark_logo ); ?>" style="width: <?php echo esc_attr( consulting_theme_option( 'logo_width' ) ); ?>px; height: <?php echo esc_attr( consulting_theme_option( 'logo_height' ) ); ?>px;" alt="<?php bloginfo( 'name' ); ?>"/></a>
					<?php else : ?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>
					<?php endif; ?>
				</div>

				<?php if ( ! empty( $header_working_hours ) ) : ?>
					<div class="stm_l14_h5-wh">
						<div class="icon"><?php echo consulting_get_icon( 'header_working_hours_icon', 'stm-phone_13' ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
						<div class="text">
							<?php
							echo wp_kses(
								nl2br( $header_working_hours ),
								array(
									'br'     => array(),
									'strong' => array(),
									'span'   => array(),
									'a'      => array( 'href' => array() ),
								)
							);
							?>
						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>

<div class="mobile_header">
	<div class="logo_wrapper clearfix">
		<div class="logo">
			<?php
			$logo = consulting_get_logo_url( 'dark_logo', get_template_directory_uri() . '/assets/images/tmp/' . $logo_tmp_src . 'logo_dark.svg' );
			if ( $logo ) :
				?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $logo ); ?>" style="width: <?php echo esc_attr( consulting_theme_option( 'logo_width' ) ); ?>px; height: <?php echo esc_attr( consulting_theme_option( 'logo_height' ) ); ?>px;" alt="<?php bloginfo( 'name' ); ?>"/></a>
			<?php else : ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>
			<?php endif; ?>
		</div>
		<div id="menu_toggle">
			<button></button>
		</div>
	</div>
	<div class="header_info">
		<div class="top_nav_mobile">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'consulting-primary_menu',
					'container'      => false,
					'depth'          => 4,
					'menu_class'     => 'main_menu_nav',
				)
			);
			?>
		</div>
		<div class="icon_texts">
			<?php if ( ! empty( $header_phone ) ) : ?>
				<div class="icon_text clearfix">
					<?php
					$header_popup = consulting_theme_option( 'header_popup', 'none' );
					if ( 'none' !== $header_popup ) :
						?>
					<a href="#stm_header_popup" class="stm_fancybox">
						<?php endif; ?>
						<div class="icon"><?php echo consulting_get_icon( 'header_phone_icon', 'stm-phone_13' ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
						<div class="text">
							<?php
							echo wp_kses(
								nl2br( $header_phone ),
								array(
									'br'     => array(),
									'strong' => array(),
									'span'   => array(
										'data-popup'     => array(),
										'data-scroll-to' => array(),
									),
									'a'      => array( 'href' => array() ),
								)
							);
							?>
						</div>
						<?php if ( 'none' !== $header_popup ) : ?>
					</a>
				<?php endif; ?>
				</div>
				<?php
			endif;
			$header_hours = consulting_theme_option( 'header_working_hours', "<strong>Mon - Sat 8.00 - 18.00</strong>\n<span>Sunday CLOSED</span>" );
			if ( $header_hours ) :
				?>
				<div class="icon_text clearfix">
					<div class="icon"><?php echo consulting_get_icon( 'header_working_hours_icon', 'fa-clock-o' ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
					<div class="text">
						<?php
						echo wp_kses(
							nl2br( $header_hours ),
							array(
								'br'     => array(),
								'strong' => array(),
								'span'   => array(),
							)
						);
						?>
					</div>
				</div>
				<?php
			endif;
			$header_address = consulting_theme_option( 'header_address', "<strong>1010 Avenue of the Moon</strong>\n<span>New York, NY 10018 US.</span>" );
			if ( $header_address ) :
				?>
				<div class="icon_text clearfix">
					<div class="icon"><?php echo consulting_get_icon( 'header_address_icon', 'fa-map-marker' ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
					<div class="text">
						<?php
						echo wp_kses(
							nl2br( $header_address ),
							array(
								'br'     => array(),
								'strong' => array(),
								'span'   => array(),
							)
						);
						?>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
