<?php
/**
 * @var $events_filter
 * @var $category
 * @var $event_style
 * @var $posts_per_page
 * @var $posts_per_row
 * @var $img_size
 * @var $pagination_enable
 * @var $load_more_enable
 * @var $css_class
 */

$css_class .= ' cols_' . $posts_per_row;

$args         = array(
	'post_type'      => 'stm_event',
	'posts_per_page' => $posts_per_page,
	'paged'          => get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1,
	'orderby'        => 'meta_value_num',
	'meta_key'       => 'stm_event_date_start',
	'post_status'    => 'publish',
	'order'          => 'ASC',
);
$current_time = time();
$midnight     = strtotime( 'midnight', $current_time );
$today        = wp_date( 'd-m-Y' );

if ( 'upcoming' === $events_filter ) {
	$args['meta_query'][] = array(
		'relation' => 'AND',
		array(
			'key'     => 'stm_event_date_start',
			'value'   => $midnight,
			'compare' => '>=',
			'type'    => 'NUMERIC',
		),
		array(
			'key'     => 'stm_event_date_start',
			'compare' => 'EXISTS',
		),
		array(
			'key'     => 'stm_event_date_start',
			'value'   => '',
			'compare' => '!=',
		),
	);
} elseif ( 'past' === $events_filter ) {
	$args['meta_query'][] = array(
		'relation' => 'AND',
		array(
			'key'     => 'stm_event_date_end',
			'value'   => $current_time,
			'compare' => '<=',
		),
		array(
			'key'     => 'stm_event_date_end',
			'compare' => 'EXISTS',
		),
		array(
			'key'     => 'stm_event_date_end',
			'value'   => '',
			'compare' => '!=',
		),
	);
} elseif ( 'current' === $events_filter ) {
	$args['meta_query'][] = array(
		'relation' => 'AND',
		array(
			'key'     => 'stm_event_date_start',
			'value'   => $midnight,
			'compare' => '<=',
		),
		array(
			'key'     => 'stm_event_date_end',
			'value'   => $current_time,
			'compare' => '>=',
		),
	);
}

if ( 'all' !== $category ) {
	$args['stm_event_category'] = $category;
}

$events = new WP_Query( $args );

$published_posts = $events->found_posts;
?>

<?php if ( $events->have_posts() ) : ?>
	<?php if ( 'grid' === $event_style ) : ?>
		<div class="stm_events_grid<?php echo esc_attr( $css_class ); ?>">
			<?php
			while ( $events->have_posts() ) :
				$events->the_post();

				// Date
				$stm_event_date_start = get_post_meta( get_the_ID(), 'stm_event_date_start', true );
				$stm_event_date_start = $stm_event_date_start && strlen( $stm_event_date_start ) > 3 ? consulting_normalize_meta_timestamp( $stm_event_date_start ) : 0;
				$stm_event_date_end   = get_post_meta( get_the_ID(), 'stm_event_date_end', true );
				$stm_event_date_end   = $stm_event_date_end && strlen( $stm_event_date_end ) > 3 ? consulting_normalize_meta_timestamp( $stm_event_date_end ) : 0;

				// Time - Number
				$stm_event_time_end   = get_post_meta( get_the_ID(), 'stm_event_time_end', true );
				$stm_event_time_start = get_post_meta( get_the_ID(), 'stm_event_time_start', true );

				if (
					(
						'upcoming' === $events_filter &&
						wp_date( 'd-m-Y', $stm_event_date_start ) === $today &&
						strtotime( $stm_event_time_start ) < $midnight
					)
					||
					(
						'past' === $events_filter &&
						wp_date( 'd-m-Y', $stm_event_date_end ) === $today &&
						strtotime( $stm_event_time_end ) > $current_time
					)
				) {
					continue;
				}

				get_template_part( 'partials/content-event', 'grid' );

			endwhile;
			?>
		</div>
		<?php if ( $pagination_enable ) : ?>
			<div class="events_pagination">
				<?php consulting_paging_nav( 'paging_view_posts-list', $events ); ?>
			</div>
			<?php
			endif;
		wp_reset_postdata();
		?>
	<?php elseif ( 'classic' === $event_style ) : ?>
		<div class="stm_events_classic<?php echo esc_attr( $css_class ); ?>">
			<?php
			while ( $events->have_posts() ) :
				$events->the_post();
				get_template_part( 'partials/content-event', 'classic' );
			endwhile;
			?>
			<div class="stm_events_list_form">
				<?php get_template_part( 'partials/content', 'event-list-form' ); ?>
			</div>
			<?php if ( $pagination_enable ) : ?>
				<div class="events_pagination">
					<?php consulting_paging_nav( 'paging_view_posts-list', $events ); ?>
				</div>
				<?php
				endif;
			wp_reset_postdata();
			?>
		</div>
		<?php wp_reset_postdata(); ?>
		<?php
	elseif ( 'modern' === $event_style ) :
		$post_cat = array();
		?>
		<div class="stm_events_modern<?php echo esc_attr( $css_class ); ?>">
			<div class="stm_events_modern_list">
				<?php
				while ( $events->have_posts() ) :
					$events->the_post();

					get_template_part( 'partials/content-event', 'modern' );
					$post_cat = wp_get_post_terms( get_the_ID(), 'stm_event_category' );

				endwhile;
				?>
			</div>
			<?php wp_reset_postdata(); ?>
			<?php if ( 'all' !== $category ) : ?>
				<?php if ( $load_more_enable && ! empty( $post_cat ) && $posts_per_page < $post_cat[0]->count ) : ?>
					<div class="event_btn_loading vc_general vc_btn3 vc_btn3-size-lg vc_btn3-shape-rounded vc_btn3-style-outline vc_btn3-icon-left vc_btn3-color-theme_style_2">
						<?php esc_html_e( 'loading...', 'consulting' ); ?>
					</div>
					<a href="#"
						data-page="1"
						data-load="<?php echo absint( $posts_per_page ); ?>"
						data-category="<?php echo esc_attr( $category ); ?>"
						data-filter="<?php echo esc_attr( $events_filter ); ?>"
						class="load_more_btn vc_general vc_btn3 vc_btn3-size-lg vc_btn3-shape-rounded vc_btn3-style-outline vc_btn3-icon-left vc_btn3-color-theme_style_2">
						<i class="fa fa-refresh vc_btn3-icon" aria-hidden="true"></i>
						<?php esc_html_e( 'load more', 'consulting' ); ?>
					</a>
				<?php endif; ?>
			<?php else : ?>
				<?php if ( $load_more_enable && $posts_per_page < $published_posts ) : ?>
					<div class="event_btn_loading vc_general vc_btn3 vc_btn3-size-lg vc_btn3-shape-rounded vc_btn3-style-outline vc_btn3-icon-left vc_btn3-color-theme_style_2">
						<?php esc_html_e( 'loading...', 'consulting' ); ?>
					</div>
					<a href="#"
						data-page="1"
						data-load="<?php echo absint( $posts_per_page ); ?>"
						data-category="<?php echo esc_attr( $category ); ?>"
						data-filter="<?php echo esc_attr( $events_filter ); ?>"
						class="load_more_btn vc_general vc_btn3 vc_btn3-size-lg vc_btn3-shape-rounded vc_btn3-style-outline vc_btn3-icon-left vc_btn3-color-theme_style_2">
						<i class="fa fa-refresh vc_btn3-icon" aria-hidden="true"></i>
						<?php esc_html_e( 'load more', 'consulting' ); ?></a>
				<?php endif; ?>
			<?php endif; ?>
		</div>
	<?php elseif ( 'widget' === $event_style ) : ?>
		<div class="stm_events_widgets<?php echo esc_attr( $css_class ); ?>">
			<?php
			while ( $events->have_posts() ) :
				$events->the_post();
				get_template_part( 'partials/content-event', 'widgets' );
			endwhile;
			?>
		</div>
		<?php wp_reset_postdata(); ?>
	<?php endif; ?>
<?php endif; ?>
