<?php
/**
 * Template: Image Carousel (Elementor)
 *
 * @var bool $rtl
 * @var bool $loop
 * @var bool $nav
 * @var bool $dots
 * @var bool $autoplay
 * @var string $style
 * @var string $img_size
 * @var array $images
 */

$classes = array_filter(
	array(
		'stm-image-carousel',
		isset( $css_class ) && is_string( $css_class ) ? trim( $css_class ) : '',
		! empty( $grayscale ) ? 'grayscale' : '',
		! empty( $h_centered ) ? 'centered' : '',
		! empty( $el_class ) ? trim( $el_class ) : '',
	)
);

$wrapper_class = implode( ' ', array_unique( $classes ) );

$margin   = $margin ?? 0;
$speed    = $speed ?? 600;
$slide_by = $slide_by ?? 1;
$dots     = $dots ?? 0;

$items_phone         = $items_phone ?? 1;
$items_tablet        = $items_tablet ?? 2;
$items_small_desktop = $items_small_desktop ?? 3;
$items_desktop       = $items ?? 4;

$bool = static function( $v ): string {
	return ! empty( $v ) ? 'true' : 'false';
};

if ( empty( $images ) ) {
	$images = '-1,-2,-3';
}

$images = explode( ',', $images );

$instance_id = function_exists( 'wp_unique_id' ) ? wp_unique_id( 'image-carousel-' ) : ( 'image-carousel-' . uniqid() );

wp_enqueue_script( 'owl.carousel' );
wp_enqueue_style( 'owl.carousel' );

?>
<div id="<?php echo esc_attr( $instance_id ); ?>" class="vc_image_carousel_wr <?php echo esc_attr( $wrapper_class ); ?>">
	<div style="display: none;" class="vc_image_carousel <?php echo esc_html( $style ); ?>">
		<?php
		if ( ! empty( $images ) && is_array( $images ) ) :
			$link_num = 0;
			foreach ( $images as $item_id ) :
				$thumbnail = consulting_get_image( $item_id, $img_size );

				$link_url = '';

				if ( ! empty( $custom_links[ $link_num ] ) ) {
					$link_url = $custom_links[ $link_num ];
				}
				?>
				<div class="carousel-item" style="margin: 0 10px;">
					<?php if ( $link_url ) : ?>
						<a href="<?php echo esc_url( $link_url ); ?>">
							<?php echo wp_kses_post( 'string' === gettype( $thumbnail ) ? consulting_filtered_output( $thumbnail ) : consulting_filtered_output( $thumbnail['thumbnail'] ) ); ?>
						</a>
						<?php
					else :
						echo wp_kses_post( 'string' === gettype( $thumbnail ) ? consulting_filtered_output( $thumbnail ) : consulting_filtered_output( $thumbnail['thumbnail'] ) );
					endif;
					?>
				</div>
				<?php
				$link_num ++;
			endforeach;
		endif;
		?>
	</div>

	<script>
		(function( $ ) {
			$(document).ready(function () {
				const $el = $('#<?php echo esc_js( $instance_id ); ?> .vc_image_carousel');

				if (!$el.length) return;

				$el.show().owlCarousel({
					rtl: $('body').hasClass('rtl'),
					loop: <?php echo esc_js( $bool( $loop ) ); ?>,
					nav: <?php echo esc_js( $bool( $nav ) ); ?>,
					dots: <?php echo esc_js( $bool( $dots ) ); ?>,
					autoplay: <?php echo esc_js( $bool( $autoplay ) ); ?>,
					slideBy: <?php echo esc_js( $slide_by ); ?>,
					margin: <?php echo esc_js( $margin ); ?>,
					smartSpeed: <?php echo esc_js( $speed ); ?>,
					navText: [
						'<span class="owl-prev-icon" aria-hidden="true"></span>',
						'<span class="owl-next-icon" aria-hidden="true"></span>'
					],
					responsive: {
						0: {items: <?php echo esc_js( $items_phone ); ?> },
						768: {items: <?php echo esc_js( $items_tablet ); ?> },
						980: {items: <?php echo esc_js( $items_small_desktop ); ?> },
						1199: {items: <?php echo esc_js( $items_desktop ); ?> }
					}
				});
			});
		})(jQuery);
	</script>
</div>
