<?php
/**
 * Portfolio widget template
 *
 * @var $posts_per_page
 * @var $title
 * @var $dots
 * @var $loop
 * @var $nav
 * @var $items_mobile
 * @var $items_tablet
 * @var $items_small_desktop
 * @var $items
 * */

wp_enqueue_script( 'owl.carousel' );
wp_enqueue_style( 'owl.carousel' );

$args      = array(
	'post_type'      => 'stm_portfolio',
	'posts_per_page' => $posts_per_page,
	'post_status'    => 'published',
);
$portfolio = new WP_Query( $args );
if ( $portfolio->have_posts() ) :
	$owl_id = uniqid( 'owl-' );
	?>
<div class="portfolio-carousel">
	<?php if ( ! empty( $title ) ) : ?>
		<h2 class="portfolio-carousel__title text-center"><?php echo esc_html( $title ); ?></h2>
	<?php endif; ?>
	<div class="portfolio-carousel__wrap" id="<?php echo esc_attr( $owl_id ); ?>">
		<?php
		while ( $portfolio->have_posts() ) :
			$portfolio->the_post();
			$categories = wp_get_post_terms(
				get_the_ID(),
				'stm_portfolio_category',
				array(
					'fields' => 'names',
				)
			);
			?>
		<a href="<?php the_permalink(); ?>" class="portfolio-carousel__item">
			<span class="portfolio-carousel__item-image"><?php the_post_thumbnail( 'consulting-image-358x250-cropped' ); ?></span>
			<span class="portfolio-carousel__item-title"><?php the_title(); ?></span>
			<span class="portfolio-carousel__item-category"><?php echo esc_html( implode( ', ', $categories ) ); ?></span>
		</a>
		<?php endwhile; ?>
	</div>
</div>
<script>
	jQuery(function($) {
		<?php
		$options = array(
			'dots'       => (bool) ( $dots ?? false ),
			'loop'       => (bool) ( $loop ?? false ),
			'nav'        => (bool) ( $nav ?? false ),
			'responsive' => array(
				0    => array( 'items' => (int) $items_mobile ),
				768  => array( 'items' => (int) $items_tablet ),
				980  => array( 'items' => (int) $items_small_desktop ),
				1199 => array( 'items' => (int) $items ),
			),
		);
		?>

		var carouselOptions = Object( <?php echo wp_json_encode( $options, JSON_UNESCAPED_SLASHES ); ?> );

		$('#<?php echo esc_js( $owl_id ); ?>').owlCarousel( carouselOptions );
	});
</script>
<?php endif; ?>
