<?php
/**
 * @var int    $count
 * @var string $category
 * @var string $css_class
 * @var string $carousel_arrows
 * @var int    $slides_to_show
 * @var string $carousel_style
 * @var string $items_title
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_enqueue_script( 'slick' );
wp_enqueue_style( 'slick' );

$carousel_id = 'staff_carousel_' . wp_generate_uuid4();
$arrows_id   = "staff_carousel_arrows_{$carousel_id}";

$args = array(
	'post_type'      => 'stm_staff',
	'posts_per_page' => absint( $count ),
);

if ( ! empty( $category ) && 'all' !== $category ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'stm_staff_category',
			'field'    => 'slug',
			'terms'    => sanitize_text_field( $category ),
		),
	);
}

$staff_query = new WP_Query( $args );
?>

<div class="staff_carousel_container <?php echo esc_attr( "$css_class $carousel_style" ); ?>">
	<?php if ( 'yes' === $carousel_arrows ) : ?>
		<div id="<?php echo esc_attr( $arrows_id ); ?>" class="staff-carousel-arrows">
			<div class="staff-carousel-arrows-inner"></div>
		</div>
	<?php endif; ?>

	<div class="staff_carousel-box">
		<?php if ( $staff_query->have_posts() ) : ?>
		<div class="staff_carousel" id="<?php echo esc_attr( $carousel_id ); ?>">
			<?php
			while ( $staff_query->have_posts() ) :
				$staff_query->the_post();

				$_post_id   = get_the_ID();
				$permalink  = get_permalink( $_post_id );
				$department = get_post_meta( $_post_id, 'department', true );
				?>
				<div class="staff_carousel_item">
					<div class="staff_carousel_item_wrap">
						<div class="staff_info">
							<?php if ( $items_title ) : ?>
								<div class="items_title">
									<?php echo esc_html( $items_title ); ?>
								</div>
							<?php endif; ?>

							<h2 class="no_stripe">
								<?php the_title(); ?>
							</h2>

							<?php if ( $department ) : ?>
								<div class="staff_department">
									<?php echo esc_html( $department ); ?>
								</div>
							<?php endif; ?>

							<div class="staff_excerpt">
								<?php echo wp_kses_post( consulting_substr_text( get_the_excerpt(), 330 ) ); ?>
							</div>

							<a href="<?php echo esc_url( $permalink ); ?>" class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-rounded vc_btn3-style-flat vc_btn3-color-theme_style_1">
								<?php esc_html_e( 'Read more', 'consulting' ); ?>
							</a>
						</div>
						<?php if ( has_post_thumbnail() && ! wp_is_mobile() ) : ?>
							<div class="staff_image">
								<?php the_post_thumbnail( 'consulting-image-900w' ); ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
			?>
		</div>
		<?php else : ?>
			<p><?php esc_html_e( 'No employees to display', 'consulting' ); ?></p>
		<?php endif; ?>
	</div>
</div>

<script type="text/javascript">
	jQuery(document).ready(function ($) {
		const carouselId = '<?php echo esc_js( $carousel_id ); ?>';
		const arrowsId = '<?php echo esc_js( $arrows_id ); ?>';
		const showArrows = Boolean( <?php echo esc_js( 'yes' === $carousel_arrows ); ?> );
		const slidesToShow = Number( <?php echo esc_js( $slides_to_show ?? 1 ); ?> );

		const $carousel = $(`#${carouselId}`);

		$carousel.slick({
			rtl: 		  $('body').hasClass('rtl'),
			dots: 		  false,
			infinite: 	  true,
			arrows: 	  showArrows,
			slidesToShow: slidesToShow,
			cssEase: 	  "cubic-bezier(0.455, 0.030, 0.515, 0.955)",
			appendArrows: showArrows ? `#${arrowsId} .staff-carousel-arrows-inner` : null,
			prevArrow:    showArrows ? '<div class="slick_prev"><i class="fa fa-chevron-left"></i></div>' : null,
			nextArrow:    showArrows ? '<div class="slick_next"><i class="fa fa-chevron-right"></i></div>' : null
		});

		$carousel.on( 'setPosition', function (event, slick) {
			slick.$slides.css('height', slick.$slideTrack.height() + 'px');
		});
	});
</script>
