<?php
/**
 * @var int    $count
 * @var string $category
 * @var string $css_class
 * @var string $carousel_arrows
 * @var int    $slides_to_show
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_enqueue_script( 'slick' );
wp_enqueue_style( 'slick' );

$carousel_id = 'staff_carousel_' . wp_generate_uuid4();
$arrows_id   = "staff_carousel_arrows_{$carousel_id}";

$args = array(
	'post_type'      => 'stm_staff',
	'posts_per_page' => absint( $count ),
);

if ( ! empty( $category ) && 'all' !== $category ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'stm_staff_category',
			'field'    => 'slug',
			'terms'    => sanitize_text_field( $category ),
		),
	);
}

$query = new WP_Query( $args );
?>

<div class="staff_carousel_container <?php echo esc_attr( $css_class ); ?>">
	<?php if ( 'yes' === $carousel_arrows ) : ?>
		<div id="<?php echo esc_attr( $arrows_id ); ?>" class="staff_carousel_arrows">
			<div class="staff_carousel_arrows_inner"></div>
		</div>
	<?php endif; ?>

	<div class="staff_carousel-box">
		<?php if ( $query->have_posts() ) : ?>
			<div class="staff_carousel" id="<?php echo esc_attr( $carousel_id ); ?>">
				<?php
				while ( $query->have_posts() ) :
					$query->the_post();
					$_post_id   = get_the_ID();
					$permalink  = get_permalink( $_post_id );
					$department = get_post_meta( $_post_id, 'department', true );
					?>
					<div class="staff_carousel_item">
						<?php if ( has_post_thumbnail() ) : ?>
							<div class="staff_image">
								<a href="<?php echo esc_url( $permalink ); ?>">
									<?php the_post_thumbnail( 'full' ); ?>
								</a>
							</div>
						<?php endif; ?>

						<div class="staff_info">
							<h5 class="no_stripe">
								<a href="<?php echo esc_url( $permalink ); ?>" class="text_decoration_none secondary_font_color_hv">
									<?php the_title(); ?>
								</a>
							</h5>
							<?php if ( $department ) : ?>
								<div class="staff_department"><?php echo esc_html( $department ); ?></div>
							<?php endif; ?>
						</div>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		<?php else : ?>
			<p><?php esc_html_e( 'No employees to display', 'consulting' ); ?></p>
		<?php endif; ?>
	</div>
</div>

<script type="text/javascript">
	jQuery(document).ready(function($) {
		const carouselId = '<?php echo esc_js( $carousel_id ); ?>';
		const arrowsId = '<?php echo esc_js( $arrows_id ); ?>';
		const showArrows = Boolean( <?php echo esc_js( 'yes' === $carousel_arrows ); ?> );
		const slidesToShow = Number( <?php echo esc_js( $slides_to_show ); ?> );

		const $carousel = $(`#${carouselId}`);

		$carousel.slick({
			rtl: 		  $('body').hasClass('rtl'),
			dots: 		  false,
			infinite: 	  true,
			arrows: 	  showArrows,
			slidesToShow: slidesToShow,
			cssEase: 	  'cubic-bezier(0.455, 0.030, 0.515, 0.955)',
			responsive:   [
				{
					breakpoint: 769,
					settings: { slidesToShow: 2 }
				},
				{
					breakpoint: 560,
					settings: { slidesToShow: 1 }
				}
			],
			appendArrows: `#${arrowsId} .staff_carousel_arrows_inner`,
			prevArrow:    showArrows ? '<div class="slick_prev"><i class="fa fa-chevron-left"></i></div>' : null,
			nextArrow:    showArrows ? '<div class="slick_next"><i class="fa fa-chevron-right"></i></div>' : null
		});
	});
</script>
