<?php

wp_enqueue_script( 'slick' );
wp_enqueue_style( 'slick' );

if ( ! empty( $style ) ) {
	$css_class .= ' ' . esc_attr( $style );
}

$args = array(
	'post_type'      => 'stm_testimonials',
	'posts_per_page' => $count,
);

if ( 'all' !== $category ) {
	$args['stm_testimonials_category'] = $category;
}

if ( $disable_carousel ) {
	$css_class .= ' disable_carousel';
}

if ( empty( $thumb_size ) ) {
	$thumb_size = 'full';
}

$testimonials = new WP_Query( $args );
$id           = uniqid( 'partners_carousel_' );

$autoplay_carousel_js = 'false';
if ( ! empty( $autoplay_carousel ) && 'yes' === $autoplay_carousel ) {
	$autoplay_carousel_js = 'true';
}
?>
<?php if ( $testimonials->have_posts() ) : ?>
	<div class="testimonials_carousel_container">
		<div class="<?php echo esc_attr( $css_class ); ?>" id="<?php echo esc_attr( $id ); ?>">
				<?php
				while ( $testimonials->have_posts() ) :
					$testimonials->the_post();
					?>
				<div class="testimonial">
					<div class="testimonial_inner">
						<div class="testimonial_wrapper">
							<div class="info">
								<div class="stm_testimonials_content_unit"><?php the_excerpt(); ?></div>
								<h6 class="no_stripe testimonial_name">
									<?php if ( $link['url'] ) : ?>
										<a href="<?php echo esc_url( $link['url'] ); ?>">
											<?php the_title(); ?>
										</a>
										<?php
									else :
											the_title();
									endif;
									?>
								</h6>
								<div class="position">
									<?php
										$position = get_post_meta( get_the_ID(), 'testimonial_position', true );
									if ( $position ) {
										echo esc_html( $position ) . ', ';
									}
										echo esc_html( get_post_meta( get_the_ID(), 'testimonial_company', true ) );
									?>
								</div>
							</div>
							<?php
							if ( ! $disable_image && has_post_thumbnail() ) {
								$author_photo = consulting_get_image( get_post_thumbnail_id(), $thumb_size );
								?>
								<div class="image">
									<?php if ( $link['url'] ) { ?>
										<a href="<?php echo esc_url( $link['url'] ); ?>"><?php echo wp_kses_post( $author_photo ); ?></a>
										<?php
									} else {
										echo wp_kses_post( $author_photo );
									}
									?>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
			<?php endwhile; ?>
		</div>
		<div class="testimonial_slider_navigation"></div>
	</div>

	<?php if ( ! $disable_carousel ) : ?>
		<script type="text/javascript">
			jQuery(document).ready(function ($) {
				"use strict";
				var <?php echo esc_attr( $id ); ?> =
				$("#<?php echo esc_attr( $id ); ?>");
				var slickRtl = false;

				if ($('body').hasClass('rtl')) {
					slickRtl = true;
				}

				<?php echo esc_attr( $id ); ?>.
				slick({
					rtl: slickRtl,
					dots: <?php echo ( stm_check_layout( 'layout_ankara' ) ) ? 'true' : 'false'; ?>,
					infinite: true,
					<?php
					if ( ! $disable_carousel_arrows ) {
						echo 'arrows: true,';
						echo 'prevArrow:"<div class=\"testimonial_prev\"><i class=\"fa fa-chevron-left\"></i></div>",';
						echo 'nextArrow: "<div class=\"testimonial_next\"><i class=\"fa fa-chevron-right\"></i></div>",';
					} else {
						echo 'arrows: false,';
					}
					?>
					appendArrows: $(".testimonial_slider_navigation"),
					autoplaySpeed: 5000,
					autoplay: <?php echo esc_js( $autoplay_carousel_js ); ?>,
					slidesToShow: 1,
					cssEase: "cubic-bezier(0.455, 0.030, 0.515, 0.955)",
					responsive: [
						{
							breakpoint: 769,
							settings: {
								slidesToShow: 1
							}
						}
					]
				}).on('setPosition', function (event, slick) {
					slick.$slides.css('height', slick.$slideTrack.height() + 'px');
				});
			});
		</script>
		<?php
	endif;
endif;
wp_reset_postdata();
?>
