<?php
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this
 */

$atts              = vc_map_get_attributes( $this->getShortcode(), $atts );
$atts['css_class'] = apply_filters(
	VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG,
	vc_shortcode_custom_css_class( $atts['css'] ?? '', ' ' )
);

$shortcode_map = WPBMap::getShortCode( 'stm_works' );

$allowed_styles    = array();
$allowed_substyles = array();

if ( ! empty( $shortcode_map['params'] ) ) {
	foreach ( $shortcode_map['params'] as $param ) {
		if ( isset( $param['param_name'], $param['value'] ) ) {
			if ( 'style' === $param['param_name'] ) {
				$allowed_styles = array_values( $param['value'] );
			}
			if ( str_ends_with( $param['param_name'], '_style' ) ) {
				$allowed_substyles = array_merge( $allowed_substyles, array_values( $param['value'] ) );
			}
		}
	}
}

$allowed_styles    = array_unique( array_map( 'sanitize_key', $allowed_styles ) );
$allowed_substyles = array_unique( array_map( 'sanitize_key', $allowed_substyles ) );

$atts['style'] = basename( sanitize_file_name( $atts['style'] ?? 'grid' ) );
if ( ! in_array( $atts['style'], $allowed_styles, true ) ) {
	$atts['style'] = 'grid';
}

$substyle_key = $atts['style'] . '_style';
$substyle_raw = $atts[ $substyle_key ] ?? 'style_1';
$substyle     = basename( sanitize_file_name( $substyle_raw ) );

if ( ! in_array( $substyle, $allowed_substyles, true ) ) {
	$substyle = 'style_1';
}

consulting_load_vc_element( 'works/' . $atts['style'], $atts, $substyle );
