<?php
/**
 * Video widget template (WPBakery/Visual Composer)
 *
 * @var array $atts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp_embed;

$defaults = array(
	'title'       => '',
	'link'        => 'https://vimeo.com/92033601',
	'size'        => '400',
	'height_size' => '400',
	'el_class'    => '',
	'image'       => '',
	'button_text' => '',
	'img_size'    => 'thumb-540x320',
	'css'         => '',
);

$atts = shortcode_atts( $defaults, $atts, $this->getShortcode() );

$_title      = (string) $atts['title'];
$_link       = (string) $atts['link'];
$size        = (int) $atts['size'];
$height_size = (int) $atts['height_size'];
$el_class    = (string) $atts['el_class'];
$image       = (int) $atts['image'];
$button_text = (string) $atts['button_text'];
$img_size    = (string) $atts['img_size'];
$css         = (string) $atts['css'];

if ( empty( $_link ) ) {
	return null;
}

$thumbnail = wpb_getImageBySize(
	array(
		'attach_id'  => $image,
		'thumb_size' => $img_size,
	)
);

$el_class = $this->getExtraClass( $el_class );

$video_w = $size;
$video_h = $height_size;
$embed   = '';
if ( is_object( $wp_embed ) ) {
	$embed = '<iframe src="' . esc_url( $_link ) . '" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen allow="autoplay"></iframe>';
}
/** @var WP_Embed $wp_embed  */
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'wpb_video_widget wpb_content_element' . $el_class . $el_class . vc_shortcode_custom_css_class( $css, ' ' ), $this->settings['base'], $atts );

if ( empty( $thumbnail['thumbnail'] ) ) {
	$css_class .= ' has_no_poster';
}


$output  = "\n\t" . '<div class="' . esc_attr( $css_class ) . '">';
$output .= "\n\t\t" . '<div class="wpb_wrapper">';
$output .= wpb_widget_title(
	array(
		'title'      => $_title,
		'extraclass' => 'wpb_video_heading',
	)
);
$output .= '<div class="wpb_video_wrapper">';
if ( ! empty( $thumbnail['thumbnail'] ) ) {
	if ( stm_check_layout( 'layout_20' ) ) {
		$output .= sprintf( '<div class="thumbnail_wrap">%s</div><a href="#" class="play_video">%s</a>', $thumbnail['thumbnail'], esc_html( $button_text ) );
	} else {
		if ( stm_check_layout( 'layout_ankara' ) ) {
			$output .= $thumbnail['thumbnail'] . '<a href="#" class="play_video"><span class="waves"></span></a>';
		} else {
			$output .= $thumbnail['thumbnail'] . '<a href="#" class="play_video"></a>';
		}
	}
	$output .= '<div class="video" style="display: none; width: ' . esc_attr( $video_w ) . 'px; height: ' . esc_attr( $video_h ) . 'px;">' . $embed . '</div>';
} else {
	$output .= '<div class="video" style="width: ' . esc_attr( $video_w ) . 'px; height: ' . esc_attr( $video_h ) . 'px;">' . $embed . '</div>';
}
$output .= '</div>'; // .wpb_video_wrapper
$output .= "\n\t\t" . '</div><!-- .wpb_wrapper -->';
$output .= "\n\t" . '</div><!-- .wpb_video_widget -->';

echo consulting_filtered_output( $output ); // phpcs:ignore
