<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' ); ?>
<?php
$sidebar_type = consulting_theme_option( 'shop_sidebar_type', 'wp' );
if ( 'wp' === $sidebar_type ) {
	$sidebar_id = consulting_theme_option( 'shop_wp_sidebar', 'consulting-shop' );
} else {
	$sidebar_id = consulting_theme_option( 'shop_vc_sidebar' );
}
if ( ! empty( $_GET['sidebar_id'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	$sidebar_id = $_GET['sidebar_id']; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
}
$structure = consulting_get_structure( $sidebar_id, $sidebar_type, consulting_theme_option( 'shop_sidebar_position', 'right' ) );

echo consulting_filtered_output( $structure['content_before'] ); //phpcs:ignore
if ( 'off' !== get_post_meta( get_option( 'woocommerce_shop_page_id' ), 'disable_title', true ) ) :
	?>
	<h1 class="h2 page_title_2"><?php consulting_page_title( true, esc_html__( 'News', 'consulting' ), esc_html__( 'Careers', 'consulting' ) ); ?></h1>
	<?php
endif;

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );
?>

<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>

	<h1 class="page-title"><?php woocommerce_page_title(); ?></h1>

<?php endif; ?>

<?php
/**
 * Hook: woocommerce_archive_description.
 *
 * @hooked woocommerce_taxonomy_archive_description - 10
 * @hooked woocommerce_product_archive_description - 10
 */
do_action( 'woocommerce_archive_description' );
?>

<?php
if ( have_posts() ) :

	/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked woocommerce_output_all_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	do_action( 'woocommerce_before_shop_loop' );

	woocommerce_product_loop_start();

	while ( have_posts() ) :
		the_post();
		?>

		<?php wc_get_template_part( 'content', 'product' ); ?>

	<?php endwhile; // end of the loop. ?>

	<?php woocommerce_product_loop_end(); ?>

	<?php
	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
	?>

	<?php
elseif ( ! woocommerce_output_product_categories(
	array(
		'before' => woocommerce_product_loop_start( false ),
		'after'  => woocommerce_product_loop_end( false ),
	)
)
) :
	wc_get_template( 'loop/no-products-found.php' );

endif;

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

echo consulting_filtered_output( $structure['content_after'] ); //phpcs:ignore
echo consulting_filtered_output( $structure['sidebar_before'] ); //phpcs:ignore

if ( $sidebar_id ) {
	if ( 'wp' === $sidebar_type ) {
		$sidebar = true;
	} else {
		$sidebar = get_post( $sidebar_id );
	}
}
if ( isset( $sidebar ) ) {
	if ( 'vc' === $sidebar_type ) {
		?>
		<div class="sidebar-area stm_sidebar">
			<style type="text/css">
				<?php echo get_post_meta( $sidebar_id, '_wpb_shortcodes_custom_css', true ); //phpcs:ignore ?>
			</style>
			<?php echo apply_filters( 'the_content', $sidebar->post_content ); //phpcs:ignore ?>
		</div>
	<?php } else { ?>
		<div class="sidebar-area default_widgets">
			<?php dynamic_sidebar( $sidebar_id ); ?>
		</div>
		<?php
	}
}

echo consulting_filtered_output( $structure['sidebar_after'] ); //phpcs:ignore
get_footer( 'shop' );
