<?php
/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$customer_id = get_current_user_id();

if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing'  => __( 'Billing Address', 'consulting' ),
			'shipping' => __( 'Shipping Address', 'consulting' ),
		),
		$customer_id
	);
} else {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing' => __( 'Billing Address', 'consulting' ),
		),
		$customer_id
	);
}

$oldcol = 1;
$col    = 1;
?>

<p class="myaccount_address">
	<?php echo apply_filters( 'woocommerce_my_account_my_address_description', esc_html__( 'The following addresses will be used on the checkout page by default.', 'consulting' ) ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
</p>
<br/>
<?php
if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	echo '<div class="col2-set addresses">';
}
foreach ( $get_addresses as $name => $title ) :
	$col    = $col * -1;
	$oldcol = $oldcol * -1;
	?>

	<div class="u-column<?php echo ( $col < 0 ) ? 1 : 2; ?> col-<?php echo ( $oldcol < 0 ) ? 1 : 2; ?> woocommerce-Address address">
		<header class="woocommerce-Address-title title media">
			<h4 class="media-body media-middle"><?php echo esc_html( $title ); ?></h4>
			<div class="media-right media-middle"><a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>" class="edit button icon_left size-sm bordered"><i class="fa fa-pencil-square-o"></i> <?php esc_html_e( 'edit', 'consulting' ); ?></a></div>
		</header>
		<address>
			<?php
				$address = apply_filters(
					'woocommerce_my_account_my_address_formatted_address',
					array(
						'first_name' => get_user_meta( $customer_id, $name . '_first_name', true ),
						'last_name'  => get_user_meta( $customer_id, $name . '_last_name', true ),
						'company'    => get_user_meta( $customer_id, $name . '_company', true ),
						'address_1'  => get_user_meta( $customer_id, $name . '_address_1', true ),
						'address_2'  => get_user_meta( $customer_id, $name . '_address_2', true ),
						'city'       => get_user_meta( $customer_id, $name . '_city', true ),
						'state'      => get_user_meta( $customer_id, $name . '_state', true ),
						'postcode'   => get_user_meta( $customer_id, $name . '_postcode', true ),
						'country'    => get_user_meta( $customer_id, $name . '_country', true ),
					),
					$customer_id,
					$name
				);

				$formatted_address = WC()->countries->get_formatted_address( $address );

			if ( ! $formatted_address ) {
				esc_html_e( 'You have not set up this type of address yet.', 'consulting' );
			} else {
				echo esc_html( $formatted_address );
			}
			?>
		</address>
	</div>

	<?php
endforeach;
if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	echo '</div>';
}
?>
