<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' );

$product = wc_get_product( get_the_ID() );

if ( 'stm_zoom' === $product->get_type() ) { ?>

	<?php
		/**
		 * woocommerce_before_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		do_action( 'woocommerce_before_main_content' );
	?>

		<?php while ( have_posts() ) : ?>
			<?php the_post(); ?>

			<?php wc_get_template_part( 'content', 'single-product' ); ?>

		<?php endwhile; // end of the loop. ?>

	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>

	<?php
		/**
		 * woocommerce_sidebar hook.
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		do_action( 'woocommerce_sidebar' );
	?>

<?php } else { ?>
	<?php
	$sidebar_type = consulting_theme_option( 'shop_sidebar_type', 'wp' );
	if ( 'wp' === $sidebar_type ) {
		$sidebar_id = consulting_theme_option( 'shop_wp_sidebar', 'consulting-shop' );
	} else {
		$sidebar_id = consulting_theme_option( 'shop_vc_sidebar' );
	}
	if ( ! empty( $_GET['sidebar_id'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$sidebar_id = $_GET['sidebar_id']; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	}
	$structure = consulting_get_structure( $sidebar_id, $sidebar_type, consulting_theme_option( 'shop_sidebar_position', 'right' ) );

	echo consulting_filtered_output( $structure['content_before'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	if ( 'off' !== get_post_meta( get_the_ID(), 'disable_title', true ) ) :
		?>
		<h1 class="h2 page_title_2"><?php consulting_page_title( true, esc_html__( 'News', 'consulting' ), esc_html__( 'Careers', 'consulting' ) ); ?></h1>
		<?php
	endif;

	/**
	 * woocommerce_before_main_content hook.
	 *
	 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
	 * @hooked woocommerce_breadcrumb - 20
	 */
	do_action( 'woocommerce_before_main_content' );

	while ( have_posts() ) :
		the_post();
		wc_get_template_part( 'content', 'single-product' );
	endwhile; // end of the loop.

	/**
	 * woocommerce_after_main_content hook.
	 *
	 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
	 */
	do_action( 'woocommerce_after_main_content' );

	echo consulting_filtered_output( $structure['content_after'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo consulting_filtered_output( $structure['sidebar_before'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	if ( $sidebar_id ) {
		if ( 'wp' === $sidebar_type ) {
			$sidebar = true;
		} else {
			$sidebar = get_post( $sidebar_id );
		}
	}
	if ( isset( $sidebar ) ) {
		if ( 'vc' === $sidebar_type ) {
			?>
			<div class="sidebar-area stm_sidebar">
				<style type="text/css">
					<?php echo get_post_meta( $sidebar_id, '_wpb_shortcodes_custom_css', true ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</style>
				<?php echo apply_filters( 'the_content', $sidebar->post_content ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			</div>
		<?php } else { ?>
			<div class="sidebar-area default_widgets">
				<?php dynamic_sidebar( $sidebar_id ); ?>
			</div>
			<?php
		}
	}
	echo consulting_filtered_output( $structure['sidebar_after'] ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
}
get_footer( 'shop' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
